package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IngressServiceBackendFluent<A extends IngressServiceBackendFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public ServiceBackendPort getPort();
    public ServiceBackendPort buildPort();
    public A withPort(ServiceBackendPort port);
    public Boolean hasPort();
    public A withNewPort(String name,Integer number);
    public IngressServiceBackendFluent.PortNested<A> withNewPort();
    public IngressServiceBackendFluent.PortNested<A> withNewPortLike(ServiceBackendPort item);
    public IngressServiceBackendFluent.PortNested<A> editPort();
    public IngressServiceBackendFluent.PortNested<A> editOrNewPort();
    public IngressServiceBackendFluent.PortNested<A> editOrNewPortLike(ServiceBackendPort item);
    public interface PortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceBackendPortFluent<IngressServiceBackendFluent.PortNested<N>> {

        public N and();
        public N endPort();    }


}
