
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "BaseKubernetesList",
    "CreateOptions",
    "DeleteOptions",
    "GetOptions",
    "Info",
    "Ingress",
    "IngressClass",
    "IngressClassList",
    "IngressList",
    "ListOptions",
    "NetworkPolicy",
    "NetworkPolicyList",
    "ObjectMeta",
    "ObjectReference",
    "Patch",
    "PatchOptions",
    "Quantity",
    "RootPaths",
    "Status",
    "Time",
    "TypeMeta",
    "UpdateOptions",
    "V1Ingress",
    "V1IngressClass",
    "V1IngressClassList",
    "V1IngressList"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("Ingress")
    private io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress;
    /**
     * 
     * 
     */
    @JsonProperty("IngressClass")
    private io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass ingressClass;
    /**
     * 
     * 
     */
    @JsonProperty("IngressClassList")
    private io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList ingressClassList;
    /**
     * 
     * 
     */
    @JsonProperty("IngressList")
    private io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList ingressList;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicy")
    private NetworkPolicy networkPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicyList")
    private NetworkPolicyList networkPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectReference")
    private io.fabric8.kubernetes.api.model.ObjectReference objectReference;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    /**
     * 
     * 
     */
    @JsonProperty("V1Ingress")
    private io.fabric8.kubernetes.api.model.networking.v1.Ingress v1Ingress;
    /**
     * 
     * 
     */
    @JsonProperty("V1IngressClass")
    private io.fabric8.kubernetes.api.model.networking.v1.IngressClass v1IngressClass;
    /**
     * 
     * 
     */
    @JsonProperty("V1IngressClassList")
    private io.fabric8.kubernetes.api.model.networking.v1.IngressClassList v1IngressClassList;
    /**
     * 
     * 
     */
    @JsonProperty("V1IngressList")
    private io.fabric8.kubernetes.api.model.networking.v1.IngressList v1IngressList;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param ingressList
     * @param baseKubernetesList
     * @param ingressClass
     * @param updateOptions
     * @param patch
     * @param ingressClassList
     * @param rootPaths
     * @param v1Ingress
     * @param info
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param networkPolicyList
     * @param networkPolicy
     * @param objectReference
     * @param createOptions
     * @param aPIGroup
     * @param ingress
     * @param typeMeta
     * @param objectMeta
     * @param getOptions
     * @param time
     * @param v1IngressClass
     * @param v1IngressClassList
     * @param v1IngressList
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, BaseKubernetesList baseKubernetesList, CreateOptions createOptions, DeleteOptions deleteOptions, GetOptions getOptions, Info info, io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress, io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass ingressClass, io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList ingressClassList, io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList ingressList, ListOptions listOptions, NetworkPolicy networkPolicy, NetworkPolicyList networkPolicyList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, io.fabric8.kubernetes.api.model.ObjectReference objectReference, Patch patch, PatchOptions patchOptions, Quantity quantity, RootPaths rootPaths, Status status, String time, TypeMeta typeMeta, UpdateOptions updateOptions, io.fabric8.kubernetes.api.model.networking.v1.Ingress v1Ingress, io.fabric8.kubernetes.api.model.networking.v1.IngressClass v1IngressClass, io.fabric8.kubernetes.api.model.networking.v1.IngressClassList v1IngressClassList, io.fabric8.kubernetes.api.model.networking.v1.IngressList v1IngressList) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.baseKubernetesList = baseKubernetesList;
        this.createOptions = createOptions;
        this.deleteOptions = deleteOptions;
        this.getOptions = getOptions;
        this.info = info;
        this.ingress = ingress;
        this.ingressClass = ingressClass;
        this.ingressClassList = ingressClassList;
        this.ingressList = ingressList;
        this.listOptions = listOptions;
        this.networkPolicy = networkPolicy;
        this.networkPolicyList = networkPolicyList;
        this.objectMeta = objectMeta;
        this.objectReference = objectReference;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.quantity = quantity;
        this.rootPaths = rootPaths;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.v1Ingress = v1Ingress;
        this.v1IngressClass = v1IngressClass;
        this.v1IngressClassList = v1IngressClassList;
        this.v1IngressList = v1IngressList;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The ingress
     */
    @JsonProperty("Ingress")
    public io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress getIngress() {
        return ingress;
    }

    /**
     * 
     * 
     * @param ingress
     *     The Ingress
     */
    @JsonProperty("Ingress")
    public void setIngress(io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress) {
        this.ingress = ingress;
    }

    /**
     * 
     * 
     * @return
     *     The ingressClass
     */
    @JsonProperty("IngressClass")
    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass getIngressClass() {
        return ingressClass;
    }

    /**
     * 
     * 
     * @param ingressClass
     *     The IngressClass
     */
    @JsonProperty("IngressClass")
    public void setIngressClass(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass ingressClass) {
        this.ingressClass = ingressClass;
    }

    /**
     * 
     * 
     * @return
     *     The ingressClassList
     */
    @JsonProperty("IngressClassList")
    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList getIngressClassList() {
        return ingressClassList;
    }

    /**
     * 
     * 
     * @param ingressClassList
     *     The IngressClassList
     */
    @JsonProperty("IngressClassList")
    public void setIngressClassList(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList ingressClassList) {
        this.ingressClassList = ingressClassList;
    }

    /**
     * 
     * 
     * @return
     *     The ingressList
     */
    @JsonProperty("IngressList")
    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList getIngressList() {
        return ingressList;
    }

    /**
     * 
     * 
     * @param ingressList
     *     The IngressList
     */
    @JsonProperty("IngressList")
    public void setIngressList(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList ingressList) {
        this.ingressList = ingressList;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public NetworkPolicy getNetworkPolicy() {
        return networkPolicy;
    }

    /**
     * 
     * 
     * @param networkPolicy
     *     The NetworkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public void setNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public NetworkPolicyList getNetworkPolicyList() {
        return networkPolicyList;
    }

    /**
     * 
     * 
     * @param networkPolicyList
     *     The NetworkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public void setNetworkPolicyList(NetworkPolicyList networkPolicyList) {
        this.networkPolicyList = networkPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The objectReference
     */
    @JsonProperty("ObjectReference")
    public io.fabric8.kubernetes.api.model.ObjectReference getObjectReference() {
        return objectReference;
    }

    /**
     * 
     * 
     * @param objectReference
     *     The ObjectReference
     */
    @JsonProperty("ObjectReference")
    public void setObjectReference(io.fabric8.kubernetes.api.model.ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The v1Ingress
     */
    @JsonProperty("V1Ingress")
    public io.fabric8.kubernetes.api.model.networking.v1.Ingress getV1Ingress() {
        return v1Ingress;
    }

    /**
     * 
     * 
     * @param v1Ingress
     *     The V1Ingress
     */
    @JsonProperty("V1Ingress")
    public void setV1Ingress(io.fabric8.kubernetes.api.model.networking.v1.Ingress v1Ingress) {
        this.v1Ingress = v1Ingress;
    }

    /**
     * 
     * 
     * @return
     *     The v1IngressClass
     */
    @JsonProperty("V1IngressClass")
    public io.fabric8.kubernetes.api.model.networking.v1.IngressClass getV1IngressClass() {
        return v1IngressClass;
    }

    /**
     * 
     * 
     * @param v1IngressClass
     *     The V1IngressClass
     */
    @JsonProperty("V1IngressClass")
    public void setV1IngressClass(io.fabric8.kubernetes.api.model.networking.v1.IngressClass v1IngressClass) {
        this.v1IngressClass = v1IngressClass;
    }

    /**
     * 
     * 
     * @return
     *     The v1IngressClassList
     */
    @JsonProperty("V1IngressClassList")
    public io.fabric8.kubernetes.api.model.networking.v1.IngressClassList getV1IngressClassList() {
        return v1IngressClassList;
    }

    /**
     * 
     * 
     * @param v1IngressClassList
     *     The V1IngressClassList
     */
    @JsonProperty("V1IngressClassList")
    public void setV1IngressClassList(io.fabric8.kubernetes.api.model.networking.v1.IngressClassList v1IngressClassList) {
        this.v1IngressClassList = v1IngressClassList;
    }

    /**
     * 
     * 
     * @return
     *     The v1IngressList
     */
    @JsonProperty("V1IngressList")
    public io.fabric8.kubernetes.api.model.networking.v1.IngressList getV1IngressList() {
        return v1IngressList;
    }

    /**
     * 
     * 
     * @param v1IngressList
     *     The V1IngressList
     */
    @JsonProperty("V1IngressList")
    public void setV1IngressList(io.fabric8.kubernetes.api.model.networking.v1.IngressList v1IngressList) {
        this.v1IngressList = v1IngressList;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
