package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressServiceBackendBuilder extends IngressServiceBackendFluentImpl<IngressServiceBackendBuilder> implements VisitableBuilder<IngressServiceBackend,IngressServiceBackendBuilder> {

    IngressServiceBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressServiceBackendBuilder() { 
        this(true);
    }


    public IngressServiceBackendBuilder(Boolean validationEnabled) { 
        this(new IngressServiceBackend(), validationEnabled);
    }


    public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent) { 
        this(fluent, true);
    }


    public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new IngressServiceBackend(), validationEnabled);
    }


    public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,IngressServiceBackend instance) { 
        this(fluent, instance, true);
    }


    public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,IngressServiceBackend instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressServiceBackendBuilder(IngressServiceBackend instance) { 
        this(instance,true);
    }


    public IngressServiceBackendBuilder(IngressServiceBackend instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressServiceBackend build() {
        IngressServiceBackend buildable = new IngressServiceBackend(fluent.getName(),fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressServiceBackendBuilder that = (IngressServiceBackendBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
