package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TargetBuilder extends TargetFluent<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder>{
  public TargetBuilder() {
    this(new Target());
  }
  
  public TargetBuilder(TargetFluent<?> fluent) {
    this(fluent, new Target());
  }
  
  public TargetBuilder(TargetFluent<?> fluent,Target instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TargetBuilder(Target instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TargetFluent<?> fluent;
  
  public Target build() {
    Target buildable = new Target(fluent.getApiVersion(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}