package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PatchFluent<A extends PatchFluent<A>> extends BaseFluent<A>{
  public PatchFluent() {
  }
  
  public PatchFluent(Patch instance) {
    this.copyInstance(instance);
  }
  private Map<String,Boolean> options;
  private String patch;
  private String path;
  private SelectorBuilder target;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Patch instance) {
    instance = (instance != null ? instance : new Patch());
  
    if (instance != null) {
        this.withOptions(instance.getOptions());
        this.withPatch(instance.getPatch());
        this.withPath(instance.getPath());
        this.withTarget(instance.getTarget());
        this.withOptions(instance.getOptions());
        this.withPatch(instance.getPatch());
        this.withPath(instance.getPath());
        this.withTarget(instance.getTarget());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToOptions(String key,Boolean value) {
    if(this.options == null && key != null && value != null) { this.options = new LinkedHashMap(); }
    if(key != null && value != null) {this.options.put(key, value);} return (A)this;
  }
  
  public A addToOptions(Map<String,Boolean> map) {
    if(this.options == null && map != null) { this.options = new LinkedHashMap(); }
    if(map != null) { this.options.putAll(map);} return (A)this;
  }
  
  public A removeFromOptions(String key) {
    if(this.options == null) { return (A) this; }
    if(key != null && this.options != null) {this.options.remove(key);} return (A)this;
  }
  
  public A removeFromOptions(Map<String,Boolean> map) {
    if(this.options == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.options != null){this.options.remove(key);}}} return (A)this;
  }
  
  public Map<String,Boolean> getOptions() {
    return this.options;
  }
  
  public <K,V>A withOptions(Map<String,Boolean> options) {
    if (options == null) { this.options =  null;} else {this.options = new LinkedHashMap(options);} return (A) this;
  }
  
  public boolean hasOptions() {
    return this.options != null;
  }
  
  public String getPatch() {
    return this.patch;
  }
  
  public A withPatch(String patch) {
    this.patch=patch; return (A) this;
  }
  
  public boolean hasPatch() {
    return this.patch != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Selector buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  
  public A withTarget(Selector target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new SelectorBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  
  public boolean hasTarget() {
    return this.target != null;
  }
  
  public TargetNested<A> withNewTarget() {
    return new TargetNested(null);
  }
  
  public TargetNested<A> withNewTargetLike(Selector item) {
    return new TargetNested(item);
  }
  
  public TargetNested<A> editTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(null));
  }
  
  public TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(new SelectorBuilder().build()));
  }
  
  public TargetNested<A> editOrNewTargetLike(Selector item) {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PatchFluent that = (PatchFluent) o;
    if (!java.util.Objects.equals(options, that.options)) return false;
  
    if (!java.util.Objects.equals(patch, that.patch)) return false;
  
    if (!java.util.Objects.equals(path, that.path)) return false;
  
    if (!java.util.Objects.equals(target, that.target)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(options,  patch,  path,  target,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (options != null && !options.isEmpty()) { sb.append("options:"); sb.append(options + ","); }
    if (patch != null) { sb.append("patch:"); sb.append(patch + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetNested<N> extends SelectorFluent<TargetNested<N>> implements Nested<N>{
    TargetNested(Selector item) {
      this.builder = new SelectorBuilder(this, item);
    }
    SelectorBuilder builder;
    
    public N and() {
      return (N) PatchFluent.this.withTarget(builder.build());
    }
    
    public N endTarget() {
      return and();
    }
    
  
  }

}