/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpec;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpecBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpecFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LabelFluent<A extends LabelFluent<A>>
extends BaseFluent<A> {
    private ArrayList<FieldSpecBuilder> fields = new ArrayList();
    private Boolean includeSelectors;
    private Boolean includeTemplates;
    private Map<String, String> pairs;
    private Map<String, Object> additionalProperties;

    public LabelFluent() {
    }

    public LabelFluent(Label instance) {
        Label label = instance = instance != null ? instance : new Label();
        if (instance != null) {
            this.withFields(instance.getFields());
            this.withIncludeSelectors(instance.getIncludeSelectors());
            this.withIncludeTemplates(instance.getIncludeTemplates());
            this.withPairs(instance.getPairs());
            this.withFields(instance.getFields());
            this.withIncludeSelectors(instance.getIncludeSelectors());
            this.withIncludeTemplates(instance.getIncludeTemplates());
            this.withPairs(instance.getPairs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFields(int index, FieldSpec item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        FieldSpecBuilder builder = new FieldSpecBuilder(item);
        if (index < 0 || index >= this.fields.size()) {
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        } else {
            this._visitables.get((Object)"fields").add(index, builder);
            this.fields.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFields(int index, FieldSpec item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        FieldSpecBuilder builder = new FieldSpecBuilder(item);
        if (index < 0 || index >= this.fields.size()) {
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        } else {
            this._visitables.get((Object)"fields").set(index, builder);
            this.fields.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFields(FieldSpec ... items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFields(Collection<FieldSpec> items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFields(FieldSpec ... items) {
        if (this.fields == null) {
            return (A)((Object)this);
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").remove((Object)builder);
            this.fields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFields(Collection<FieldSpec> items) {
        if (this.fields == null) {
            return (A)((Object)this);
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").remove((Object)builder);
            this.fields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFields(Predicate<FieldSpecBuilder> predicate) {
        if (this.fields == null) {
            return (A)((Object)this);
        }
        Iterator<FieldSpecBuilder> each = this.fields.iterator();
        List visitables = this._visitables.get((Object)"fields");
        while (each.hasNext()) {
            FieldSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<FieldSpec> buildFields() {
        return this.fields != null ? LabelFluent.build(this.fields) : null;
    }

    public FieldSpec buildField(int index) {
        return this.fields.get(index).build();
    }

    public FieldSpec buildFirstField() {
        return this.fields.get(0).build();
    }

    public FieldSpec buildLastField() {
        return this.fields.get(this.fields.size() - 1).build();
    }

    public FieldSpec buildMatchingField(Predicate<FieldSpecBuilder> predicate) {
        for (FieldSpecBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingField(Predicate<FieldSpecBuilder> predicate) {
        for (FieldSpecBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFields(List<FieldSpec> fields) {
        if (this.fields != null) {
            this._visitables.get((Object)"fields").clear();
        }
        if (fields != null) {
            this.fields = new ArrayList();
            for (FieldSpec item : fields) {
                this.addToFields(item);
            }
        } else {
            this.fields = null;
        }
        return (A)((Object)this);
    }

    public A withFields(FieldSpec ... fields) {
        if (this.fields != null) {
            this.fields.clear();
            this._visitables.remove((Object)"fields");
        }
        if (fields != null) {
            for (FieldSpec item : fields) {
                this.addToFields(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    public A addNewField(Boolean create, String group, String kind, String path, String version) {
        return this.addToFields(new FieldSpec(create, group, kind, path, version));
    }

    public FieldsNested<A> addNewField() {
        return new FieldsNested(-1, null);
    }

    public FieldsNested<A> addNewFieldLike(FieldSpec item) {
        return new FieldsNested(-1, item);
    }

    public FieldsNested<A> setNewFieldLike(int index, FieldSpec item) {
        return new FieldsNested(index, item);
    }

    public FieldsNested<A> editField(int index) {
        if (this.fields.size() <= index) {
            throw new RuntimeException("Can't edit fields. Index exceeds size.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public FieldsNested<A> editFirstField() {
        if (this.fields.size() == 0) {
            throw new RuntimeException("Can't edit first fields. The list is empty.");
        }
        return this.setNewFieldLike(0, this.buildField(0));
    }

    public FieldsNested<A> editLastField() {
        int index = this.fields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fields. The list is empty.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public FieldsNested<A> editMatchingField(Predicate<FieldSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!predicate.test(this.fields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fields. No match found.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    public Boolean getIncludeSelectors() {
        return this.includeSelectors;
    }

    public A withIncludeSelectors(Boolean includeSelectors) {
        this.includeSelectors = includeSelectors;
        return (A)((Object)this);
    }

    public boolean hasIncludeSelectors() {
        return this.includeSelectors != null;
    }

    public Boolean getIncludeTemplates() {
        return this.includeTemplates;
    }

    public A withIncludeTemplates(Boolean includeTemplates) {
        this.includeTemplates = includeTemplates;
        return (A)((Object)this);
    }

    public boolean hasIncludeTemplates() {
        return this.includeTemplates != null;
    }

    public A addToPairs(String key, String value) {
        if (this.pairs == null && key != null && value != null) {
            this.pairs = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.pairs.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPairs(Map<String, String> map) {
        if (this.pairs == null && map != null) {
            this.pairs = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.pairs.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPairs(String key) {
        if (this.pairs == null) {
            return (A)((Object)this);
        }
        if (key != null && this.pairs != null) {
            this.pairs.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPairs(Map<String, String> map) {
        if (this.pairs == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.pairs == null) continue;
                this.pairs.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getPairs() {
        return this.pairs;
    }

    public <K, V> A withPairs(Map<String, String> pairs) {
        this.pairs = pairs == null ? null : new LinkedHashMap<String, String>(pairs);
        return (A)((Object)this);
    }

    public boolean hasPairs() {
        return this.pairs != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelFluent that = (LabelFluent)((Object)o);
        if (!Objects.equals(this.fields, that.fields)) {
            return false;
        }
        if (!Objects.equals(this.includeSelectors, that.includeSelectors)) {
            return false;
        }
        if (!Objects.equals(this.includeTemplates, that.includeTemplates)) {
            return false;
        }
        if (!Objects.equals(this.pairs, that.pairs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.includeSelectors, this.includeTemplates, this.pairs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fields != null) {
            sb.append("fields:");
            sb.append(this.fields + ",");
        }
        if (this.includeSelectors != null) {
            sb.append("includeSelectors:");
            sb.append(this.includeSelectors + ",");
        }
        if (this.includeTemplates != null) {
            sb.append("includeTemplates:");
            sb.append(this.includeTemplates + ",");
        }
        if (this.pairs != null && !this.pairs.isEmpty()) {
            sb.append("pairs:");
            sb.append(this.pairs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncludeSelectors() {
        return this.withIncludeSelectors(true);
    }

    public A withIncludeTemplates() {
        return this.withIncludeTemplates(true);
    }

    public class FieldsNested<N>
    extends FieldSpecFluent<FieldsNested<N>>
    implements Nested<N> {
        FieldSpecBuilder builder;
        int index;

        FieldsNested(int index, FieldSpec item) {
            this.index = index;
            this.builder = new FieldSpecBuilder(this, item);
        }

        public N and() {
            return (N)LabelFluent.this.setToFields(this.index, this.builder.build());
        }

        public N endField() {
            return this.and();
        }
    }
}

