package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetBuilder extends TargetFluent<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder>{
  public TargetBuilder() {
    this(false);
  }
  public TargetBuilder(Boolean validationEnabled) {
    this(new Target(), validationEnabled);
  }
  public TargetBuilder(TargetFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetBuilder(TargetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Target(), validationEnabled);
  }
  public TargetBuilder(TargetFluent<?> fluent,Target instance) {
    this(fluent, instance, false);
  }
  public TargetBuilder(TargetFluent<?> fluent,Target instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Target());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withVersion(instance.getVersion());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TargetBuilder(Target instance) {
    this(instance,false);
  }
  public TargetBuilder(Target instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Target());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withVersion(instance.getVersion());
      this.withApiVersion(instance.getApiVersion());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TargetFluent<?> fluent;
  Boolean validationEnabled;
  public Target build() {
    Target buildable = new Target(fluent.getApiVersion(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}