package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReplacementFieldFluent<A extends ReplacementFieldFluent<A>> extends BaseFluent<A>{
  public ReplacementFieldFluent() {
  }
  public ReplacementFieldFluent(ReplacementField instance) {
    instance = (instance != null ? instance : new ReplacementField());

    if (instance != null) {
      this.withPath(instance.getPath());
      this.withSource(instance.getSource());
      this.withTargets(instance.getTargets());
      this.withPath(instance.getPath());
      this.withSource(instance.getSource());
      this.withTargets(instance.getTargets());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String path;
  private SourceSelectorBuilder source;
  private ArrayList<TargetSelectorBuilder> targets = new ArrayList<TargetSelectorBuilder>();
  private Map<String,Object> additionalProperties;
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public SourceSelector buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(SourceSelector source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new SourceSelectorBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public boolean hasSource() {
    return this.source != null;
  }
  public SourceNested<A> withNewSource() {
    return new SourceNested(null);
  }
  public SourceNested<A> withNewSourceLike(SourceSelector item) {
    return new SourceNested(item);
  }
  public SourceNested<A> editSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(null));
  }
  public SourceNested<A> editOrNewSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(new SourceSelectorBuilder().build()));
  }
  public SourceNested<A> editOrNewSourceLike(SourceSelector item) {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(item));
  }
  public A addToTargets(int index,TargetSelector item) {
    if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
    TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
    if (index < 0 || index >= targets.size()) { _visitables.get("targets").add(builder); targets.add(builder); } else { _visitables.get("targets").add(index, builder); targets.add(index, builder);}
    return (A)this;
  }
  public A setToTargets(int index,TargetSelector item) {
    if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
    TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
    if (index < 0 || index >= targets.size()) { _visitables.get("targets").add(builder); targets.add(builder); } else { _visitables.get("targets").set(index, builder); targets.set(index, builder);}
    return (A)this;
  }
  public A addToTargets(io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector... items) {
    if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
    for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").add(builder);this.targets.add(builder);} return (A)this;
  }
  public A addAllToTargets(Collection<TargetSelector> items) {
    if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
    for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").add(builder);this.targets.add(builder);} return (A)this;
  }
  public A removeFromTargets(io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector... items) {
    if (this.targets == null) return (A)this;
    for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").remove(builder); this.targets.remove(builder);} return (A)this;
  }
  public A removeAllFromTargets(Collection<TargetSelector> items) {
    if (this.targets == null) return (A)this;
    for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").remove(builder); this.targets.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTargets(Predicate<TargetSelectorBuilder> predicate) {
    if (targets == null) return (A) this;
    final Iterator<TargetSelectorBuilder> each = targets.iterator();
    final List visitables = _visitables.get("targets");
    while (each.hasNext()) {
      TargetSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<TargetSelector> buildTargets() {
    return targets != null ? build(targets) : null;
  }
  public TargetSelector buildTarget(int index) {
    return this.targets.get(index).build();
  }
  public TargetSelector buildFirstTarget() {
    return this.targets.get(0).build();
  }
  public TargetSelector buildLastTarget() {
    return this.targets.get(targets.size() - 1).build();
  }
  public TargetSelector buildMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
    for (TargetSelectorBuilder item: targets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
    for (TargetSelectorBuilder item: targets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTargets(List<TargetSelector> targets) {
    if (this.targets != null) { _visitables.get("targets").clear();}
    if (targets != null) {this.targets = new ArrayList(); for (TargetSelector item : targets){this.addToTargets(item);}} else { this.targets = null;} return (A) this;
  }
  public A withTargets(io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector... targets) {
    if (this.targets != null) {this.targets.clear(); _visitables.remove("targets"); }
    if (targets != null) {for (TargetSelector item :targets){ this.addToTargets(item);}} return (A) this;
  }
  public boolean hasTargets() {
    return targets != null && !targets.isEmpty();
  }
  public TargetsNested<A> addNewTarget() {
    return new TargetsNested(-1, null);
  }
  public TargetsNested<A> addNewTargetLike(TargetSelector item) {
    return new TargetsNested(-1, item);
  }
  public TargetsNested<A> setNewTargetLike(int index,TargetSelector item) {
    return new TargetsNested(index, item);
  }
  public TargetsNested<A> editTarget(int index) {
    if (targets.size() <= index) throw new RuntimeException("Can't edit targets. Index exceeds size.");
    return setNewTargetLike(index, buildTarget(index));
  }
  public TargetsNested<A> editFirstTarget() {
    if (targets.size() == 0) throw new RuntimeException("Can't edit first targets. The list is empty.");
    return setNewTargetLike(0, buildTarget(0));
  }
  public TargetsNested<A> editLastTarget() {
    int index = targets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last targets. The list is empty.");
    return setNewTargetLike(index, buildTarget(index));
  }
  public TargetsNested<A> editMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<targets.size();i++) { 
    if (predicate.test(targets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching targets. No match found.");
    return setNewTargetLike(index, buildTarget(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplacementFieldFluent that = (ReplacementFieldFluent) o;
    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(targets, that.targets)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(path,  source,  targets,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (targets != null) { sb.append("targets:"); sb.append(targets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SourceNested<N> extends SourceSelectorFluent<SourceNested<N>> implements Nested<N>{
    SourceNested(SourceSelector item) {
      this.builder = new SourceSelectorBuilder(this, item);
    }
    SourceSelectorBuilder builder;
    public N and() {
      return (N) ReplacementFieldFluent.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  public class TargetsNested<N> extends TargetSelectorFluent<TargetsNested<N>> implements Nested<N>{
    TargetsNested(int index,TargetSelector item) {
      this.index = index;
      this.builder = new TargetSelectorBuilder(this, item);
    }
    TargetSelectorBuilder builder;
    int index;
    public N and() {
      return (N) ReplacementFieldFluent.this.setToTargets(index,builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}