package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LegacySortOptionsBuilder extends LegacySortOptionsFluent<LegacySortOptionsBuilder> implements VisitableBuilder<LegacySortOptions,LegacySortOptionsBuilder>{
  public LegacySortOptionsBuilder() {
    this(false);
  }
  public LegacySortOptionsBuilder(Boolean validationEnabled) {
    this(new LegacySortOptions(), validationEnabled);
  }
  public LegacySortOptionsBuilder(LegacySortOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public LegacySortOptionsBuilder(LegacySortOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LegacySortOptions(), validationEnabled);
  }
  public LegacySortOptionsBuilder(LegacySortOptionsFluent<?> fluent,LegacySortOptions instance) {
    this(fluent, instance, false);
  }
  public LegacySortOptionsBuilder(LegacySortOptionsFluent<?> fluent,LegacySortOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LegacySortOptions());

    if (instance != null) {
      fluent.withOrderFirst(instance.getOrderFirst());
      fluent.withOrderLast(instance.getOrderLast());
      fluent.withOrderFirst(instance.getOrderFirst());
      fluent.withOrderLast(instance.getOrderLast());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LegacySortOptionsBuilder(LegacySortOptions instance) {
    this(instance,false);
  }
  public LegacySortOptionsBuilder(LegacySortOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LegacySortOptions());

    if (instance != null) {
      this.withOrderFirst(instance.getOrderFirst());
      this.withOrderLast(instance.getOrderLast());
      this.withOrderFirst(instance.getOrderFirst());
      this.withOrderLast(instance.getOrderLast());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LegacySortOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public LegacySortOptions build() {
    LegacySortOptions buildable = new LegacySortOptions(fluent.getOrderFirst(),fluent.getOrderLast());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}