package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LabelBuilder extends LabelFluent<LabelBuilder> implements VisitableBuilder<Label,LabelBuilder>{
  public LabelBuilder() {
    this(false);
  }
  public LabelBuilder(Boolean validationEnabled) {
    this(new Label(), validationEnabled);
  }
  public LabelBuilder(LabelFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelBuilder(LabelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Label(), validationEnabled);
  }
  public LabelBuilder(LabelFluent<?> fluent,Label instance) {
    this(fluent, instance, false);
  }
  public LabelBuilder(LabelFluent<?> fluent,Label instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Label());

    if (instance != null) {
      fluent.withFields(instance.getFields());
      fluent.withIncludeSelectors(instance.getIncludeSelectors());
      fluent.withIncludeTemplates(instance.getIncludeTemplates());
      fluent.withPairs(instance.getPairs());
      fluent.withFields(instance.getFields());
      fluent.withIncludeSelectors(instance.getIncludeSelectors());
      fluent.withIncludeTemplates(instance.getIncludeTemplates());
      fluent.withPairs(instance.getPairs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LabelBuilder(Label instance) {
    this(instance,false);
  }
  public LabelBuilder(Label instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Label());

    if (instance != null) {
      this.withFields(instance.getFields());
      this.withIncludeSelectors(instance.getIncludeSelectors());
      this.withIncludeTemplates(instance.getIncludeTemplates());
      this.withPairs(instance.getPairs());
      this.withFields(instance.getFields());
      this.withIncludeSelectors(instance.getIncludeSelectors());
      this.withIncludeTemplates(instance.getIncludeTemplates());
      this.withPairs(instance.getPairs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LabelFluent<?> fluent;
  Boolean validationEnabled;
  public Label build() {
    Label buildable = new Label(fluent.buildFields(),fluent.getIncludeSelectors(),fluent.getIncludeTemplates(),fluent.getPairs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}