package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmChartFluent<A extends HelmChartFluent<A>> extends BaseFluent<A>{
  public HelmChartFluent() {
  }
  public HelmChartFluent(HelmChart instance) {
    instance = (instance != null ? instance : new HelmChart());

    if (instance != null) {
      this.withAdditionalValuesFiles(instance.getAdditionalValuesFiles());
      this.withApiVersions(instance.getApiVersions());
      this.withIncludeCRDs(instance.getIncludeCRDs());
      this.withName(instance.getName());
      this.withNameTemplate(instance.getNameTemplate());
      this.withNamespace(instance.getNamespace());
      this.withReleaseName(instance.getReleaseName());
      this.withRepo(instance.getRepo());
      this.withSkipHooks(instance.getSkipHooks());
      this.withSkipTests(instance.getSkipTests());
      this.withValuesFile(instance.getValuesFile());
      this.withValuesInline(instance.getValuesInline());
      this.withValuesMerge(instance.getValuesMerge());
      this.withVersion(instance.getVersion());
      this.withAdditionalValuesFiles(instance.getAdditionalValuesFiles());
      this.withApiVersions(instance.getApiVersions());
      this.withIncludeCRDs(instance.getIncludeCRDs());
      this.withName(instance.getName());
      this.withNameTemplate(instance.getNameTemplate());
      this.withNamespace(instance.getNamespace());
      this.withReleaseName(instance.getReleaseName());
      this.withRepo(instance.getRepo());
      this.withSkipHooks(instance.getSkipHooks());
      this.withSkipTests(instance.getSkipTests());
      this.withValuesFile(instance.getValuesFile());
      this.withValuesInline(instance.getValuesInline());
      this.withValuesMerge(instance.getValuesMerge());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> additionalValuesFiles = new ArrayList<String>();
  private List<String> apiVersions = new ArrayList<String>();
  private Boolean includeCRDs;
  private String name;
  private String nameTemplate;
  private String namespace;
  private String releaseName;
  private String repo;
  private Boolean skipHooks;
  private Boolean skipTests;
  private String valuesFile;
  private Map<String,Object> valuesInline;
  private String valuesMerge;
  private String version;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalValuesFiles(int index,String item) {
    if (this.additionalValuesFiles == null) {this.additionalValuesFiles = new ArrayList<String>();}
    this.additionalValuesFiles.add(index, item);
    return (A)this;
  }
  public A setToAdditionalValuesFiles(int index,String item) {
    if (this.additionalValuesFiles == null) {this.additionalValuesFiles = new ArrayList<String>();}
    this.additionalValuesFiles.set(index, item); return (A)this;
  }
  public A addToAdditionalValuesFiles(java.lang.String... items) {
    if (this.additionalValuesFiles == null) {this.additionalValuesFiles = new ArrayList<String>();}
    for (String item : items) {this.additionalValuesFiles.add(item);} return (A)this;
  }
  public A addAllToAdditionalValuesFiles(Collection<String> items) {
    if (this.additionalValuesFiles == null) {this.additionalValuesFiles = new ArrayList<String>();}
    for (String item : items) {this.additionalValuesFiles.add(item);} return (A)this;
  }
  public A removeFromAdditionalValuesFiles(java.lang.String... items) {
    if (this.additionalValuesFiles == null) return (A)this;
    for (String item : items) { this.additionalValuesFiles.remove(item);} return (A)this;
  }
  public A removeAllFromAdditionalValuesFiles(Collection<String> items) {
    if (this.additionalValuesFiles == null) return (A)this;
    for (String item : items) { this.additionalValuesFiles.remove(item);} return (A)this;
  }
  public List<String> getAdditionalValuesFiles() {
    return this.additionalValuesFiles;
  }
  public String getAdditionalValuesFile(int index) {
    return this.additionalValuesFiles.get(index);
  }
  public String getFirstAdditionalValuesFile() {
    return this.additionalValuesFiles.get(0);
  }
  public String getLastAdditionalValuesFile() {
    return this.additionalValuesFiles.get(additionalValuesFiles.size() - 1);
  }
  public String getMatchingAdditionalValuesFile(Predicate<String> predicate) {
    for (String item: additionalValuesFiles) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAdditionalValuesFile(Predicate<String> predicate) {
    for (String item: additionalValuesFiles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalValuesFiles(List<String> additionalValuesFiles) {
    if (additionalValuesFiles != null) {this.additionalValuesFiles = new ArrayList(); for (String item : additionalValuesFiles){this.addToAdditionalValuesFiles(item);}} else { this.additionalValuesFiles = null;} return (A) this;
  }
  public A withAdditionalValuesFiles(java.lang.String... additionalValuesFiles) {
    if (this.additionalValuesFiles != null) {this.additionalValuesFiles.clear(); _visitables.remove("additionalValuesFiles"); }
    if (additionalValuesFiles != null) {for (String item :additionalValuesFiles){ this.addToAdditionalValuesFiles(item);}} return (A) this;
  }
  public boolean hasAdditionalValuesFiles() {
    return additionalValuesFiles != null && !additionalValuesFiles.isEmpty();
  }
  public A addToApiVersions(int index,String item) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    this.apiVersions.add(index, item);
    return (A)this;
  }
  public A setToApiVersions(int index,String item) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    this.apiVersions.set(index, item); return (A)this;
  }
  public A addToApiVersions(java.lang.String... items) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    for (String item : items) {this.apiVersions.add(item);} return (A)this;
  }
  public A addAllToApiVersions(Collection<String> items) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    for (String item : items) {this.apiVersions.add(item);} return (A)this;
  }
  public A removeFromApiVersions(java.lang.String... items) {
    if (this.apiVersions == null) return (A)this;
    for (String item : items) { this.apiVersions.remove(item);} return (A)this;
  }
  public A removeAllFromApiVersions(Collection<String> items) {
    if (this.apiVersions == null) return (A)this;
    for (String item : items) { this.apiVersions.remove(item);} return (A)this;
  }
  public List<String> getApiVersions() {
    return this.apiVersions;
  }
  public String getApiVersion(int index) {
    return this.apiVersions.get(index);
  }
  public String getFirstApiVersion() {
    return this.apiVersions.get(0);
  }
  public String getLastApiVersion() {
    return this.apiVersions.get(apiVersions.size() - 1);
  }
  public String getMatchingApiVersion(Predicate<String> predicate) {
    for (String item: apiVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingApiVersion(Predicate<String> predicate) {
    for (String item: apiVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiVersions(List<String> apiVersions) {
    if (apiVersions != null) {this.apiVersions = new ArrayList(); for (String item : apiVersions){this.addToApiVersions(item);}} else { this.apiVersions = null;} return (A) this;
  }
  public A withApiVersions(java.lang.String... apiVersions) {
    if (this.apiVersions != null) {this.apiVersions.clear(); _visitables.remove("apiVersions"); }
    if (apiVersions != null) {for (String item :apiVersions){ this.addToApiVersions(item);}} return (A) this;
  }
  public boolean hasApiVersions() {
    return apiVersions != null && !apiVersions.isEmpty();
  }
  public Boolean getIncludeCRDs() {
    return this.includeCRDs;
  }
  public A withIncludeCRDs(Boolean includeCRDs) {
    this.includeCRDs=includeCRDs; return (A) this;
  }
  public boolean hasIncludeCRDs() {
    return this.includeCRDs != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public String getNameTemplate() {
    return this.nameTemplate;
  }
  public A withNameTemplate(String nameTemplate) {
    this.nameTemplate=nameTemplate; return (A) this;
  }
  public boolean hasNameTemplate() {
    return this.nameTemplate != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getReleaseName() {
    return this.releaseName;
  }
  public A withReleaseName(String releaseName) {
    this.releaseName=releaseName; return (A) this;
  }
  public boolean hasReleaseName() {
    return this.releaseName != null;
  }
  public String getRepo() {
    return this.repo;
  }
  public A withRepo(String repo) {
    this.repo=repo; return (A) this;
  }
  public boolean hasRepo() {
    return this.repo != null;
  }
  public Boolean getSkipHooks() {
    return this.skipHooks;
  }
  public A withSkipHooks(Boolean skipHooks) {
    this.skipHooks=skipHooks; return (A) this;
  }
  public boolean hasSkipHooks() {
    return this.skipHooks != null;
  }
  public Boolean getSkipTests() {
    return this.skipTests;
  }
  public A withSkipTests(Boolean skipTests) {
    this.skipTests=skipTests; return (A) this;
  }
  public boolean hasSkipTests() {
    return this.skipTests != null;
  }
  public String getValuesFile() {
    return this.valuesFile;
  }
  public A withValuesFile(String valuesFile) {
    this.valuesFile=valuesFile; return (A) this;
  }
  public boolean hasValuesFile() {
    return this.valuesFile != null;
  }
  public A addToValuesInline(String key,Object value) {
    if(this.valuesInline == null && key != null && value != null) { this.valuesInline = new LinkedHashMap(); }
    if(key != null && value != null) {this.valuesInline.put(key, value);} return (A)this;
  }
  public A addToValuesInline(Map<String,Object> map) {
    if(this.valuesInline == null && map != null) { this.valuesInline = new LinkedHashMap(); }
    if(map != null) { this.valuesInline.putAll(map);} return (A)this;
  }
  public A removeFromValuesInline(String key) {
    if(this.valuesInline == null) { return (A) this; }
    if(key != null && this.valuesInline != null) {this.valuesInline.remove(key);} return (A)this;
  }
  public A removeFromValuesInline(Map<String,Object> map) {
    if(this.valuesInline == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.valuesInline != null){this.valuesInline.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getValuesInline() {
    return this.valuesInline;
  }
  public <K,V>A withValuesInline(Map<String,Object> valuesInline) {
    if (valuesInline == null) { this.valuesInline =  null;} else {this.valuesInline = new LinkedHashMap(valuesInline);} return (A) this;
  }
  public boolean hasValuesInline() {
    return this.valuesInline != null;
  }
  public String getValuesMerge() {
    return this.valuesMerge;
  }
  public A withValuesMerge(String valuesMerge) {
    this.valuesMerge=valuesMerge; return (A) this;
  }
  public boolean hasValuesMerge() {
    return this.valuesMerge != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartFluent that = (HelmChartFluent) o;
    if (!java.util.Objects.equals(additionalValuesFiles, that.additionalValuesFiles)) return false;

    if (!java.util.Objects.equals(apiVersions, that.apiVersions)) return false;

    if (!java.util.Objects.equals(includeCRDs, that.includeCRDs)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(nameTemplate, that.nameTemplate)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(releaseName, that.releaseName)) return false;

    if (!java.util.Objects.equals(repo, that.repo)) return false;

    if (!java.util.Objects.equals(skipHooks, that.skipHooks)) return false;

    if (!java.util.Objects.equals(skipTests, that.skipTests)) return false;

    if (!java.util.Objects.equals(valuesFile, that.valuesFile)) return false;

    if (!java.util.Objects.equals(valuesInline, that.valuesInline)) return false;

    if (!java.util.Objects.equals(valuesMerge, that.valuesMerge)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalValuesFiles,  apiVersions,  includeCRDs,  name,  nameTemplate,  namespace,  releaseName,  repo,  skipHooks,  skipTests,  valuesFile,  valuesInline,  valuesMerge,  version,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalValuesFiles != null && !additionalValuesFiles.isEmpty()) { sb.append("additionalValuesFiles:"); sb.append(additionalValuesFiles + ","); }
    if (apiVersions != null && !apiVersions.isEmpty()) { sb.append("apiVersions:"); sb.append(apiVersions + ","); }
    if (includeCRDs != null) { sb.append("includeCRDs:"); sb.append(includeCRDs + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (nameTemplate != null) { sb.append("nameTemplate:"); sb.append(nameTemplate + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (releaseName != null) { sb.append("releaseName:"); sb.append(releaseName + ","); }
    if (repo != null) { sb.append("repo:"); sb.append(repo + ","); }
    if (skipHooks != null) { sb.append("skipHooks:"); sb.append(skipHooks + ","); }
    if (skipTests != null) { sb.append("skipTests:"); sb.append(skipTests + ","); }
    if (valuesFile != null) { sb.append("valuesFile:"); sb.append(valuesFile + ","); }
    if (valuesInline != null && !valuesInline.isEmpty()) { sb.append("valuesInline:"); sb.append(valuesInline + ","); }
    if (valuesMerge != null) { sb.append("valuesMerge:"); sb.append(valuesMerge + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIncludeCRDs() {
    return withIncludeCRDs(true);
  }
  public A withSkipHooks() {
    return withSkipHooks(true);
  }
  public A withSkipTests() {
    return withSkipTests(true);
  }
  
}