package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GeneratorOptionsBuilder extends GeneratorOptionsFluent<GeneratorOptionsBuilder> implements VisitableBuilder<GeneratorOptions,GeneratorOptionsBuilder>{
  public GeneratorOptionsBuilder() {
    this(false);
  }
  public GeneratorOptionsBuilder(Boolean validationEnabled) {
    this(new GeneratorOptions(), validationEnabled);
  }
  public GeneratorOptionsBuilder(GeneratorOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public GeneratorOptionsBuilder(GeneratorOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GeneratorOptions(), validationEnabled);
  }
  public GeneratorOptionsBuilder(GeneratorOptionsFluent<?> fluent,GeneratorOptions instance) {
    this(fluent, instance, false);
  }
  public GeneratorOptionsBuilder(GeneratorOptionsFluent<?> fluent,GeneratorOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GeneratorOptions());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withDisableNameSuffixHash(instance.getDisableNameSuffixHash());
      fluent.withImmutable(instance.getImmutable());
      fluent.withLabels(instance.getLabels());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withDisableNameSuffixHash(instance.getDisableNameSuffixHash());
      fluent.withImmutable(instance.getImmutable());
      fluent.withLabels(instance.getLabels());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GeneratorOptionsBuilder(GeneratorOptions instance) {
    this(instance,false);
  }
  public GeneratorOptionsBuilder(GeneratorOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GeneratorOptions());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withDisableNameSuffixHash(instance.getDisableNameSuffixHash());
      this.withImmutable(instance.getImmutable());
      this.withLabels(instance.getLabels());
      this.withAnnotations(instance.getAnnotations());
      this.withDisableNameSuffixHash(instance.getDisableNameSuffixHash());
      this.withImmutable(instance.getImmutable());
      this.withLabels(instance.getLabels());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GeneratorOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public GeneratorOptions build() {
    GeneratorOptions buildable = new GeneratorOptions(fluent.getAnnotations(),fluent.getDisableNameSuffixHash(),fluent.getImmutable(),fluent.getLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}