package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FieldSelectorBuilder extends FieldSelectorFluent<FieldSelectorBuilder> implements VisitableBuilder<FieldSelector,FieldSelectorBuilder>{
  public FieldSelectorBuilder() {
    this(false);
  }
  public FieldSelectorBuilder(Boolean validationEnabled) {
    this(new FieldSelector(), validationEnabled);
  }
  public FieldSelectorBuilder(FieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public FieldSelectorBuilder(FieldSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FieldSelector(), validationEnabled);
  }
  public FieldSelectorBuilder(FieldSelectorFluent<?> fluent,FieldSelector instance) {
    this(fluent, instance, false);
  }
  public FieldSelectorBuilder(FieldSelectorFluent<?> fluent,FieldSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FieldSelector());

    if (instance != null) {
      fluent.withFieldPath(instance.getFieldPath());
      fluent.withFieldPath(instance.getFieldPath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FieldSelectorBuilder(FieldSelector instance) {
    this(instance,false);
  }
  public FieldSelectorBuilder(FieldSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FieldSelector());

    if (instance != null) {
      this.withFieldPath(instance.getFieldPath());
      this.withFieldPath(instance.getFieldPath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FieldSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public FieldSelector build() {
    FieldSelector buildable = new FieldSelector(fluent.getFieldPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}