package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceSelectorBuilder extends SourceSelectorFluentImpl<SourceSelectorBuilder> implements VisitableBuilder<SourceSelector,SourceSelectorBuilder>{
  public SourceSelectorBuilder() {
    this(false);
  }
  public SourceSelectorBuilder(Boolean validationEnabled) {
    this(new SourceSelector(), validationEnabled);
  }
  public SourceSelectorBuilder(SourceSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceSelectorBuilder(SourceSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceSelector(), validationEnabled);
  }
  public SourceSelectorBuilder(SourceSelectorFluent<?> fluent,SourceSelector instance) {
    this(fluent, instance, false);
  }
  public SourceSelectorBuilder(SourceSelectorFluent<?> fluent,SourceSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFieldPath(instance.getFieldPath());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withOptions(instance.getOptions());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceSelectorBuilder(SourceSelector instance) {
    this(instance,false);
  }
  public SourceSelectorBuilder(SourceSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFieldPath(instance.getFieldPath());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withOptions(instance.getOptions());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public SourceSelector build() {
    SourceSelector buildable = new SourceSelector(fluent.getFieldPath(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getOptions(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}