package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorBuilder extends SelectorFluentImpl<SelectorBuilder> implements VisitableBuilder<Selector,SelectorBuilder>{
  public SelectorBuilder() {
    this(false);
  }
  public SelectorBuilder(Boolean validationEnabled) {
    this(new Selector(), validationEnabled);
  }
  public SelectorBuilder(SelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Selector(), validationEnabled);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Selector instance) {
    this(fluent, instance, false);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Selector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotationSelector(instance.getAnnotationSelector());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelectorBuilder(Selector instance) {
    this(instance,false);
  }
  public SelectorBuilder(Selector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotationSelector(instance.getAnnotationSelector());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withLabelSelector(instance.getLabelSelector());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelectorFluent<?> fluent;
  Boolean validationEnabled;
  public Selector build() {
    Selector buildable = new Selector(fluent.getAnnotationSelector(),fluent.getGroup(),fluent.getKind(),fluent.getLabelSelector(),fluent.getName(),fluent.getNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}