package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FieldSpecBuilder extends FieldSpecFluentImpl<FieldSpecBuilder> implements VisitableBuilder<FieldSpec,FieldSpecBuilder>{
  public FieldSpecBuilder() {
    this(false);
  }
  public FieldSpecBuilder(Boolean validationEnabled) {
    this(new FieldSpec(), validationEnabled);
  }
  public FieldSpecBuilder(FieldSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public FieldSpecBuilder(FieldSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FieldSpec(), validationEnabled);
  }
  public FieldSpecBuilder(FieldSpecFluent<?> fluent,FieldSpec instance) {
    this(fluent, instance, false);
  }
  public FieldSpecBuilder(FieldSpecFluent<?> fluent,FieldSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCreate(instance.getCreate());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withPath(instance.getPath());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FieldSpecBuilder(FieldSpec instance) {
    this(instance,false);
  }
  public FieldSpecBuilder(FieldSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCreate(instance.getCreate());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withPath(instance.getPath());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FieldSpecFluent<?> fluent;
  Boolean validationEnabled;
  public FieldSpec build() {
    FieldSpec buildable = new FieldSpec(fluent.getCreate(),fluent.getGroup(),fluent.getKind(),fluent.getPath(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}