/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplicaFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplicaFluentImpl;

public class ReplicaBuilder
extends ReplicaFluentImpl<ReplicaBuilder>
implements VisitableBuilder<Replica, ReplicaBuilder> {
    ReplicaFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicaBuilder() {
        this(false);
    }

    public ReplicaBuilder(Boolean validationEnabled) {
        this(new Replica(), validationEnabled);
    }

    public ReplicaBuilder(ReplicaFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ReplicaBuilder(ReplicaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Replica(), validationEnabled);
    }

    public ReplicaBuilder(ReplicaFluent<?> fluent, Replica instance) {
        this(fluent, instance, false);
    }

    public ReplicaBuilder(ReplicaFluent<?> fluent, Replica instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withCount(instance.getCount());
            fluent.withName(instance.getName());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ReplicaBuilder(Replica instance) {
        this(instance, (Boolean)false);
    }

    public ReplicaBuilder(Replica instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withCount(instance.getCount());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public Replica build() {
        Replica buildable = new Replica(this.fluent.getCount(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

