/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementFieldFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelectorFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ReplacementFieldFluentImpl<A extends ReplacementFieldFluent<A>>
extends BaseFluent<A>
implements ReplacementFieldFluent<A> {
    private String path;
    private SourceSelectorBuilder source;
    private ArrayList<TargetSelectorBuilder> targets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ReplacementFieldFluentImpl() {
    }

    public ReplacementFieldFluentImpl(ReplacementField instance) {
        if (instance != null) {
            this.withPath(instance.getPath());
            this.withSource(instance.getSource());
            this.withTargets(instance.getTargets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public SourceSelector getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public SourceSelector buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(SourceSelector source) {
        this._visitables.get((Object)"source").remove(this.source);
        if (source != null) {
            this.source = new SourceSelectorBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public ReplacementFieldFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public ReplacementFieldFluent.SourceNested<A> withNewSourceLike(SourceSelector item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public ReplacementFieldFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public ReplacementFieldFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new SourceSelectorBuilder().build());
    }

    @Override
    public ReplacementFieldFluent.SourceNested<A> editOrNewSourceLike(SourceSelector item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public A addToTargets(int index, TargetSelector item) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
        if (index < 0 || index >= this.targets.size()) {
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        } else {
            this._visitables.get((Object)"targets").add(index, builder);
            this.targets.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToTargets(int index, TargetSelector item) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
        if (index < 0 || index >= this.targets.size()) {
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        } else {
            this._visitables.get((Object)"targets").set(index, builder);
            this.targets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTargets(TargetSelector ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargets(Collection<TargetSelector> items) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargets(TargetSelector ... items) {
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").remove(builder);
            if (this.targets == null) continue;
            this.targets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargets(Collection<TargetSelector> items) {
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").remove(builder);
            if (this.targets == null) continue;
            this.targets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTargets(Predicate<TargetSelectorBuilder> predicate) {
        if (this.targets == null) {
            return (A)this;
        }
        Iterator<TargetSelectorBuilder> each = this.targets.iterator();
        List visitables = this._visitables.get((Object)"targets");
        while (each.hasNext()) {
            TargetSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TargetSelector> getTargets() {
        return this.targets != null ? ReplacementFieldFluentImpl.build(this.targets) : null;
    }

    @Override
    public List<TargetSelector> buildTargets() {
        return this.targets != null ? ReplacementFieldFluentImpl.build(this.targets) : null;
    }

    @Override
    public TargetSelector buildTarget(int index) {
        return this.targets.get(index).build();
    }

    @Override
    public TargetSelector buildFirstTarget() {
        return this.targets.get(0).build();
    }

    @Override
    public TargetSelector buildLastTarget() {
        return this.targets.get(this.targets.size() - 1).build();
    }

    @Override
    public TargetSelector buildMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        for (TargetSelectorBuilder item : this.targets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        for (TargetSelectorBuilder item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargets(List<TargetSelector> targets) {
        if (this.targets != null) {
            this._visitables.get((Object)"targets").clear();
        }
        if (targets != null) {
            this.targets = new ArrayList();
            for (TargetSelector item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)this;
    }

    @Override
    public A withTargets(TargetSelector ... targets) {
        if (this.targets != null) {
            this.targets.clear();
            this._visitables.remove((Object)"targets");
        }
        if (targets != null) {
            for (TargetSelector item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> addNewTarget() {
        return new TargetsNestedImpl();
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> addNewTargetLike(TargetSelector item) {
        return new TargetsNestedImpl(-1, item);
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> setNewTargetLike(int index, TargetSelector item) {
        return new TargetsNestedImpl(index, item);
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> editTarget(int index) {
        if (this.targets.size() <= index) {
            throw new RuntimeException("Can't edit targets. Index exceeds size.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> editFirstTarget() {
        if (this.targets.size() == 0) {
            throw new RuntimeException("Can't edit first targets. The list is empty.");
        }
        return this.setNewTargetLike(0, this.buildTarget(0));
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> editLastTarget() {
        int index = this.targets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targets. The list is empty.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    @Override
    public ReplacementFieldFluent.TargetsNested<A> editMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (!predicate.test(this.targets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targets. No match found.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplacementFieldFluentImpl that = (ReplacementFieldFluentImpl)o;
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.targets, that.targets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.source, this.targets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.targets != null) {
            sb.append("targets:");
            sb.append(this.targets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetsNestedImpl<N>
    extends TargetSelectorFluentImpl<ReplacementFieldFluent.TargetsNested<N>>
    implements ReplacementFieldFluent.TargetsNested<N>,
    Nested<N> {
        TargetSelectorBuilder builder;
        int index;

        TargetsNestedImpl(int index, TargetSelector item) {
            this.index = index;
            this.builder = new TargetSelectorBuilder(this, item);
        }

        TargetsNestedImpl() {
            this.index = -1;
            this.builder = new TargetSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplacementFieldFluentImpl.this.setToTargets(this.index, this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    class SourceNestedImpl<N>
    extends SourceSelectorFluentImpl<ReplacementFieldFluent.SourceNested<N>>
    implements ReplacementFieldFluent.SourceNested<N>,
    Nested<N> {
        SourceSelectorBuilder builder;

        SourceNestedImpl(SourceSelector item) {
            this.builder = new SourceSelectorBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new SourceSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplacementFieldFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

