package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VarBuilder extends VarFluentImpl<VarBuilder> implements VisitableBuilder<Var,VarBuilder>{
  public VarBuilder() {
    this(false);
  }
  public VarBuilder(Boolean validationEnabled) {
    this(new Var(), validationEnabled);
  }
  public VarBuilder(VarFluent<?> fluent) {
    this(fluent, false);
  }
  public VarBuilder(VarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Var(), validationEnabled);
  }
  public VarBuilder(VarFluent<?> fluent,Var instance) {
    this(fluent, instance, false);
  }
  public VarBuilder(VarFluent<?> fluent,Var instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFieldref(instance.getFieldref());
      fluent.withName(instance.getName());
      fluent.withObjref(instance.getObjref());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VarBuilder(Var instance) {
    this(instance,false);
  }
  public VarBuilder(Var instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFieldref(instance.getFieldref());
      this.withName(instance.getName());
      this.withObjref(instance.getObjref());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VarFluent<?> fluent;
  Boolean validationEnabled;
  public Var build() {
    Var buildable = new Var(fluent.getFieldref(),fluent.getName(),fluent.getObjref());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}