package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretArgsBuilder extends SecretArgsFluentImpl<SecretArgsBuilder> implements VisitableBuilder<SecretArgs,SecretArgsBuilder>{
  public SecretArgsBuilder() {
    this(false);
  }
  public SecretArgsBuilder(Boolean validationEnabled) {
    this(new SecretArgs(), validationEnabled);
  }
  public SecretArgsBuilder(SecretArgsFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretArgsBuilder(SecretArgsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretArgs(), validationEnabled);
  }
  public SecretArgsBuilder(SecretArgsFluent<?> fluent,SecretArgs instance) {
    this(fluent, instance, false);
  }
  public SecretArgsBuilder(SecretArgsFluent<?> fluent,SecretArgs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBehavior(instance.getBehavior());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvs(instance.getEnvs());
      fluent.withFiles(instance.getFiles());
      fluent.withLiterals(instance.getLiterals());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withOptions(instance.getOptions());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretArgsBuilder(SecretArgs instance) {
    this(instance,false);
  }
  public SecretArgsBuilder(SecretArgs instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBehavior(instance.getBehavior());
      this.withEnv(instance.getEnv());
      this.withEnvs(instance.getEnvs());
      this.withFiles(instance.getFiles());
      this.withLiterals(instance.getLiterals());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withOptions(instance.getOptions());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretArgsFluent<?> fluent;
  Boolean validationEnabled;
  public SecretArgs build() {
    SecretArgs buildable = new SecretArgs(fluent.getBehavior(),fluent.getEnv(),fluent.getEnvs(),fluent.getFiles(),fluent.getLiterals(),fluent.getName(),fluent.getNamespace(),fluent.getOptions(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}