package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapArgsBuilder extends ConfigMapArgsFluentImpl<ConfigMapArgsBuilder> implements VisitableBuilder<ConfigMapArgs,ConfigMapArgsBuilder>{
  public ConfigMapArgsBuilder() {
    this(false);
  }
  public ConfigMapArgsBuilder(Boolean validationEnabled) {
    this(new ConfigMapArgs(), validationEnabled);
  }
  public ConfigMapArgsBuilder(ConfigMapArgsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapArgsBuilder(ConfigMapArgsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapArgs(), validationEnabled);
  }
  public ConfigMapArgsBuilder(ConfigMapArgsFluent<?> fluent,ConfigMapArgs instance) {
    this(fluent, instance, false);
  }
  public ConfigMapArgsBuilder(ConfigMapArgsFluent<?> fluent,ConfigMapArgs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBehavior(instance.getBehavior());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvs(instance.getEnvs());
      fluent.withFiles(instance.getFiles());
      fluent.withLiterals(instance.getLiterals());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withOptions(instance.getOptions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapArgsBuilder(ConfigMapArgs instance) {
    this(instance,false);
  }
  public ConfigMapArgsBuilder(ConfigMapArgs instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBehavior(instance.getBehavior());
      this.withEnv(instance.getEnv());
      this.withEnvs(instance.getEnvs());
      this.withFiles(instance.getFiles());
      this.withLiterals(instance.getLiterals());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withOptions(instance.getOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapArgsFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapArgs build() {
    ConfigMapArgs buildable = new ConfigMapArgs(fluent.getBehavior(),fluent.getEnv(),fluent.getEnvs(),fluent.getFiles(),fluent.getLiterals(),fluent.getName(),fluent.getNamespace(),fluent.getOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}