package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;

 /**
  * Generated
  */
public interface KustomizationFluent<A extends KustomizationFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToBases(int index,String item);
  public A setToBases(int index,String item);
  public A addToBases(java.lang.String... items);
  public A addAllToBases(Collection<String> items);
  public A removeFromBases(java.lang.String... items);
  public A removeAllFromBases(Collection<String> items);
  public List<String> getBases();
  public String getBasis(int index);
  public String getFirstBasis();
  public String getLastBasis();
  public String getMatchingBasis(Predicate<String> predicate);
  public Boolean hasMatchingBasis(Predicate<String> predicate);
  public A withBases(List<String> bases);
  public A withBases(java.lang.String... bases);
  public Boolean hasBases();
  public A addToBuildMetadata(int index,String item);
  public A setToBuildMetadata(int index,String item);
  public A addToBuildMetadata(java.lang.String... items);
  public A addAllToBuildMetadata(Collection<String> items);
  public A removeFromBuildMetadata(java.lang.String... items);
  public A removeAllFromBuildMetadata(Collection<String> items);
  public List<String> getBuildMetadata();
  public String getBuildMetadatum(int index);
  public String getFirstBuildMetadatum();
  public String getLastBuildMetadatum();
  public String getMatchingBuildMetadatum(Predicate<String> predicate);
  public Boolean hasMatchingBuildMetadatum(Predicate<String> predicate);
  public A withBuildMetadata(List<String> buildMetadata);
  public A withBuildMetadata(java.lang.String... buildMetadata);
  public Boolean hasBuildMetadata();
  public A addToCommonAnnotations(String key,String value);
  public A addToCommonAnnotations(Map<String,String> map);
  public A removeFromCommonAnnotations(String key);
  public A removeFromCommonAnnotations(Map<String,String> map);
  public Map<String,String> getCommonAnnotations();
  public <K,V>A withCommonAnnotations(Map<String,String> commonAnnotations);
  public Boolean hasCommonAnnotations();
  public A addToCommonLabels(String key,String value);
  public A addToCommonLabels(Map<String,String> map);
  public A removeFromCommonLabels(String key);
  public A removeFromCommonLabels(Map<String,String> map);
  public Map<String,String> getCommonLabels();
  public <K,V>A withCommonLabels(Map<String,String> commonLabels);
  public Boolean hasCommonLabels();
  public A addToComponents(int index,String item);
  public A setToComponents(int index,String item);
  public A addToComponents(java.lang.String... items);
  public A addAllToComponents(Collection<String> items);
  public A removeFromComponents(java.lang.String... items);
  public A removeAllFromComponents(Collection<String> items);
  public List<String> getComponents();
  public String getComponent(int index);
  public String getFirstComponent();
  public String getLastComponent();
  public String getMatchingComponent(Predicate<String> predicate);
  public Boolean hasMatchingComponent(Predicate<String> predicate);
  public A withComponents(List<String> components);
  public A withComponents(java.lang.String... components);
  public Boolean hasComponents();
  public A addToConfigMapGenerator(int index,ConfigMapArgs item);
  public A setToConfigMapGenerator(int index,ConfigMapArgs item);
  public A addToConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... items);
  public A addAllToConfigMapGenerator(Collection<ConfigMapArgs> items);
  public A removeFromConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... items);
  public A removeAllFromConfigMapGenerator(Collection<ConfigMapArgs> items);
  public A removeMatchingFromConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfigMapGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigMapArgs> getConfigMapGenerator();
  public List<ConfigMapArgs> buildConfigMapGenerator();
  public ConfigMapArgs buildConfigMapGenerator(int index);
  public ConfigMapArgs buildFirstConfigMapGenerator();
  public ConfigMapArgs buildLastConfigMapGenerator();
  public ConfigMapArgs buildMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate);
  public Boolean hasMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate);
  public A withConfigMapGenerator(List<ConfigMapArgs> configMapGenerator);
  public A withConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... configMapGenerator);
  public Boolean hasConfigMapGenerator();
  public KustomizationFluent.ConfigMapGeneratorNested<A> addNewConfigMapGenerator();
  public KustomizationFluent.ConfigMapGeneratorNested<A> addNewConfigMapGeneratorLike(ConfigMapArgs item);
  public KustomizationFluent.ConfigMapGeneratorNested<A> setNewConfigMapGeneratorLike(int index,ConfigMapArgs item);
  public KustomizationFluent.ConfigMapGeneratorNested<A> editConfigMapGenerator(int index);
  public KustomizationFluent.ConfigMapGeneratorNested<A> editFirstConfigMapGenerator();
  public KustomizationFluent.ConfigMapGeneratorNested<A> editLastConfigMapGenerator();
  public KustomizationFluent.ConfigMapGeneratorNested<A> editMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate);
  public A addToConfigurations(int index,String item);
  public A setToConfigurations(int index,String item);
  public A addToConfigurations(java.lang.String... items);
  public A addAllToConfigurations(Collection<String> items);
  public A removeFromConfigurations(java.lang.String... items);
  public A removeAllFromConfigurations(Collection<String> items);
  public List<String> getConfigurations();
  public String getConfiguration(int index);
  public String getFirstConfiguration();
  public String getLastConfiguration();
  public String getMatchingConfiguration(Predicate<String> predicate);
  public Boolean hasMatchingConfiguration(Predicate<String> predicate);
  public A withConfigurations(List<String> configurations);
  public A withConfigurations(java.lang.String... configurations);
  public Boolean hasConfigurations();
  public A addToCrds(int index,String item);
  public A setToCrds(int index,String item);
  public A addToCrds(java.lang.String... items);
  public A addAllToCrds(Collection<String> items);
  public A removeFromCrds(java.lang.String... items);
  public A removeAllFromCrds(Collection<String> items);
  public List<String> getCrds();
  public String getCrd(int index);
  public String getFirstCrd();
  public String getLastCrd();
  public String getMatchingCrd(Predicate<String> predicate);
  public Boolean hasMatchingCrd(Predicate<String> predicate);
  public A withCrds(List<String> crds);
  public A withCrds(java.lang.String... crds);
  public Boolean hasCrds();
  
  /**
   * This method has been deprecated, please use method buildGeneratorOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public GeneratorOptions getGeneratorOptions();
  public GeneratorOptions buildGeneratorOptions();
  public A withGeneratorOptions(GeneratorOptions generatorOptions);
  public Boolean hasGeneratorOptions();
  public KustomizationFluent.GeneratorOptionsNested<A> withNewGeneratorOptions();
  public KustomizationFluent.GeneratorOptionsNested<A> withNewGeneratorOptionsLike(GeneratorOptions item);
  public KustomizationFluent.GeneratorOptionsNested<A> editGeneratorOptions();
  public KustomizationFluent.GeneratorOptionsNested<A> editOrNewGeneratorOptions();
  public KustomizationFluent.GeneratorOptionsNested<A> editOrNewGeneratorOptionsLike(GeneratorOptions item);
  public A addToGenerators(int index,String item);
  public A setToGenerators(int index,String item);
  public A addToGenerators(java.lang.String... items);
  public A addAllToGenerators(Collection<String> items);
  public A removeFromGenerators(java.lang.String... items);
  public A removeAllFromGenerators(Collection<String> items);
  public List<String> getGenerators();
  public String getGenerator(int index);
  public String getFirstGenerator();
  public String getLastGenerator();
  public String getMatchingGenerator(Predicate<String> predicate);
  public Boolean hasMatchingGenerator(Predicate<String> predicate);
  public A withGenerators(List<String> generators);
  public A withGenerators(java.lang.String... generators);
  public Boolean hasGenerators();
  public A addToHelmChartInflationGenerator(int index,HelmChartArgs item);
  public A setToHelmChartInflationGenerator(int index,HelmChartArgs item);
  public A addToHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... items);
  public A addAllToHelmChartInflationGenerator(Collection<HelmChartArgs> items);
  public A removeFromHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... items);
  public A removeAllFromHelmChartInflationGenerator(Collection<HelmChartArgs> items);
  public A removeMatchingFromHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHelmChartInflationGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HelmChartArgs> getHelmChartInflationGenerator();
  public List<HelmChartArgs> buildHelmChartInflationGenerator();
  public HelmChartArgs buildHelmChartInflationGenerator(int index);
  public HelmChartArgs buildFirstHelmChartInflationGenerator();
  public HelmChartArgs buildLastHelmChartInflationGenerator();
  public HelmChartArgs buildMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate);
  public Boolean hasMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate);
  public A withHelmChartInflationGenerator(List<HelmChartArgs> helmChartInflationGenerator);
  public A withHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... helmChartInflationGenerator);
  public Boolean hasHelmChartInflationGenerator();
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> addNewHelmChartInflationGenerator();
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> addNewHelmChartInflationGeneratorLike(HelmChartArgs item);
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> setNewHelmChartInflationGeneratorLike(int index,HelmChartArgs item);
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editHelmChartInflationGenerator(int index);
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editFirstHelmChartInflationGenerator();
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editLastHelmChartInflationGenerator();
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate);
  public A addToHelmCharts(int index,HelmChart item);
  public A setToHelmCharts(int index,HelmChart item);
  public A addToHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... items);
  public A addAllToHelmCharts(Collection<HelmChart> items);
  public A removeFromHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... items);
  public A removeAllFromHelmCharts(Collection<HelmChart> items);
  public A removeMatchingFromHelmCharts(Predicate<HelmChartBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHelmCharts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HelmChart> getHelmCharts();
  public List<HelmChart> buildHelmCharts();
  public HelmChart buildHelmChart(int index);
  public HelmChart buildFirstHelmChart();
  public HelmChart buildLastHelmChart();
  public HelmChart buildMatchingHelmChart(Predicate<HelmChartBuilder> predicate);
  public Boolean hasMatchingHelmChart(Predicate<HelmChartBuilder> predicate);
  public A withHelmCharts(List<HelmChart> helmCharts);
  public A withHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... helmCharts);
  public Boolean hasHelmCharts();
  public KustomizationFluent.HelmChartsNested<A> addNewHelmChart();
  public KustomizationFluent.HelmChartsNested<A> addNewHelmChartLike(HelmChart item);
  public KustomizationFluent.HelmChartsNested<A> setNewHelmChartLike(int index,HelmChart item);
  public KustomizationFluent.HelmChartsNested<A> editHelmChart(int index);
  public KustomizationFluent.HelmChartsNested<A> editFirstHelmChart();
  public KustomizationFluent.HelmChartsNested<A> editLastHelmChart();
  public KustomizationFluent.HelmChartsNested<A> editMatchingHelmChart(Predicate<HelmChartBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHelmGlobals instead.
   * @return The buildable object.
   */
  @Deprecated
  public HelmGlobals getHelmGlobals();
  public HelmGlobals buildHelmGlobals();
  public A withHelmGlobals(HelmGlobals helmGlobals);
  public Boolean hasHelmGlobals();
  public A withNewHelmGlobals(String chartHome,String configHome);
  public KustomizationFluent.HelmGlobalsNested<A> withNewHelmGlobals();
  public KustomizationFluent.HelmGlobalsNested<A> withNewHelmGlobalsLike(HelmGlobals item);
  public KustomizationFluent.HelmGlobalsNested<A> editHelmGlobals();
  public KustomizationFluent.HelmGlobalsNested<A> editOrNewHelmGlobals();
  public KustomizationFluent.HelmGlobalsNested<A> editOrNewHelmGlobalsLike(HelmGlobals item);
  public A addToImageTags(int index,Image item);
  public A setToImageTags(int index,Image item);
  public A addToImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items);
  public A addAllToImageTags(Collection<Image> items);
  public A removeFromImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items);
  public A removeAllFromImageTags(Collection<Image> items);
  public A removeMatchingFromImageTags(Predicate<ImageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImageTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Image> getImageTags();
  public List<Image> buildImageTags();
  public Image buildImageTag(int index);
  public Image buildFirstImageTag();
  public Image buildLastImageTag();
  public Image buildMatchingImageTag(Predicate<ImageBuilder> predicate);
  public Boolean hasMatchingImageTag(Predicate<ImageBuilder> predicate);
  public A withImageTags(List<Image> imageTags);
  public A withImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... imageTags);
  public Boolean hasImageTags();
  public A addNewImageTag(String digest,String name,String newName,String newTag,String tagSuffix);
  public KustomizationFluent.ImageTagsNested<A> addNewImageTag();
  public KustomizationFluent.ImageTagsNested<A> addNewImageTagLike(Image item);
  public KustomizationFluent.ImageTagsNested<A> setNewImageTagLike(int index,Image item);
  public KustomizationFluent.ImageTagsNested<A> editImageTag(int index);
  public KustomizationFluent.ImageTagsNested<A> editFirstImageTag();
  public KustomizationFluent.ImageTagsNested<A> editLastImageTag();
  public KustomizationFluent.ImageTagsNested<A> editMatchingImageTag(Predicate<ImageBuilder> predicate);
  public A addToImages(int index,Image item);
  public A setToImages(int index,Image item);
  public A addToImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items);
  public A addAllToImages(Collection<Image> items);
  public A removeFromImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items);
  public A removeAllFromImages(Collection<Image> items);
  public A removeMatchingFromImages(Predicate<ImageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Image> getImages();
  public List<Image> buildImages();
  public Image buildImage(int index);
  public Image buildFirstImage();
  public Image buildLastImage();
  public Image buildMatchingImage(Predicate<ImageBuilder> predicate);
  public Boolean hasMatchingImage(Predicate<ImageBuilder> predicate);
  public A withImages(List<Image> images);
  public A withImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... images);
  public Boolean hasImages();
  public A addNewImage(String digest,String name,String newName,String newTag,String tagSuffix);
  public KustomizationFluent.ImagesNested<A> addNewImage();
  public KustomizationFluent.ImagesNested<A> addNewImageLike(Image item);
  public KustomizationFluent.ImagesNested<A> setNewImageLike(int index,Image item);
  public KustomizationFluent.ImagesNested<A> editImage(int index);
  public KustomizationFluent.ImagesNested<A> editFirstImage();
  public KustomizationFluent.ImagesNested<A> editLastImage();
  public KustomizationFluent.ImagesNested<A> editMatchingImage(Predicate<ImageBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public A addToLabels(int index,Label item);
  public A setToLabels(int index,Label item);
  public A addToLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... items);
  public A addAllToLabels(Collection<Label> items);
  public A removeFromLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... items);
  public A removeAllFromLabels(Collection<Label> items);
  public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Label> getLabels();
  public List<Label> buildLabels();
  public Label buildLabel(int index);
  public Label buildFirstLabel();
  public Label buildLastLabel();
  public Label buildMatchingLabel(Predicate<LabelBuilder> predicate);
  public Boolean hasMatchingLabel(Predicate<LabelBuilder> predicate);
  public A withLabels(List<Label> labels);
  public A withLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... labels);
  public Boolean hasLabels();
  public KustomizationFluent.LabelsNested<A> addNewLabel();
  public KustomizationFluent.LabelsNested<A> addNewLabelLike(Label item);
  public KustomizationFluent.LabelsNested<A> setNewLabelLike(int index,Label item);
  public KustomizationFluent.LabelsNested<A> editLabel(int index);
  public KustomizationFluent.LabelsNested<A> editFirstLabel();
  public KustomizationFluent.LabelsNested<A> editLastLabel();
  public KustomizationFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public KustomizationFluent.MetadataNested<A> withNewMetadata();
  public KustomizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public KustomizationFluent.MetadataNested<A> editMetadata();
  public KustomizationFluent.MetadataNested<A> editOrNewMetadata();
  public KustomizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public String getNamePrefix();
  public A withNamePrefix(String namePrefix);
  public Boolean hasNamePrefix();
  public String getNameSuffix();
  public A withNameSuffix(String nameSuffix);
  public Boolean hasNameSuffix();
  public String getNamespace();
  public A withNamespace(String namespace);
  public Boolean hasNamespace();
  public A addToOpenapi(String key,String value);
  public A addToOpenapi(Map<String,String> map);
  public A removeFromOpenapi(String key);
  public A removeFromOpenapi(Map<String,String> map);
  public Map<String,String> getOpenapi();
  public <K,V>A withOpenapi(Map<String,String> openapi);
  public Boolean hasOpenapi();
  public A addToPatches(int index,Patch item);
  public A setToPatches(int index,Patch item);
  public A addToPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items);
  public A addAllToPatches(Collection<Patch> items);
  public A removeFromPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items);
  public A removeAllFromPatches(Collection<Patch> items);
  public A removeMatchingFromPatches(Predicate<PatchBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPatches instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Patch> getPatches();
  public List<Patch> buildPatches();
  public Patch buildPatch(int index);
  public Patch buildFirstPatch();
  public Patch buildLastPatch();
  public Patch buildMatchingPatch(Predicate<PatchBuilder> predicate);
  public Boolean hasMatchingPatch(Predicate<PatchBuilder> predicate);
  public A withPatches(List<Patch> patches);
  public A withPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... patches);
  public Boolean hasPatches();
  public KustomizationFluent.PatchesNested<A> addNewPatch();
  public KustomizationFluent.PatchesNested<A> addNewPatchLike(Patch item);
  public KustomizationFluent.PatchesNested<A> setNewPatchLike(int index,Patch item);
  public KustomizationFluent.PatchesNested<A> editPatch(int index);
  public KustomizationFluent.PatchesNested<A> editFirstPatch();
  public KustomizationFluent.PatchesNested<A> editLastPatch();
  public KustomizationFluent.PatchesNested<A> editMatchingPatch(Predicate<PatchBuilder> predicate);
  public A addToPatchesJson6902(int index,Patch item);
  public A setToPatchesJson6902(int index,Patch item);
  public A addToPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items);
  public A addAllToPatchesJson6902(Collection<Patch> items);
  public A removeFromPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items);
  public A removeAllFromPatchesJson6902(Collection<Patch> items);
  public A removeMatchingFromPatchesJson6902(Predicate<PatchBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPatchesJson6902 instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Patch> getPatchesJson6902();
  public List<Patch> buildPatchesJson6902();
  public Patch buildPatchesJson6902(int index);
  public Patch buildFirstPatchesJson6902();
  public Patch buildLastPatchesJson6902();
  public Patch buildMatchingPatchesJson6902(Predicate<PatchBuilder> predicate);
  public Boolean hasMatchingPatchesJson6902(Predicate<PatchBuilder> predicate);
  public A withPatchesJson6902(List<Patch> patchesJson6902);
  public A withPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... patchesJson6902);
  public Boolean hasPatchesJson6902();
  public KustomizationFluent.PatchesJson6902Nested<A> addNewPatchesJson6902();
  public KustomizationFluent.PatchesJson6902Nested<A> addNewPatchesJson6902Like(Patch item);
  public KustomizationFluent.PatchesJson6902Nested<A> setNewPatchesJson6902Like(int index,Patch item);
  public KustomizationFluent.PatchesJson6902Nested<A> editPatchesJson6902(int index);
  public KustomizationFluent.PatchesJson6902Nested<A> editFirstPatchesJson6902();
  public KustomizationFluent.PatchesJson6902Nested<A> editLastPatchesJson6902();
  public KustomizationFluent.PatchesJson6902Nested<A> editMatchingPatchesJson6902(Predicate<PatchBuilder> predicate);
  public A addToPatchesStrategicMerge(int index,String item);
  public A setToPatchesStrategicMerge(int index,String item);
  public A addToPatchesStrategicMerge(java.lang.String... items);
  public A addAllToPatchesStrategicMerge(Collection<String> items);
  public A removeFromPatchesStrategicMerge(java.lang.String... items);
  public A removeAllFromPatchesStrategicMerge(Collection<String> items);
  public List<String> getPatchesStrategicMerge();
  public String getPatchesStrategicMerge(int index);
  public String getFirstPatchesStrategicMerge();
  public String getLastPatchesStrategicMerge();
  public String getMatchingPatchesStrategicMerge(Predicate<String> predicate);
  public Boolean hasMatchingPatchesStrategicMerge(Predicate<String> predicate);
  public A withPatchesStrategicMerge(List<String> patchesStrategicMerge);
  public A withPatchesStrategicMerge(java.lang.String... patchesStrategicMerge);
  public Boolean hasPatchesStrategicMerge();
  public A addToReplacements(int index,ReplacementField item);
  public A setToReplacements(int index,ReplacementField item);
  public A addToReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... items);
  public A addAllToReplacements(Collection<ReplacementField> items);
  public A removeFromReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... items);
  public A removeAllFromReplacements(Collection<ReplacementField> items);
  public A removeMatchingFromReplacements(Predicate<ReplacementFieldBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildReplacements instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ReplacementField> getReplacements();
  public List<ReplacementField> buildReplacements();
  public ReplacementField buildReplacement(int index);
  public ReplacementField buildFirstReplacement();
  public ReplacementField buildLastReplacement();
  public ReplacementField buildMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate);
  public Boolean hasMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate);
  public A withReplacements(List<ReplacementField> replacements);
  public A withReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... replacements);
  public Boolean hasReplacements();
  public KustomizationFluent.ReplacementsNested<A> addNewReplacement();
  public KustomizationFluent.ReplacementsNested<A> addNewReplacementLike(ReplacementField item);
  public KustomizationFluent.ReplacementsNested<A> setNewReplacementLike(int index,ReplacementField item);
  public KustomizationFluent.ReplacementsNested<A> editReplacement(int index);
  public KustomizationFluent.ReplacementsNested<A> editFirstReplacement();
  public KustomizationFluent.ReplacementsNested<A> editLastReplacement();
  public KustomizationFluent.ReplacementsNested<A> editMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate);
  public A addToReplicas(int index,Replica item);
  public A setToReplicas(int index,Replica item);
  public A addToReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... items);
  public A addAllToReplicas(Collection<Replica> items);
  public A removeFromReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... items);
  public A removeAllFromReplicas(Collection<Replica> items);
  public A removeMatchingFromReplicas(Predicate<ReplicaBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildReplicas instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Replica> getReplicas();
  public List<Replica> buildReplicas();
  public Replica buildReplica(int index);
  public Replica buildFirstReplica();
  public Replica buildLastReplica();
  public Replica buildMatchingReplica(Predicate<ReplicaBuilder> predicate);
  public Boolean hasMatchingReplica(Predicate<ReplicaBuilder> predicate);
  public A withReplicas(List<Replica> replicas);
  public A withReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... replicas);
  public Boolean hasReplicas();
  public A addNewReplica(Long count,String name);
  public KustomizationFluent.ReplicasNested<A> addNewReplica();
  public KustomizationFluent.ReplicasNested<A> addNewReplicaLike(Replica item);
  public KustomizationFluent.ReplicasNested<A> setNewReplicaLike(int index,Replica item);
  public KustomizationFluent.ReplicasNested<A> editReplica(int index);
  public KustomizationFluent.ReplicasNested<A> editFirstReplica();
  public KustomizationFluent.ReplicasNested<A> editLastReplica();
  public KustomizationFluent.ReplicasNested<A> editMatchingReplica(Predicate<ReplicaBuilder> predicate);
  public A addToResources(int index,String item);
  public A setToResources(int index,String item);
  public A addToResources(java.lang.String... items);
  public A addAllToResources(Collection<String> items);
  public A removeFromResources(java.lang.String... items);
  public A removeAllFromResources(Collection<String> items);
  public List<String> getResources();
  public String getResource(int index);
  public String getFirstResource();
  public String getLastResource();
  public String getMatchingResource(Predicate<String> predicate);
  public Boolean hasMatchingResource(Predicate<String> predicate);
  public A withResources(List<String> resources);
  public A withResources(java.lang.String... resources);
  public Boolean hasResources();
  public A addToSecretGenerator(int index,SecretArgs item);
  public A setToSecretGenerator(int index,SecretArgs item);
  public A addToSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... items);
  public A addAllToSecretGenerator(Collection<SecretArgs> items);
  public A removeFromSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... items);
  public A removeAllFromSecretGenerator(Collection<SecretArgs> items);
  public A removeMatchingFromSecretGenerator(Predicate<SecretArgsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSecretGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SecretArgs> getSecretGenerator();
  public List<SecretArgs> buildSecretGenerator();
  public SecretArgs buildSecretGenerator(int index);
  public SecretArgs buildFirstSecretGenerator();
  public SecretArgs buildLastSecretGenerator();
  public SecretArgs buildMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate);
  public Boolean hasMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate);
  public A withSecretGenerator(List<SecretArgs> secretGenerator);
  public A withSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... secretGenerator);
  public Boolean hasSecretGenerator();
  public KustomizationFluent.SecretGeneratorNested<A> addNewSecretGenerator();
  public KustomizationFluent.SecretGeneratorNested<A> addNewSecretGeneratorLike(SecretArgs item);
  public KustomizationFluent.SecretGeneratorNested<A> setNewSecretGeneratorLike(int index,SecretArgs item);
  public KustomizationFluent.SecretGeneratorNested<A> editSecretGenerator(int index);
  public KustomizationFluent.SecretGeneratorNested<A> editFirstSecretGenerator();
  public KustomizationFluent.SecretGeneratorNested<A> editLastSecretGenerator();
  public KustomizationFluent.SecretGeneratorNested<A> editMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSortOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SortOptions getSortOptions();
  public SortOptions buildSortOptions();
  public A withSortOptions(SortOptions sortOptions);
  public Boolean hasSortOptions();
  public KustomizationFluent.SortOptionsNested<A> withNewSortOptions();
  public KustomizationFluent.SortOptionsNested<A> withNewSortOptionsLike(SortOptions item);
  public KustomizationFluent.SortOptionsNested<A> editSortOptions();
  public KustomizationFluent.SortOptionsNested<A> editOrNewSortOptions();
  public KustomizationFluent.SortOptionsNested<A> editOrNewSortOptionsLike(SortOptions item);
  public A addToTransformers(int index,String item);
  public A setToTransformers(int index,String item);
  public A addToTransformers(java.lang.String... items);
  public A addAllToTransformers(Collection<String> items);
  public A removeFromTransformers(java.lang.String... items);
  public A removeAllFromTransformers(Collection<String> items);
  public List<String> getTransformers();
  public String getTransformer(int index);
  public String getFirstTransformer();
  public String getLastTransformer();
  public String getMatchingTransformer(Predicate<String> predicate);
  public Boolean hasMatchingTransformer(Predicate<String> predicate);
  public A withTransformers(List<String> transformers);
  public A withTransformers(java.lang.String... transformers);
  public Boolean hasTransformers();
  public A addToValidators(int index,String item);
  public A setToValidators(int index,String item);
  public A addToValidators(java.lang.String... items);
  public A addAllToValidators(Collection<String> items);
  public A removeFromValidators(java.lang.String... items);
  public A removeAllFromValidators(Collection<String> items);
  public List<String> getValidators();
  public String getValidator(int index);
  public String getFirstValidator();
  public String getLastValidator();
  public String getMatchingValidator(Predicate<String> predicate);
  public Boolean hasMatchingValidator(Predicate<String> predicate);
  public A withValidators(List<String> validators);
  public A withValidators(java.lang.String... validators);
  public Boolean hasValidators();
  public A addToVars(int index,Var item);
  public A setToVars(int index,Var item);
  public A addToVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... items);
  public A addAllToVars(Collection<Var> items);
  public A removeFromVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... items);
  public A removeAllFromVars(Collection<Var> items);
  public A removeMatchingFromVars(Predicate<VarBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVars instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Var> getVars();
  public List<Var> buildVars();
  public Var buildVar(int index);
  public Var buildFirstVar();
  public Var buildLastVar();
  public Var buildMatchingVar(Predicate<VarBuilder> predicate);
  public Boolean hasMatchingVar(Predicate<VarBuilder> predicate);
  public A withVars(List<Var> vars);
  public A withVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... vars);
  public Boolean hasVars();
  public KustomizationFluent.VarsNested<A> addNewVar();
  public KustomizationFluent.VarsNested<A> addNewVarLike(Var item);
  public KustomizationFluent.VarsNested<A> setNewVarLike(int index,Var item);
  public KustomizationFluent.VarsNested<A> editVar(int index);
  public KustomizationFluent.VarsNested<A> editFirstVar();
  public KustomizationFluent.VarsNested<A> editLastVar();
  public KustomizationFluent.VarsNested<A> editMatchingVar(Predicate<VarBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConfigMapGeneratorNested<N> extends Nested<N>,ConfigMapArgsFluent<KustomizationFluent.ConfigMapGeneratorNested<N>>{
    public N and();
    public N endConfigMapGenerator();
    
  }
  public interface GeneratorOptionsNested<N> extends Nested<N>,GeneratorOptionsFluent<KustomizationFluent.GeneratorOptionsNested<N>>{
    public N and();
    public N endGeneratorOptions();
    
  }
  public interface HelmChartInflationGeneratorNested<N> extends Nested<N>,HelmChartArgsFluent<KustomizationFluent.HelmChartInflationGeneratorNested<N>>{
    public N and();
    public N endHelmChartInflationGenerator();
    
  }
  public interface HelmChartsNested<N> extends Nested<N>,HelmChartFluent<KustomizationFluent.HelmChartsNested<N>>{
    public N and();
    public N endHelmChart();
    
  }
  public interface HelmGlobalsNested<N> extends Nested<N>,HelmGlobalsFluent<KustomizationFluent.HelmGlobalsNested<N>>{
    public N and();
    public N endHelmGlobals();
    
  }
  public interface ImageTagsNested<N> extends Nested<N>,ImageFluent<KustomizationFluent.ImageTagsNested<N>>{
    public N and();
    public N endImageTag();
    
  }
  public interface ImagesNested<N> extends Nested<N>,ImageFluent<KustomizationFluent.ImagesNested<N>>{
    public N and();
    public N endImage();
    
  }
  public interface LabelsNested<N> extends Nested<N>,LabelFluent<KustomizationFluent.LabelsNested<N>>{
    public N and();
    public N endLabel();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KustomizationFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface PatchesNested<N> extends Nested<N>,PatchFluent<KustomizationFluent.PatchesNested<N>>{
    public N and();
    public N endPatch();
    
  }
  public interface PatchesJson6902Nested<N> extends Nested<N>,PatchFluent<KustomizationFluent.PatchesJson6902Nested<N>>{
    public N and();
    public N endPatchesJson6902();
    
  }
  public interface ReplacementsNested<N> extends Nested<N>,ReplacementFieldFluent<KustomizationFluent.ReplacementsNested<N>>{
    public N and();
    public N endReplacement();
    
  }
  public interface ReplicasNested<N> extends Nested<N>,ReplicaFluent<KustomizationFluent.ReplicasNested<N>>{
    public N and();
    public N endReplica();
    
  }
  public interface SecretGeneratorNested<N> extends Nested<N>,SecretArgsFluent<KustomizationFluent.SecretGeneratorNested<N>>{
    public N and();
    public N endSecretGenerator();
    
  }
  public interface SortOptionsNested<N> extends Nested<N>,SortOptionsFluent<KustomizationFluent.SortOptionsNested<N>>{
    public N and();
    public N endSortOptions();
    
  }
  public interface VarsNested<N> extends Nested<N>,VarFluent<KustomizationFluent.VarsNested<N>>{
    public N and();
    public N endVar();
    
  }
  
}