package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmGlobalsBuilder extends HelmGlobalsFluentImpl<HelmGlobalsBuilder> implements VisitableBuilder<HelmGlobals,HelmGlobalsBuilder>{
  public HelmGlobalsBuilder() {
    this(false);
  }
  public HelmGlobalsBuilder(Boolean validationEnabled) {
    this(new HelmGlobals(), validationEnabled);
  }
  public HelmGlobalsBuilder(HelmGlobalsFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmGlobalsBuilder(HelmGlobalsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmGlobals(), validationEnabled);
  }
  public HelmGlobalsBuilder(HelmGlobalsFluent<?> fluent,HelmGlobals instance) {
    this(fluent, instance, false);
  }
  public HelmGlobalsBuilder(HelmGlobalsFluent<?> fluent,HelmGlobals instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChartHome(instance.getChartHome());
      fluent.withConfigHome(instance.getConfigHome());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HelmGlobalsBuilder(HelmGlobals instance) {
    this(instance,false);
  }
  public HelmGlobalsBuilder(HelmGlobals instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChartHome(instance.getChartHome());
      this.withConfigHome(instance.getConfigHome());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HelmGlobalsFluent<?> fluent;
  Boolean validationEnabled;
  public HelmGlobals build() {
    HelmGlobals buildable = new HelmGlobals(fluent.getChartHome(),fluent.getConfigHome());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}