/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpec;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpecBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldSpecFluentImpl;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.LabelFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LabelFluentImpl<A extends LabelFluent<A>>
extends BaseFluent<A>
implements LabelFluent<A> {
    private ArrayList<FieldSpecBuilder> fields = new ArrayList();
    private Boolean includeSelectors;
    private Boolean includeTemplates;
    private Map<String, String> pairs;
    private Map<String, Object> additionalProperties;

    public LabelFluentImpl() {
    }

    public LabelFluentImpl(Label instance) {
        this.withFields(instance.getFields());
        this.withIncludeSelectors(instance.getIncludeSelectors());
        this.withIncludeTemplates(instance.getIncludeTemplates());
        this.withPairs(instance.getPairs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToFields(Integer index, FieldSpec item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        FieldSpecBuilder builder = new FieldSpecBuilder(item);
        this._visitables.get((Object)"fields").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"fields").size(), builder);
        this.fields.add(index >= 0 ? index.intValue() : this.fields.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFields(Integer index, FieldSpec item) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        FieldSpecBuilder builder = new FieldSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"fields").size()) {
            this._visitables.get((Object)"fields").add(builder);
        } else {
            this._visitables.get((Object)"fields").set(index, builder);
        }
        if (index < 0 || index >= this.fields.size()) {
            this.fields.add(builder);
        } else {
            this.fields.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFields(FieldSpec ... items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFields(Collection<FieldSpec> items) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").add(builder);
            this.fields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFields(FieldSpec ... items) {
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").remove(builder);
            if (this.fields == null) continue;
            this.fields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFields(Collection<FieldSpec> items) {
        for (FieldSpec item : items) {
            FieldSpecBuilder builder = new FieldSpecBuilder(item);
            this._visitables.get((Object)"fields").remove(builder);
            if (this.fields == null) continue;
            this.fields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFields(Predicate<FieldSpecBuilder> predicate) {
        if (this.fields == null) {
            return (A)this;
        }
        Iterator<FieldSpecBuilder> each = this.fields.iterator();
        List visitables = this._visitables.get((Object)"fields");
        while (each.hasNext()) {
            FieldSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<FieldSpec> getFields() {
        return this.fields != null ? LabelFluentImpl.build(this.fields) : null;
    }

    @Override
    public List<FieldSpec> buildFields() {
        return this.fields != null ? LabelFluentImpl.build(this.fields) : null;
    }

    @Override
    public FieldSpec buildField(Integer index) {
        return this.fields.get(index).build();
    }

    @Override
    public FieldSpec buildFirstField() {
        return this.fields.get(0).build();
    }

    @Override
    public FieldSpec buildLastField() {
        return this.fields.get(this.fields.size() - 1).build();
    }

    @Override
    public FieldSpec buildMatchingField(Predicate<FieldSpecBuilder> predicate) {
        for (FieldSpecBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingField(Predicate<FieldSpecBuilder> predicate) {
        for (FieldSpecBuilder item : this.fields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFields(List<FieldSpec> fields) {
        if (this.fields != null) {
            this._visitables.get((Object)"fields").removeAll(this.fields);
        }
        if (fields != null) {
            this.fields = new ArrayList();
            for (FieldSpec item : fields) {
                this.addToFields(item);
            }
        } else {
            this.fields = null;
        }
        return (A)this;
    }

    @Override
    public A withFields(FieldSpec ... fields) {
        if (this.fields != null) {
            this.fields.clear();
        }
        if (fields != null) {
            for (FieldSpec item : fields) {
                this.addToFields(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    @Override
    public A addNewField(Boolean create, String group, String kind, String path, String version) {
        return this.addToFields(new FieldSpec(create, group, kind, path, version));
    }

    @Override
    public LabelFluent.FieldsNested<A> addNewField() {
        return new FieldsNestedImpl();
    }

    @Override
    public LabelFluent.FieldsNested<A> addNewFieldLike(FieldSpec item) {
        return new FieldsNestedImpl(-1, item);
    }

    @Override
    public LabelFluent.FieldsNested<A> setNewFieldLike(Integer index, FieldSpec item) {
        return new FieldsNestedImpl(index, item);
    }

    @Override
    public LabelFluent.FieldsNested<A> editField(Integer index) {
        if (this.fields.size() <= index) {
            throw new RuntimeException("Can't edit fields. Index exceeds size.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    @Override
    public LabelFluent.FieldsNested<A> editFirstField() {
        if (this.fields.size() == 0) {
            throw new RuntimeException("Can't edit first fields. The list is empty.");
        }
        return this.setNewFieldLike(0, this.buildField(0));
    }

    @Override
    public LabelFluent.FieldsNested<A> editLastField() {
        int index = this.fields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fields. The list is empty.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    @Override
    public LabelFluent.FieldsNested<A> editMatchingField(Predicate<FieldSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!predicate.test(this.fields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fields. No match found.");
        }
        return this.setNewFieldLike(index, this.buildField(index));
    }

    @Override
    public Boolean getIncludeSelectors() {
        return this.includeSelectors;
    }

    @Override
    public A withIncludeSelectors(Boolean includeSelectors) {
        this.includeSelectors = includeSelectors;
        return (A)this;
    }

    @Override
    public Boolean hasIncludeSelectors() {
        return this.includeSelectors != null;
    }

    @Override
    public Boolean getIncludeTemplates() {
        return this.includeTemplates;
    }

    @Override
    public A withIncludeTemplates(Boolean includeTemplates) {
        this.includeTemplates = includeTemplates;
        return (A)this;
    }

    @Override
    public Boolean hasIncludeTemplates() {
        return this.includeTemplates != null;
    }

    @Override
    public A addToPairs(String key, String value) {
        if (this.pairs == null && key != null && value != null) {
            this.pairs = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.pairs.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPairs(Map<String, String> map) {
        if (this.pairs == null && map != null) {
            this.pairs = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.pairs.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPairs(String key) {
        if (this.pairs == null) {
            return (A)this;
        }
        if (key != null && this.pairs != null) {
            this.pairs.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPairs(Map<String, String> map) {
        if (this.pairs == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.pairs == null) continue;
                this.pairs.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getPairs() {
        return this.pairs;
    }

    @Override
    public <K, V> A withPairs(Map<String, String> pairs) {
        this.pairs = pairs == null ? null : new LinkedHashMap<String, String>(pairs);
        return (A)this;
    }

    @Override
    public Boolean hasPairs() {
        return this.pairs != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelFluentImpl that = (LabelFluentImpl)o;
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        if (this.includeSelectors != null ? !this.includeSelectors.equals(that.includeSelectors) : that.includeSelectors != null) {
            return false;
        }
        if (this.includeTemplates != null ? !this.includeTemplates.equals(that.includeTemplates) : that.includeTemplates != null) {
            return false;
        }
        if (this.pairs != null ? !this.pairs.equals(that.pairs) : that.pairs != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.includeSelectors, this.includeTemplates, this.pairs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fields != null && !this.fields.isEmpty()) {
            sb.append("fields:");
            sb.append(this.fields + ",");
        }
        if (this.includeSelectors != null) {
            sb.append("includeSelectors:");
            sb.append(this.includeSelectors + ",");
        }
        if (this.includeTemplates != null) {
            sb.append("includeTemplates:");
            sb.append(this.includeTemplates + ",");
        }
        if (this.pairs != null && !this.pairs.isEmpty()) {
            sb.append("pairs:");
            sb.append(this.pairs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIncludeSelectors() {
        return this.withIncludeSelectors(true);
    }

    @Override
    public A withIncludeTemplates() {
        return this.withIncludeTemplates(true);
    }

    class FieldsNestedImpl<N>
    extends FieldSpecFluentImpl<LabelFluent.FieldsNested<N>>
    implements LabelFluent.FieldsNested<N>,
    Nested<N> {
        FieldSpecBuilder builder;
        Integer index;

        FieldsNestedImpl(Integer index, FieldSpec item) {
            this.index = index;
            this.builder = new FieldSpecBuilder(this, item);
        }

        FieldsNestedImpl() {
            this.index = -1;
            this.builder = new FieldSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)LabelFluentImpl.this.setToFields(this.index, this.builder.build());
        }

        @Override
        public N endField() {
            return this.and();
        }
    }
}

