package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TargetSelectorFluentImpl<A extends TargetSelectorFluent<A>> extends BaseFluent<A> implements TargetSelectorFluent<A>{
  public TargetSelectorFluentImpl() {
  }
  public TargetSelectorFluentImpl(TargetSelector instance) {
    this.withFieldPaths(instance.getFieldPaths()); 
    this.withOptions(instance.getOptions()); 
    this.withReject(instance.getReject()); 
    this.withSelect(instance.getSelect()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> fieldPaths = new ArrayList<String>();
  private FieldOptionsBuilder options;
  private ArrayList<SelectorBuilder> reject = new ArrayList<SelectorBuilder>();
  private SelectorBuilder select;
  private Map<String,Object> additionalProperties;
  public A addToFieldPaths(Integer index,String item) {
    if (this.fieldPaths == null) {this.fieldPaths = new ArrayList<String>();}
    this.fieldPaths.add(index, item);
    return (A)this;
  }
  public A setToFieldPaths(Integer index,String item) {
    if (this.fieldPaths == null) {this.fieldPaths = new ArrayList<String>();}
    this.fieldPaths.set(index, item); return (A)this;
  }
  public A addToFieldPaths(java.lang.String... items) {
    if (this.fieldPaths == null) {this.fieldPaths = new ArrayList<String>();}
    for (String item : items) {this.fieldPaths.add(item);} return (A)this;
  }
  public A addAllToFieldPaths(Collection<String> items) {
    if (this.fieldPaths == null) {this.fieldPaths = new ArrayList<String>();}
    for (String item : items) {this.fieldPaths.add(item);} return (A)this;
  }
  public A removeFromFieldPaths(java.lang.String... items) {
    for (String item : items) {if (this.fieldPaths!= null){ this.fieldPaths.remove(item);}} return (A)this;
  }
  public A removeAllFromFieldPaths(Collection<String> items) {
    for (String item : items) {if (this.fieldPaths!= null){ this.fieldPaths.remove(item);}} return (A)this;
  }
  public List<String> getFieldPaths() {
    return this.fieldPaths;
  }
  public String getFieldPath(Integer index) {
    return this.fieldPaths.get(index);
  }
  public String getFirstFieldPath() {
    return this.fieldPaths.get(0);
  }
  public String getLastFieldPath() {
    return this.fieldPaths.get(fieldPaths.size() - 1);
  }
  public String getMatchingFieldPath(Predicate<String> predicate) {
    for (String item: fieldPaths) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingFieldPath(Predicate<String> predicate) {
    for (String item: fieldPaths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFieldPaths(List<String> fieldPaths) {
    if (fieldPaths != null) {this.fieldPaths = new ArrayList(); for (String item : fieldPaths){this.addToFieldPaths(item);}} else { this.fieldPaths = null;} return (A) this;
  }
  public A withFieldPaths(java.lang.String... fieldPaths) {
    if (this.fieldPaths != null) {this.fieldPaths.clear();}
    if (fieldPaths != null) {for (String item :fieldPaths){ this.addToFieldPaths(item);}} return (A) this;
  }
  public Boolean hasFieldPaths() {
    return fieldPaths != null && !fieldPaths.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public FieldOptions getOptions() {
    return this.options!=null ?this.options.build():null;
  }
  public FieldOptions buildOptions() {
    return this.options!=null ?this.options.build():null;
  }
  public A withOptions(FieldOptions options) {
    _visitables.get("options").remove(this.options);
    if (options!=null){ this.options= new FieldOptionsBuilder(options); _visitables.get("options").add(this.options);} else { this.options = null; _visitables.get("options").remove(this.options); } return (A) this;
  }
  public Boolean hasOptions() {
    return this.options != null;
  }
  public A withNewOptions(Boolean create,String delimiter,String encoding,Integer index) {
    return (A)withOptions(new FieldOptions(create, delimiter, encoding, index));
  }
  public TargetSelectorFluent.OptionsNested<A> withNewOptions() {
    return new TargetSelectorFluentImpl.OptionsNestedImpl();
  }
  public TargetSelectorFluent.OptionsNested<A> withNewOptionsLike(FieldOptions item) {
    return new TargetSelectorFluentImpl.OptionsNestedImpl(item);
  }
  public TargetSelectorFluent.OptionsNested<A> editOptions() {
    return withNewOptionsLike(getOptions());
  }
  public TargetSelectorFluent.OptionsNested<A> editOrNewOptions() {
    return withNewOptionsLike(getOptions() != null ? getOptions(): new FieldOptionsBuilder().build());
  }
  public TargetSelectorFluent.OptionsNested<A> editOrNewOptionsLike(FieldOptions item) {
    return withNewOptionsLike(getOptions() != null ? getOptions(): item);
  }
  public A addToReject(Integer index,Selector item) {
    if (this.reject == null) {this.reject = new ArrayList<SelectorBuilder>();}
    SelectorBuilder builder = new SelectorBuilder(item);_visitables.get("reject").add(index >= 0 ? index : _visitables.get("reject").size(), builder);this.reject.add(index >= 0 ? index : reject.size(), builder); return (A)this;
  }
  public A setToReject(Integer index,Selector item) {
    if (this.reject == null) {this.reject = new ArrayList<SelectorBuilder>();}
    SelectorBuilder builder = new SelectorBuilder(item);
    if (index < 0 || index >= _visitables.get("reject").size()) { _visitables.get("reject").add(builder); } else { _visitables.get("reject").set(index, builder);}
    if (index < 0 || index >= reject.size()) { reject.add(builder); } else { reject.set(index, builder);}
     return (A)this;
  }
  public A addToReject(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector... items) {
    if (this.reject == null) {this.reject = new ArrayList<SelectorBuilder>();}
    for (Selector item : items) {SelectorBuilder builder = new SelectorBuilder(item);_visitables.get("reject").add(builder);this.reject.add(builder);} return (A)this;
  }
  public A addAllToReject(Collection<Selector> items) {
    if (this.reject == null) {this.reject = new ArrayList<SelectorBuilder>();}
    for (Selector item : items) {SelectorBuilder builder = new SelectorBuilder(item);_visitables.get("reject").add(builder);this.reject.add(builder);} return (A)this;
  }
  public A removeFromReject(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector... items) {
    for (Selector item : items) {SelectorBuilder builder = new SelectorBuilder(item);_visitables.get("reject").remove(builder);if (this.reject != null) {this.reject.remove(builder);}} return (A)this;
  }
  public A removeAllFromReject(Collection<Selector> items) {
    for (Selector item : items) {SelectorBuilder builder = new SelectorBuilder(item);_visitables.get("reject").remove(builder);if (this.reject != null) {this.reject.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReject(Predicate<SelectorBuilder> predicate) {
    if (reject == null) return (A) this;
    final Iterator<SelectorBuilder> each = reject.iterator();
    final List visitables = _visitables.get("reject");
    while (each.hasNext()) {
      SelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildReject instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Selector> getReject() {
    return reject != null ? build(reject) : null;
  }
  public List<Selector> buildReject() {
    return reject != null ? build(reject) : null;
  }
  public Selector buildReject(Integer index) {
    return this.reject.get(index).build();
  }
  public Selector buildFirstReject() {
    return this.reject.get(0).build();
  }
  public Selector buildLastReject() {
    return this.reject.get(reject.size() - 1).build();
  }
  public Selector buildMatchingReject(Predicate<SelectorBuilder> predicate) {
    for (SelectorBuilder item: reject) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingReject(Predicate<SelectorBuilder> predicate) {
    for (SelectorBuilder item: reject) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReject(List<Selector> reject) {
    if (this.reject != null) { _visitables.get("reject").removeAll(this.reject);}
    if (reject != null) {this.reject = new ArrayList(); for (Selector item : reject){this.addToReject(item);}} else { this.reject = null;} return (A) this;
  }
  public A withReject(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector... reject) {
    if (this.reject != null) {this.reject.clear();}
    if (reject != null) {for (Selector item :reject){ this.addToReject(item);}} return (A) this;
  }
  public Boolean hasReject() {
    return reject != null && !reject.isEmpty();
  }
  public TargetSelectorFluent.RejectNested<A> addNewReject() {
    return new TargetSelectorFluentImpl.RejectNestedImpl();
  }
  public TargetSelectorFluent.RejectNested<A> addNewRejectLike(Selector item) {
    return new TargetSelectorFluentImpl.RejectNestedImpl(-1, item);
  }
  public TargetSelectorFluent.RejectNested<A> setNewRejectLike(Integer index,Selector item) {
    return new TargetSelectorFluentImpl.RejectNestedImpl(index, item);
  }
  public TargetSelectorFluent.RejectNested<A> editReject(Integer index) {
    if (reject.size() <= index) throw new RuntimeException("Can't edit reject. Index exceeds size.");
    return setNewRejectLike(index, buildReject(index));
  }
  public TargetSelectorFluent.RejectNested<A> editFirstReject() {
    if (reject.size() == 0) throw new RuntimeException("Can't edit first reject. The list is empty.");
    return setNewRejectLike(0, buildReject(0));
  }
  public TargetSelectorFluent.RejectNested<A> editLastReject() {
    int index = reject.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last reject. The list is empty.");
    return setNewRejectLike(index, buildReject(index));
  }
  public TargetSelectorFluent.RejectNested<A> editMatchingReject(Predicate<SelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<reject.size();i++) { 
    if (predicate.test(reject.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching reject. No match found.");
    return setNewRejectLike(index, buildReject(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelect instead.
   * @return The buildable object.
   */
  @Deprecated
  public Selector getSelect() {
    return this.select!=null ?this.select.build():null;
  }
  public Selector buildSelect() {
    return this.select!=null ?this.select.build():null;
  }
  public A withSelect(Selector select) {
    _visitables.get("select").remove(this.select);
    if (select!=null){ this.select= new SelectorBuilder(select); _visitables.get("select").add(this.select);} else { this.select = null; _visitables.get("select").remove(this.select); } return (A) this;
  }
  public Boolean hasSelect() {
    return this.select != null;
  }
  public TargetSelectorFluent.SelectNested<A> withNewSelect() {
    return new TargetSelectorFluentImpl.SelectNestedImpl();
  }
  public TargetSelectorFluent.SelectNested<A> withNewSelectLike(Selector item) {
    return new TargetSelectorFluentImpl.SelectNestedImpl(item);
  }
  public TargetSelectorFluent.SelectNested<A> editSelect() {
    return withNewSelectLike(getSelect());
  }
  public TargetSelectorFluent.SelectNested<A> editOrNewSelect() {
    return withNewSelectLike(getSelect() != null ? getSelect(): new SelectorBuilder().build());
  }
  public TargetSelectorFluent.SelectNested<A> editOrNewSelectLike(Selector item) {
    return withNewSelectLike(getSelect() != null ? getSelect(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TargetSelectorFluentImpl that = (TargetSelectorFluentImpl) o;
    if (fieldPaths != null ? !fieldPaths.equals(that.fieldPaths) :that.fieldPaths != null) return false;
    if (options != null ? !options.equals(that.options) :that.options != null) return false;
    if (reject != null ? !reject.equals(that.reject) :that.reject != null) return false;
    if (select != null ? !select.equals(that.select) :that.select != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fieldPaths,  options,  reject,  select,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fieldPaths != null && !fieldPaths.isEmpty()) { sb.append("fieldPaths:"); sb.append(fieldPaths + ","); }
    if (options != null) { sb.append("options:"); sb.append(options + ","); }
    if (reject != null && !reject.isEmpty()) { sb.append("reject:"); sb.append(reject + ","); }
    if (select != null) { sb.append("select:"); sb.append(select + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class OptionsNestedImpl<N> extends FieldOptionsFluentImpl<TargetSelectorFluent.OptionsNested<N>> implements TargetSelectorFluent.OptionsNested<N>,Nested<N>{
    OptionsNestedImpl(FieldOptions item) {
      this.builder = new FieldOptionsBuilder(this, item);
    }
    OptionsNestedImpl() {
      this.builder = new FieldOptionsBuilder(this);
    }
    FieldOptionsBuilder builder;
    public N and() {
      return (N) TargetSelectorFluentImpl.this.withOptions(builder.build());
    }
    public N endOptions() {
      return and();
    }
    
  }
  class RejectNestedImpl<N> extends SelectorFluentImpl<TargetSelectorFluent.RejectNested<N>> implements TargetSelectorFluent.RejectNested<N>,Nested<N>{
    RejectNestedImpl(Integer index,Selector item) {
      this.index = index;
      this.builder = new SelectorBuilder(this, item);
    }
    RejectNestedImpl() {
      this.index = -1;
      this.builder = new SelectorBuilder(this);
    }
    SelectorBuilder builder;
    Integer index;
    public N and() {
      return (N) TargetSelectorFluentImpl.this.setToReject(index,builder.build());
    }
    public N endReject() {
      return and();
    }
    
  }
  class SelectNestedImpl<N> extends SelectorFluentImpl<TargetSelectorFluent.SelectNested<N>> implements TargetSelectorFluent.SelectNested<N>,Nested<N>{
    SelectNestedImpl(Selector item) {
      this.builder = new SelectorBuilder(this, item);
    }
    SelectNestedImpl() {
      this.builder = new SelectorBuilder(this);
    }
    SelectorBuilder builder;
    public N and() {
      return (N) TargetSelectorFluentImpl.this.withSelect(builder.build());
    }
    public N endSelect() {
      return and();
    }
    
  }
  
}