package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SortOptionsBuilder extends SortOptionsFluentImpl<SortOptionsBuilder> implements VisitableBuilder<SortOptions,SortOptionsBuilder>{
  public SortOptionsBuilder() {
    this(false);
  }
  public SortOptionsBuilder(Boolean validationEnabled) {
    this(new SortOptions(), validationEnabled);
  }
  public SortOptionsBuilder(SortOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SortOptionsBuilder(SortOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SortOptions(), validationEnabled);
  }
  public SortOptionsBuilder(SortOptionsFluent<?> fluent,SortOptions instance) {
    this(fluent, instance, false);
  }
  public SortOptionsBuilder(SortOptionsFluent<?> fluent,SortOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLegacySortOptions(instance.getLegacySortOptions()); 
    fluent.withOrder(instance.getOrder()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SortOptionsBuilder(SortOptions instance) {
    this(instance,false);
  }
  public SortOptionsBuilder(SortOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLegacySortOptions(instance.getLegacySortOptions()); 
    this.withOrder(instance.getOrder()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SortOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SortOptions build() {
    SortOptions buildable = new SortOptions(fluent.getLegacySortOptions(),fluent.getOrder());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}