package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaBuilder extends ReplicaFluentImpl<ReplicaBuilder> implements VisitableBuilder<Replica,ReplicaBuilder>{
  public ReplicaBuilder() {
    this(false);
  }
  public ReplicaBuilder(Boolean validationEnabled) {
    this(new Replica(), validationEnabled);
  }
  public ReplicaBuilder(ReplicaFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaBuilder(ReplicaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Replica(), validationEnabled);
  }
  public ReplicaBuilder(ReplicaFluent<?> fluent,Replica instance) {
    this(fluent, instance, false);
  }
  public ReplicaBuilder(ReplicaFluent<?> fluent,Replica instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCount(instance.getCount()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaBuilder(Replica instance) {
    this(instance,false);
  }
  public ReplicaBuilder(Replica instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCount(instance.getCount()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicaFluent<?> fluent;
  Boolean validationEnabled;
  public Replica build() {
    Replica buildable = new Replica(fluent.getCount(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}