package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KustomizationFluentImpl<A extends KustomizationFluent<A>> extends BaseFluent<A> implements KustomizationFluent<A>{
  public KustomizationFluentImpl() {
  }
  public KustomizationFluentImpl(Kustomization instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withBases(instance.getBases()); 
    this.withBuildMetadata(instance.getBuildMetadata()); 
    this.withCommonAnnotations(instance.getCommonAnnotations()); 
    this.withCommonLabels(instance.getCommonLabels()); 
    this.withComponents(instance.getComponents()); 
    this.withConfigMapGenerator(instance.getConfigMapGenerator()); 
    this.withConfigurations(instance.getConfigurations()); 
    this.withCrds(instance.getCrds()); 
    this.withGeneratorOptions(instance.getGeneratorOptions()); 
    this.withGenerators(instance.getGenerators()); 
    this.withHelmChartInflationGenerator(instance.getHelmChartInflationGenerator()); 
    this.withHelmCharts(instance.getHelmCharts()); 
    this.withHelmGlobals(instance.getHelmGlobals()); 
    this.withImageTags(instance.getImageTags()); 
    this.withImages(instance.getImages()); 
    this.withKind(instance.getKind()); 
    this.withLabels(instance.getLabels()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNamePrefix(instance.getNamePrefix()); 
    this.withNameSuffix(instance.getNameSuffix()); 
    this.withNamespace(instance.getNamespace()); 
    this.withOpenapi(instance.getOpenapi()); 
    this.withPatches(instance.getPatches()); 
    this.withPatchesJson6902(instance.getPatchesJson6902()); 
    this.withPatchesStrategicMerge(instance.getPatchesStrategicMerge()); 
    this.withReplacements(instance.getReplacements()); 
    this.withReplicas(instance.getReplicas()); 
    this.withResources(instance.getResources()); 
    this.withSecretGenerator(instance.getSecretGenerator()); 
    this.withSortOptions(instance.getSortOptions()); 
    this.withTransformers(instance.getTransformers()); 
    this.withValidators(instance.getValidators()); 
    this.withVars(instance.getVars()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<String> bases = new ArrayList<String>();
  private List<String> buildMetadata = new ArrayList<String>();
  private Map<String,String> commonAnnotations;
  private Map<String,String> commonLabels;
  private List<String> components = new ArrayList<String>();
  private ArrayList<ConfigMapArgsBuilder> configMapGenerator = new ArrayList<ConfigMapArgsBuilder>();
  private List<String> configurations = new ArrayList<String>();
  private List<String> crds = new ArrayList<String>();
  private GeneratorOptionsBuilder generatorOptions;
  private List<String> generators = new ArrayList<String>();
  private ArrayList<HelmChartArgsBuilder> helmChartInflationGenerator = new ArrayList<HelmChartArgsBuilder>();
  private ArrayList<HelmChartBuilder> helmCharts = new ArrayList<HelmChartBuilder>();
  private HelmGlobalsBuilder helmGlobals;
  private ArrayList<ImageBuilder> imageTags = new ArrayList<ImageBuilder>();
  private ArrayList<ImageBuilder> images = new ArrayList<ImageBuilder>();
  private String kind;
  private ArrayList<LabelBuilder> labels = new ArrayList<LabelBuilder>();
  private ObjectMetaBuilder metadata;
  private String namePrefix;
  private String nameSuffix;
  private String namespace;
  private Map<String,String> openapi;
  private ArrayList<PatchBuilder> patches = new ArrayList<PatchBuilder>();
  private ArrayList<PatchBuilder> patchesJson6902 = new ArrayList<PatchBuilder>();
  private List<String> patchesStrategicMerge = new ArrayList<String>();
  private ArrayList<ReplacementFieldBuilder> replacements = new ArrayList<ReplacementFieldBuilder>();
  private ArrayList<ReplicaBuilder> replicas = new ArrayList<ReplicaBuilder>();
  private List<String> resources = new ArrayList<String>();
  private ArrayList<SecretArgsBuilder> secretGenerator = new ArrayList<SecretArgsBuilder>();
  private SortOptionsBuilder sortOptions;
  private List<String> transformers = new ArrayList<String>();
  private List<String> validators = new ArrayList<String>();
  private ArrayList<VarBuilder> vars = new ArrayList<VarBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToBases(Integer index,String item) {
    if (this.bases == null) {this.bases = new ArrayList<String>();}
    this.bases.add(index, item);
    return (A)this;
  }
  public A setToBases(Integer index,String item) {
    if (this.bases == null) {this.bases = new ArrayList<String>();}
    this.bases.set(index, item); return (A)this;
  }
  public A addToBases(java.lang.String... items) {
    if (this.bases == null) {this.bases = new ArrayList<String>();}
    for (String item : items) {this.bases.add(item);} return (A)this;
  }
  public A addAllToBases(Collection<String> items) {
    if (this.bases == null) {this.bases = new ArrayList<String>();}
    for (String item : items) {this.bases.add(item);} return (A)this;
  }
  public A removeFromBases(java.lang.String... items) {
    for (String item : items) {if (this.bases!= null){ this.bases.remove(item);}} return (A)this;
  }
  public A removeAllFromBases(Collection<String> items) {
    for (String item : items) {if (this.bases!= null){ this.bases.remove(item);}} return (A)this;
  }
  public List<String> getBases() {
    return this.bases;
  }
  public String getBasis(Integer index) {
    return this.bases.get(index);
  }
  public String getFirstBasis() {
    return this.bases.get(0);
  }
  public String getLastBasis() {
    return this.bases.get(bases.size() - 1);
  }
  public String getMatchingBasis(Predicate<String> predicate) {
    for (String item: bases) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBasis(Predicate<String> predicate) {
    for (String item: bases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBases(List<String> bases) {
    if (bases != null) {this.bases = new ArrayList(); for (String item : bases){this.addToBases(item);}} else { this.bases = null;} return (A) this;
  }
  public A withBases(java.lang.String... bases) {
    if (this.bases != null) {this.bases.clear();}
    if (bases != null) {for (String item :bases){ this.addToBases(item);}} return (A) this;
  }
  public Boolean hasBases() {
    return bases != null && !bases.isEmpty();
  }
  public A addToBuildMetadata(Integer index,String item) {
    if (this.buildMetadata == null) {this.buildMetadata = new ArrayList<String>();}
    this.buildMetadata.add(index, item);
    return (A)this;
  }
  public A setToBuildMetadata(Integer index,String item) {
    if (this.buildMetadata == null) {this.buildMetadata = new ArrayList<String>();}
    this.buildMetadata.set(index, item); return (A)this;
  }
  public A addToBuildMetadata(java.lang.String... items) {
    if (this.buildMetadata == null) {this.buildMetadata = new ArrayList<String>();}
    for (String item : items) {this.buildMetadata.add(item);} return (A)this;
  }
  public A addAllToBuildMetadata(Collection<String> items) {
    if (this.buildMetadata == null) {this.buildMetadata = new ArrayList<String>();}
    for (String item : items) {this.buildMetadata.add(item);} return (A)this;
  }
  public A removeFromBuildMetadata(java.lang.String... items) {
    for (String item : items) {if (this.buildMetadata!= null){ this.buildMetadata.remove(item);}} return (A)this;
  }
  public A removeAllFromBuildMetadata(Collection<String> items) {
    for (String item : items) {if (this.buildMetadata!= null){ this.buildMetadata.remove(item);}} return (A)this;
  }
  public List<String> getBuildMetadata() {
    return this.buildMetadata;
  }
  public String getBuildMetadatum(Integer index) {
    return this.buildMetadata.get(index);
  }
  public String getFirstBuildMetadatum() {
    return this.buildMetadata.get(0);
  }
  public String getLastBuildMetadatum() {
    return this.buildMetadata.get(buildMetadata.size() - 1);
  }
  public String getMatchingBuildMetadatum(Predicate<String> predicate) {
    for (String item: buildMetadata) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBuildMetadatum(Predicate<String> predicate) {
    for (String item: buildMetadata) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBuildMetadata(List<String> buildMetadata) {
    if (buildMetadata != null) {this.buildMetadata = new ArrayList(); for (String item : buildMetadata){this.addToBuildMetadata(item);}} else { this.buildMetadata = null;} return (A) this;
  }
  public A withBuildMetadata(java.lang.String... buildMetadata) {
    if (this.buildMetadata != null) {this.buildMetadata.clear();}
    if (buildMetadata != null) {for (String item :buildMetadata){ this.addToBuildMetadata(item);}} return (A) this;
  }
  public Boolean hasBuildMetadata() {
    return buildMetadata != null && !buildMetadata.isEmpty();
  }
  public A addToCommonAnnotations(String key,String value) {
    if(this.commonAnnotations == null && key != null && value != null) { this.commonAnnotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.commonAnnotations.put(key, value);} return (A)this;
  }
  public A addToCommonAnnotations(Map<String,String> map) {
    if(this.commonAnnotations == null && map != null) { this.commonAnnotations = new LinkedHashMap(); }
    if(map != null) { this.commonAnnotations.putAll(map);} return (A)this;
  }
  public A removeFromCommonAnnotations(String key) {
    if(this.commonAnnotations == null) { return (A) this; }
    if(key != null && this.commonAnnotations != null) {this.commonAnnotations.remove(key);} return (A)this;
  }
  public A removeFromCommonAnnotations(Map<String,String> map) {
    if(this.commonAnnotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.commonAnnotations != null){this.commonAnnotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getCommonAnnotations() {
    return this.commonAnnotations;
  }
  public <K,V>A withCommonAnnotations(Map<String,String> commonAnnotations) {
    if (commonAnnotations == null) { this.commonAnnotations =  null;} else {this.commonAnnotations = new LinkedHashMap(commonAnnotations);} return (A) this;
  }
  public Boolean hasCommonAnnotations() {
    return this.commonAnnotations != null;
  }
  public A addToCommonLabels(String key,String value) {
    if(this.commonLabels == null && key != null && value != null) { this.commonLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.commonLabels.put(key, value);} return (A)this;
  }
  public A addToCommonLabels(Map<String,String> map) {
    if(this.commonLabels == null && map != null) { this.commonLabels = new LinkedHashMap(); }
    if(map != null) { this.commonLabels.putAll(map);} return (A)this;
  }
  public A removeFromCommonLabels(String key) {
    if(this.commonLabels == null) { return (A) this; }
    if(key != null && this.commonLabels != null) {this.commonLabels.remove(key);} return (A)this;
  }
  public A removeFromCommonLabels(Map<String,String> map) {
    if(this.commonLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.commonLabels != null){this.commonLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getCommonLabels() {
    return this.commonLabels;
  }
  public <K,V>A withCommonLabels(Map<String,String> commonLabels) {
    if (commonLabels == null) { this.commonLabels =  null;} else {this.commonLabels = new LinkedHashMap(commonLabels);} return (A) this;
  }
  public Boolean hasCommonLabels() {
    return this.commonLabels != null;
  }
  public A addToComponents(Integer index,String item) {
    if (this.components == null) {this.components = new ArrayList<String>();}
    this.components.add(index, item);
    return (A)this;
  }
  public A setToComponents(Integer index,String item) {
    if (this.components == null) {this.components = new ArrayList<String>();}
    this.components.set(index, item); return (A)this;
  }
  public A addToComponents(java.lang.String... items) {
    if (this.components == null) {this.components = new ArrayList<String>();}
    for (String item : items) {this.components.add(item);} return (A)this;
  }
  public A addAllToComponents(Collection<String> items) {
    if (this.components == null) {this.components = new ArrayList<String>();}
    for (String item : items) {this.components.add(item);} return (A)this;
  }
  public A removeFromComponents(java.lang.String... items) {
    for (String item : items) {if (this.components!= null){ this.components.remove(item);}} return (A)this;
  }
  public A removeAllFromComponents(Collection<String> items) {
    for (String item : items) {if (this.components!= null){ this.components.remove(item);}} return (A)this;
  }
  public List<String> getComponents() {
    return this.components;
  }
  public String getComponent(Integer index) {
    return this.components.get(index);
  }
  public String getFirstComponent() {
    return this.components.get(0);
  }
  public String getLastComponent() {
    return this.components.get(components.size() - 1);
  }
  public String getMatchingComponent(Predicate<String> predicate) {
    for (String item: components) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingComponent(Predicate<String> predicate) {
    for (String item: components) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponents(List<String> components) {
    if (components != null) {this.components = new ArrayList(); for (String item : components){this.addToComponents(item);}} else { this.components = null;} return (A) this;
  }
  public A withComponents(java.lang.String... components) {
    if (this.components != null) {this.components.clear();}
    if (components != null) {for (String item :components){ this.addToComponents(item);}} return (A) this;
  }
  public Boolean hasComponents() {
    return components != null && !components.isEmpty();
  }
  public A addToConfigMapGenerator(Integer index,ConfigMapArgs item) {
    if (this.configMapGenerator == null) {this.configMapGenerator = new ArrayList<ConfigMapArgsBuilder>();}
    ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);_visitables.get("configMapGenerator").add(index >= 0 ? index : _visitables.get("configMapGenerator").size(), builder);this.configMapGenerator.add(index >= 0 ? index : configMapGenerator.size(), builder); return (A)this;
  }
  public A setToConfigMapGenerator(Integer index,ConfigMapArgs item) {
    if (this.configMapGenerator == null) {this.configMapGenerator = new ArrayList<ConfigMapArgsBuilder>();}
    ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);
    if (index < 0 || index >= _visitables.get("configMapGenerator").size()) { _visitables.get("configMapGenerator").add(builder); } else { _visitables.get("configMapGenerator").set(index, builder);}
    if (index < 0 || index >= configMapGenerator.size()) { configMapGenerator.add(builder); } else { configMapGenerator.set(index, builder);}
     return (A)this;
  }
  public A addToConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... items) {
    if (this.configMapGenerator == null) {this.configMapGenerator = new ArrayList<ConfigMapArgsBuilder>();}
    for (ConfigMapArgs item : items) {ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);_visitables.get("configMapGenerator").add(builder);this.configMapGenerator.add(builder);} return (A)this;
  }
  public A addAllToConfigMapGenerator(Collection<ConfigMapArgs> items) {
    if (this.configMapGenerator == null) {this.configMapGenerator = new ArrayList<ConfigMapArgsBuilder>();}
    for (ConfigMapArgs item : items) {ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);_visitables.get("configMapGenerator").add(builder);this.configMapGenerator.add(builder);} return (A)this;
  }
  public A removeFromConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... items) {
    for (ConfigMapArgs item : items) {ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);_visitables.get("configMapGenerator").remove(builder);if (this.configMapGenerator != null) {this.configMapGenerator.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfigMapGenerator(Collection<ConfigMapArgs> items) {
    for (ConfigMapArgs item : items) {ConfigMapArgsBuilder builder = new ConfigMapArgsBuilder(item);_visitables.get("configMapGenerator").remove(builder);if (this.configMapGenerator != null) {this.configMapGenerator.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate) {
    if (configMapGenerator == null) return (A) this;
    final Iterator<ConfigMapArgsBuilder> each = configMapGenerator.iterator();
    final List visitables = _visitables.get("configMapGenerator");
    while (each.hasNext()) {
      ConfigMapArgsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMapGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigMapArgs> getConfigMapGenerator() {
    return configMapGenerator != null ? build(configMapGenerator) : null;
  }
  public List<ConfigMapArgs> buildConfigMapGenerator() {
    return configMapGenerator != null ? build(configMapGenerator) : null;
  }
  public ConfigMapArgs buildConfigMapGenerator(Integer index) {
    return this.configMapGenerator.get(index).build();
  }
  public ConfigMapArgs buildFirstConfigMapGenerator() {
    return this.configMapGenerator.get(0).build();
  }
  public ConfigMapArgs buildLastConfigMapGenerator() {
    return this.configMapGenerator.get(configMapGenerator.size() - 1).build();
  }
  public ConfigMapArgs buildMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate) {
    for (ConfigMapArgsBuilder item: configMapGenerator) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate) {
    for (ConfigMapArgsBuilder item: configMapGenerator) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfigMapGenerator(List<ConfigMapArgs> configMapGenerator) {
    if (this.configMapGenerator != null) { _visitables.get("configMapGenerator").removeAll(this.configMapGenerator);}
    if (configMapGenerator != null) {this.configMapGenerator = new ArrayList(); for (ConfigMapArgs item : configMapGenerator){this.addToConfigMapGenerator(item);}} else { this.configMapGenerator = null;} return (A) this;
  }
  public A withConfigMapGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs... configMapGenerator) {
    if (this.configMapGenerator != null) {this.configMapGenerator.clear();}
    if (configMapGenerator != null) {for (ConfigMapArgs item :configMapGenerator){ this.addToConfigMapGenerator(item);}} return (A) this;
  }
  public Boolean hasConfigMapGenerator() {
    return configMapGenerator != null && !configMapGenerator.isEmpty();
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> addNewConfigMapGenerator() {
    return new KustomizationFluentImpl.ConfigMapGeneratorNestedImpl();
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> addNewConfigMapGeneratorLike(ConfigMapArgs item) {
    return new KustomizationFluentImpl.ConfigMapGeneratorNestedImpl(-1, item);
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> setNewConfigMapGeneratorLike(Integer index,ConfigMapArgs item) {
    return new KustomizationFluentImpl.ConfigMapGeneratorNestedImpl(index, item);
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> editConfigMapGenerator(Integer index) {
    if (configMapGenerator.size() <= index) throw new RuntimeException("Can't edit configMapGenerator. Index exceeds size.");
    return setNewConfigMapGeneratorLike(index, buildConfigMapGenerator(index));
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> editFirstConfigMapGenerator() {
    if (configMapGenerator.size() == 0) throw new RuntimeException("Can't edit first configMapGenerator. The list is empty.");
    return setNewConfigMapGeneratorLike(0, buildConfigMapGenerator(0));
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> editLastConfigMapGenerator() {
    int index = configMapGenerator.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configMapGenerator. The list is empty.");
    return setNewConfigMapGeneratorLike(index, buildConfigMapGenerator(index));
  }
  public KustomizationFluent.ConfigMapGeneratorNested<A> editMatchingConfigMapGenerator(Predicate<ConfigMapArgsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configMapGenerator.size();i++) { 
    if (predicate.test(configMapGenerator.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configMapGenerator. No match found.");
    return setNewConfigMapGeneratorLike(index, buildConfigMapGenerator(index));
  }
  public A addToConfigurations(Integer index,String item) {
    if (this.configurations == null) {this.configurations = new ArrayList<String>();}
    this.configurations.add(index, item);
    return (A)this;
  }
  public A setToConfigurations(Integer index,String item) {
    if (this.configurations == null) {this.configurations = new ArrayList<String>();}
    this.configurations.set(index, item); return (A)this;
  }
  public A addToConfigurations(java.lang.String... items) {
    if (this.configurations == null) {this.configurations = new ArrayList<String>();}
    for (String item : items) {this.configurations.add(item);} return (A)this;
  }
  public A addAllToConfigurations(Collection<String> items) {
    if (this.configurations == null) {this.configurations = new ArrayList<String>();}
    for (String item : items) {this.configurations.add(item);} return (A)this;
  }
  public A removeFromConfigurations(java.lang.String... items) {
    for (String item : items) {if (this.configurations!= null){ this.configurations.remove(item);}} return (A)this;
  }
  public A removeAllFromConfigurations(Collection<String> items) {
    for (String item : items) {if (this.configurations!= null){ this.configurations.remove(item);}} return (A)this;
  }
  public List<String> getConfigurations() {
    return this.configurations;
  }
  public String getConfiguration(Integer index) {
    return this.configurations.get(index);
  }
  public String getFirstConfiguration() {
    return this.configurations.get(0);
  }
  public String getLastConfiguration() {
    return this.configurations.get(configurations.size() - 1);
  }
  public String getMatchingConfiguration(Predicate<String> predicate) {
    for (String item: configurations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<String> predicate) {
    for (String item: configurations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfigurations(List<String> configurations) {
    if (configurations != null) {this.configurations = new ArrayList(); for (String item : configurations){this.addToConfigurations(item);}} else { this.configurations = null;} return (A) this;
  }
  public A withConfigurations(java.lang.String... configurations) {
    if (this.configurations != null) {this.configurations.clear();}
    if (configurations != null) {for (String item :configurations){ this.addToConfigurations(item);}} return (A) this;
  }
  public Boolean hasConfigurations() {
    return configurations != null && !configurations.isEmpty();
  }
  public A addToCrds(Integer index,String item) {
    if (this.crds == null) {this.crds = new ArrayList<String>();}
    this.crds.add(index, item);
    return (A)this;
  }
  public A setToCrds(Integer index,String item) {
    if (this.crds == null) {this.crds = new ArrayList<String>();}
    this.crds.set(index, item); return (A)this;
  }
  public A addToCrds(java.lang.String... items) {
    if (this.crds == null) {this.crds = new ArrayList<String>();}
    for (String item : items) {this.crds.add(item);} return (A)this;
  }
  public A addAllToCrds(Collection<String> items) {
    if (this.crds == null) {this.crds = new ArrayList<String>();}
    for (String item : items) {this.crds.add(item);} return (A)this;
  }
  public A removeFromCrds(java.lang.String... items) {
    for (String item : items) {if (this.crds!= null){ this.crds.remove(item);}} return (A)this;
  }
  public A removeAllFromCrds(Collection<String> items) {
    for (String item : items) {if (this.crds!= null){ this.crds.remove(item);}} return (A)this;
  }
  public List<String> getCrds() {
    return this.crds;
  }
  public String getCrd(Integer index) {
    return this.crds.get(index);
  }
  public String getFirstCrd() {
    return this.crds.get(0);
  }
  public String getLastCrd() {
    return this.crds.get(crds.size() - 1);
  }
  public String getMatchingCrd(Predicate<String> predicate) {
    for (String item: crds) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCrd(Predicate<String> predicate) {
    for (String item: crds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCrds(List<String> crds) {
    if (crds != null) {this.crds = new ArrayList(); for (String item : crds){this.addToCrds(item);}} else { this.crds = null;} return (A) this;
  }
  public A withCrds(java.lang.String... crds) {
    if (this.crds != null) {this.crds.clear();}
    if (crds != null) {for (String item :crds){ this.addToCrds(item);}} return (A) this;
  }
  public Boolean hasCrds() {
    return crds != null && !crds.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildGeneratorOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public GeneratorOptions getGeneratorOptions() {
    return this.generatorOptions!=null ?this.generatorOptions.build():null;
  }
  public GeneratorOptions buildGeneratorOptions() {
    return this.generatorOptions!=null ?this.generatorOptions.build():null;
  }
  public A withGeneratorOptions(GeneratorOptions generatorOptions) {
    _visitables.get("generatorOptions").remove(this.generatorOptions);
    if (generatorOptions!=null){ this.generatorOptions= new GeneratorOptionsBuilder(generatorOptions); _visitables.get("generatorOptions").add(this.generatorOptions);} else { this.generatorOptions = null; _visitables.get("generatorOptions").remove(this.generatorOptions); } return (A) this;
  }
  public Boolean hasGeneratorOptions() {
    return this.generatorOptions != null;
  }
  public KustomizationFluent.GeneratorOptionsNested<A> withNewGeneratorOptions() {
    return new KustomizationFluentImpl.GeneratorOptionsNestedImpl();
  }
  public KustomizationFluent.GeneratorOptionsNested<A> withNewGeneratorOptionsLike(GeneratorOptions item) {
    return new KustomizationFluentImpl.GeneratorOptionsNestedImpl(item);
  }
  public KustomizationFluent.GeneratorOptionsNested<A> editGeneratorOptions() {
    return withNewGeneratorOptionsLike(getGeneratorOptions());
  }
  public KustomizationFluent.GeneratorOptionsNested<A> editOrNewGeneratorOptions() {
    return withNewGeneratorOptionsLike(getGeneratorOptions() != null ? getGeneratorOptions(): new GeneratorOptionsBuilder().build());
  }
  public KustomizationFluent.GeneratorOptionsNested<A> editOrNewGeneratorOptionsLike(GeneratorOptions item) {
    return withNewGeneratorOptionsLike(getGeneratorOptions() != null ? getGeneratorOptions(): item);
  }
  public A addToGenerators(Integer index,String item) {
    if (this.generators == null) {this.generators = new ArrayList<String>();}
    this.generators.add(index, item);
    return (A)this;
  }
  public A setToGenerators(Integer index,String item) {
    if (this.generators == null) {this.generators = new ArrayList<String>();}
    this.generators.set(index, item); return (A)this;
  }
  public A addToGenerators(java.lang.String... items) {
    if (this.generators == null) {this.generators = new ArrayList<String>();}
    for (String item : items) {this.generators.add(item);} return (A)this;
  }
  public A addAllToGenerators(Collection<String> items) {
    if (this.generators == null) {this.generators = new ArrayList<String>();}
    for (String item : items) {this.generators.add(item);} return (A)this;
  }
  public A removeFromGenerators(java.lang.String... items) {
    for (String item : items) {if (this.generators!= null){ this.generators.remove(item);}} return (A)this;
  }
  public A removeAllFromGenerators(Collection<String> items) {
    for (String item : items) {if (this.generators!= null){ this.generators.remove(item);}} return (A)this;
  }
  public List<String> getGenerators() {
    return this.generators;
  }
  public String getGenerator(Integer index) {
    return this.generators.get(index);
  }
  public String getFirstGenerator() {
    return this.generators.get(0);
  }
  public String getLastGenerator() {
    return this.generators.get(generators.size() - 1);
  }
  public String getMatchingGenerator(Predicate<String> predicate) {
    for (String item: generators) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGenerator(Predicate<String> predicate) {
    for (String item: generators) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerators(List<String> generators) {
    if (generators != null) {this.generators = new ArrayList(); for (String item : generators){this.addToGenerators(item);}} else { this.generators = null;} return (A) this;
  }
  public A withGenerators(java.lang.String... generators) {
    if (this.generators != null) {this.generators.clear();}
    if (generators != null) {for (String item :generators){ this.addToGenerators(item);}} return (A) this;
  }
  public Boolean hasGenerators() {
    return generators != null && !generators.isEmpty();
  }
  public A addToHelmChartInflationGenerator(Integer index,HelmChartArgs item) {
    if (this.helmChartInflationGenerator == null) {this.helmChartInflationGenerator = new ArrayList<HelmChartArgsBuilder>();}
    HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);_visitables.get("helmChartInflationGenerator").add(index >= 0 ? index : _visitables.get("helmChartInflationGenerator").size(), builder);this.helmChartInflationGenerator.add(index >= 0 ? index : helmChartInflationGenerator.size(), builder); return (A)this;
  }
  public A setToHelmChartInflationGenerator(Integer index,HelmChartArgs item) {
    if (this.helmChartInflationGenerator == null) {this.helmChartInflationGenerator = new ArrayList<HelmChartArgsBuilder>();}
    HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);
    if (index < 0 || index >= _visitables.get("helmChartInflationGenerator").size()) { _visitables.get("helmChartInflationGenerator").add(builder); } else { _visitables.get("helmChartInflationGenerator").set(index, builder);}
    if (index < 0 || index >= helmChartInflationGenerator.size()) { helmChartInflationGenerator.add(builder); } else { helmChartInflationGenerator.set(index, builder);}
     return (A)this;
  }
  public A addToHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... items) {
    if (this.helmChartInflationGenerator == null) {this.helmChartInflationGenerator = new ArrayList<HelmChartArgsBuilder>();}
    for (HelmChartArgs item : items) {HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);_visitables.get("helmChartInflationGenerator").add(builder);this.helmChartInflationGenerator.add(builder);} return (A)this;
  }
  public A addAllToHelmChartInflationGenerator(Collection<HelmChartArgs> items) {
    if (this.helmChartInflationGenerator == null) {this.helmChartInflationGenerator = new ArrayList<HelmChartArgsBuilder>();}
    for (HelmChartArgs item : items) {HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);_visitables.get("helmChartInflationGenerator").add(builder);this.helmChartInflationGenerator.add(builder);} return (A)this;
  }
  public A removeFromHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... items) {
    for (HelmChartArgs item : items) {HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);_visitables.get("helmChartInflationGenerator").remove(builder);if (this.helmChartInflationGenerator != null) {this.helmChartInflationGenerator.remove(builder);}} return (A)this;
  }
  public A removeAllFromHelmChartInflationGenerator(Collection<HelmChartArgs> items) {
    for (HelmChartArgs item : items) {HelmChartArgsBuilder builder = new HelmChartArgsBuilder(item);_visitables.get("helmChartInflationGenerator").remove(builder);if (this.helmChartInflationGenerator != null) {this.helmChartInflationGenerator.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate) {
    if (helmChartInflationGenerator == null) return (A) this;
    final Iterator<HelmChartArgsBuilder> each = helmChartInflationGenerator.iterator();
    final List visitables = _visitables.get("helmChartInflationGenerator");
    while (each.hasNext()) {
      HelmChartArgsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHelmChartInflationGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HelmChartArgs> getHelmChartInflationGenerator() {
    return helmChartInflationGenerator != null ? build(helmChartInflationGenerator) : null;
  }
  public List<HelmChartArgs> buildHelmChartInflationGenerator() {
    return helmChartInflationGenerator != null ? build(helmChartInflationGenerator) : null;
  }
  public HelmChartArgs buildHelmChartInflationGenerator(Integer index) {
    return this.helmChartInflationGenerator.get(index).build();
  }
  public HelmChartArgs buildFirstHelmChartInflationGenerator() {
    return this.helmChartInflationGenerator.get(0).build();
  }
  public HelmChartArgs buildLastHelmChartInflationGenerator() {
    return this.helmChartInflationGenerator.get(helmChartInflationGenerator.size() - 1).build();
  }
  public HelmChartArgs buildMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate) {
    for (HelmChartArgsBuilder item: helmChartInflationGenerator) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate) {
    for (HelmChartArgsBuilder item: helmChartInflationGenerator) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHelmChartInflationGenerator(List<HelmChartArgs> helmChartInflationGenerator) {
    if (this.helmChartInflationGenerator != null) { _visitables.get("helmChartInflationGenerator").removeAll(this.helmChartInflationGenerator);}
    if (helmChartInflationGenerator != null) {this.helmChartInflationGenerator = new ArrayList(); for (HelmChartArgs item : helmChartInflationGenerator){this.addToHelmChartInflationGenerator(item);}} else { this.helmChartInflationGenerator = null;} return (A) this;
  }
  public A withHelmChartInflationGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChartArgs... helmChartInflationGenerator) {
    if (this.helmChartInflationGenerator != null) {this.helmChartInflationGenerator.clear();}
    if (helmChartInflationGenerator != null) {for (HelmChartArgs item :helmChartInflationGenerator){ this.addToHelmChartInflationGenerator(item);}} return (A) this;
  }
  public Boolean hasHelmChartInflationGenerator() {
    return helmChartInflationGenerator != null && !helmChartInflationGenerator.isEmpty();
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> addNewHelmChartInflationGenerator() {
    return new KustomizationFluentImpl.HelmChartInflationGeneratorNestedImpl();
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> addNewHelmChartInflationGeneratorLike(HelmChartArgs item) {
    return new KustomizationFluentImpl.HelmChartInflationGeneratorNestedImpl(-1, item);
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> setNewHelmChartInflationGeneratorLike(Integer index,HelmChartArgs item) {
    return new KustomizationFluentImpl.HelmChartInflationGeneratorNestedImpl(index, item);
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editHelmChartInflationGenerator(Integer index) {
    if (helmChartInflationGenerator.size() <= index) throw new RuntimeException("Can't edit helmChartInflationGenerator. Index exceeds size.");
    return setNewHelmChartInflationGeneratorLike(index, buildHelmChartInflationGenerator(index));
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editFirstHelmChartInflationGenerator() {
    if (helmChartInflationGenerator.size() == 0) throw new RuntimeException("Can't edit first helmChartInflationGenerator. The list is empty.");
    return setNewHelmChartInflationGeneratorLike(0, buildHelmChartInflationGenerator(0));
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editLastHelmChartInflationGenerator() {
    int index = helmChartInflationGenerator.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last helmChartInflationGenerator. The list is empty.");
    return setNewHelmChartInflationGeneratorLike(index, buildHelmChartInflationGenerator(index));
  }
  public KustomizationFluent.HelmChartInflationGeneratorNested<A> editMatchingHelmChartInflationGenerator(Predicate<HelmChartArgsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<helmChartInflationGenerator.size();i++) { 
    if (predicate.test(helmChartInflationGenerator.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching helmChartInflationGenerator. No match found.");
    return setNewHelmChartInflationGeneratorLike(index, buildHelmChartInflationGenerator(index));
  }
  public A addToHelmCharts(Integer index,HelmChart item) {
    if (this.helmCharts == null) {this.helmCharts = new ArrayList<HelmChartBuilder>();}
    HelmChartBuilder builder = new HelmChartBuilder(item);_visitables.get("helmCharts").add(index >= 0 ? index : _visitables.get("helmCharts").size(), builder);this.helmCharts.add(index >= 0 ? index : helmCharts.size(), builder); return (A)this;
  }
  public A setToHelmCharts(Integer index,HelmChart item) {
    if (this.helmCharts == null) {this.helmCharts = new ArrayList<HelmChartBuilder>();}
    HelmChartBuilder builder = new HelmChartBuilder(item);
    if (index < 0 || index >= _visitables.get("helmCharts").size()) { _visitables.get("helmCharts").add(builder); } else { _visitables.get("helmCharts").set(index, builder);}
    if (index < 0 || index >= helmCharts.size()) { helmCharts.add(builder); } else { helmCharts.set(index, builder);}
     return (A)this;
  }
  public A addToHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... items) {
    if (this.helmCharts == null) {this.helmCharts = new ArrayList<HelmChartBuilder>();}
    for (HelmChart item : items) {HelmChartBuilder builder = new HelmChartBuilder(item);_visitables.get("helmCharts").add(builder);this.helmCharts.add(builder);} return (A)this;
  }
  public A addAllToHelmCharts(Collection<HelmChart> items) {
    if (this.helmCharts == null) {this.helmCharts = new ArrayList<HelmChartBuilder>();}
    for (HelmChart item : items) {HelmChartBuilder builder = new HelmChartBuilder(item);_visitables.get("helmCharts").add(builder);this.helmCharts.add(builder);} return (A)this;
  }
  public A removeFromHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... items) {
    for (HelmChart item : items) {HelmChartBuilder builder = new HelmChartBuilder(item);_visitables.get("helmCharts").remove(builder);if (this.helmCharts != null) {this.helmCharts.remove(builder);}} return (A)this;
  }
  public A removeAllFromHelmCharts(Collection<HelmChart> items) {
    for (HelmChart item : items) {HelmChartBuilder builder = new HelmChartBuilder(item);_visitables.get("helmCharts").remove(builder);if (this.helmCharts != null) {this.helmCharts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHelmCharts(Predicate<HelmChartBuilder> predicate) {
    if (helmCharts == null) return (A) this;
    final Iterator<HelmChartBuilder> each = helmCharts.iterator();
    final List visitables = _visitables.get("helmCharts");
    while (each.hasNext()) {
      HelmChartBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHelmCharts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HelmChart> getHelmCharts() {
    return helmCharts != null ? build(helmCharts) : null;
  }
  public List<HelmChart> buildHelmCharts() {
    return helmCharts != null ? build(helmCharts) : null;
  }
  public HelmChart buildHelmChart(Integer index) {
    return this.helmCharts.get(index).build();
  }
  public HelmChart buildFirstHelmChart() {
    return this.helmCharts.get(0).build();
  }
  public HelmChart buildLastHelmChart() {
    return this.helmCharts.get(helmCharts.size() - 1).build();
  }
  public HelmChart buildMatchingHelmChart(Predicate<HelmChartBuilder> predicate) {
    for (HelmChartBuilder item: helmCharts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHelmChart(Predicate<HelmChartBuilder> predicate) {
    for (HelmChartBuilder item: helmCharts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHelmCharts(List<HelmChart> helmCharts) {
    if (this.helmCharts != null) { _visitables.get("helmCharts").removeAll(this.helmCharts);}
    if (helmCharts != null) {this.helmCharts = new ArrayList(); for (HelmChart item : helmCharts){this.addToHelmCharts(item);}} else { this.helmCharts = null;} return (A) this;
  }
  public A withHelmCharts(io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart... helmCharts) {
    if (this.helmCharts != null) {this.helmCharts.clear();}
    if (helmCharts != null) {for (HelmChart item :helmCharts){ this.addToHelmCharts(item);}} return (A) this;
  }
  public Boolean hasHelmCharts() {
    return helmCharts != null && !helmCharts.isEmpty();
  }
  public KustomizationFluent.HelmChartsNested<A> addNewHelmChart() {
    return new KustomizationFluentImpl.HelmChartsNestedImpl();
  }
  public KustomizationFluent.HelmChartsNested<A> addNewHelmChartLike(HelmChart item) {
    return new KustomizationFluentImpl.HelmChartsNestedImpl(-1, item);
  }
  public KustomizationFluent.HelmChartsNested<A> setNewHelmChartLike(Integer index,HelmChart item) {
    return new KustomizationFluentImpl.HelmChartsNestedImpl(index, item);
  }
  public KustomizationFluent.HelmChartsNested<A> editHelmChart(Integer index) {
    if (helmCharts.size() <= index) throw new RuntimeException("Can't edit helmCharts. Index exceeds size.");
    return setNewHelmChartLike(index, buildHelmChart(index));
  }
  public KustomizationFluent.HelmChartsNested<A> editFirstHelmChart() {
    if (helmCharts.size() == 0) throw new RuntimeException("Can't edit first helmCharts. The list is empty.");
    return setNewHelmChartLike(0, buildHelmChart(0));
  }
  public KustomizationFluent.HelmChartsNested<A> editLastHelmChart() {
    int index = helmCharts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last helmCharts. The list is empty.");
    return setNewHelmChartLike(index, buildHelmChart(index));
  }
  public KustomizationFluent.HelmChartsNested<A> editMatchingHelmChart(Predicate<HelmChartBuilder> predicate) {
    int index = -1;
    for (int i=0;i<helmCharts.size();i++) { 
    if (predicate.test(helmCharts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching helmCharts. No match found.");
    return setNewHelmChartLike(index, buildHelmChart(index));
  }
  
  /**
   * This method has been deprecated, please use method buildHelmGlobals instead.
   * @return The buildable object.
   */
  @Deprecated
  public HelmGlobals getHelmGlobals() {
    return this.helmGlobals!=null ?this.helmGlobals.build():null;
  }
  public HelmGlobals buildHelmGlobals() {
    return this.helmGlobals!=null ?this.helmGlobals.build():null;
  }
  public A withHelmGlobals(HelmGlobals helmGlobals) {
    _visitables.get("helmGlobals").remove(this.helmGlobals);
    if (helmGlobals!=null){ this.helmGlobals= new HelmGlobalsBuilder(helmGlobals); _visitables.get("helmGlobals").add(this.helmGlobals);} else { this.helmGlobals = null; _visitables.get("helmGlobals").remove(this.helmGlobals); } return (A) this;
  }
  public Boolean hasHelmGlobals() {
    return this.helmGlobals != null;
  }
  public A withNewHelmGlobals(String chartHome,String configHome) {
    return (A)withHelmGlobals(new HelmGlobals(chartHome, configHome));
  }
  public KustomizationFluent.HelmGlobalsNested<A> withNewHelmGlobals() {
    return new KustomizationFluentImpl.HelmGlobalsNestedImpl();
  }
  public KustomizationFluent.HelmGlobalsNested<A> withNewHelmGlobalsLike(HelmGlobals item) {
    return new KustomizationFluentImpl.HelmGlobalsNestedImpl(item);
  }
  public KustomizationFluent.HelmGlobalsNested<A> editHelmGlobals() {
    return withNewHelmGlobalsLike(getHelmGlobals());
  }
  public KustomizationFluent.HelmGlobalsNested<A> editOrNewHelmGlobals() {
    return withNewHelmGlobalsLike(getHelmGlobals() != null ? getHelmGlobals(): new HelmGlobalsBuilder().build());
  }
  public KustomizationFluent.HelmGlobalsNested<A> editOrNewHelmGlobalsLike(HelmGlobals item) {
    return withNewHelmGlobalsLike(getHelmGlobals() != null ? getHelmGlobals(): item);
  }
  public A addToImageTags(Integer index,Image item) {
    if (this.imageTags == null) {this.imageTags = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);_visitables.get("imageTags").add(index >= 0 ? index : _visitables.get("imageTags").size(), builder);this.imageTags.add(index >= 0 ? index : imageTags.size(), builder); return (A)this;
  }
  public A setToImageTags(Integer index,Image item) {
    if (this.imageTags == null) {this.imageTags = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= _visitables.get("imageTags").size()) { _visitables.get("imageTags").add(builder); } else { _visitables.get("imageTags").set(index, builder);}
    if (index < 0 || index >= imageTags.size()) { imageTags.add(builder); } else { imageTags.set(index, builder);}
     return (A)this;
  }
  public A addToImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items) {
    if (this.imageTags == null) {this.imageTags = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("imageTags").add(builder);this.imageTags.add(builder);} return (A)this;
  }
  public A addAllToImageTags(Collection<Image> items) {
    if (this.imageTags == null) {this.imageTags = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("imageTags").add(builder);this.imageTags.add(builder);} return (A)this;
  }
  public A removeFromImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("imageTags").remove(builder);if (this.imageTags != null) {this.imageTags.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageTags(Collection<Image> items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("imageTags").remove(builder);if (this.imageTags != null) {this.imageTags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageTags(Predicate<ImageBuilder> predicate) {
    if (imageTags == null) return (A) this;
    final Iterator<ImageBuilder> each = imageTags.iterator();
    final List visitables = _visitables.get("imageTags");
    while (each.hasNext()) {
      ImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Image> getImageTags() {
    return imageTags != null ? build(imageTags) : null;
  }
  public List<Image> buildImageTags() {
    return imageTags != null ? build(imageTags) : null;
  }
  public Image buildImageTag(Integer index) {
    return this.imageTags.get(index).build();
  }
  public Image buildFirstImageTag() {
    return this.imageTags.get(0).build();
  }
  public Image buildLastImageTag() {
    return this.imageTags.get(imageTags.size() - 1).build();
  }
  public Image buildMatchingImageTag(Predicate<ImageBuilder> predicate) {
    for (ImageBuilder item: imageTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageTag(Predicate<ImageBuilder> predicate) {
    for (ImageBuilder item: imageTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageTags(List<Image> imageTags) {
    if (this.imageTags != null) { _visitables.get("imageTags").removeAll(this.imageTags);}
    if (imageTags != null) {this.imageTags = new ArrayList(); for (Image item : imageTags){this.addToImageTags(item);}} else { this.imageTags = null;} return (A) this;
  }
  public A withImageTags(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... imageTags) {
    if (this.imageTags != null) {this.imageTags.clear();}
    if (imageTags != null) {for (Image item :imageTags){ this.addToImageTags(item);}} return (A) this;
  }
  public Boolean hasImageTags() {
    return imageTags != null && !imageTags.isEmpty();
  }
  public A addNewImageTag(String digest,String name,String newName,String newTag,String tagSuffix) {
    return (A)addToImageTags(new Image(digest, name, newName, newTag, tagSuffix));
  }
  public KustomizationFluent.ImageTagsNested<A> addNewImageTag() {
    return new KustomizationFluentImpl.ImageTagsNestedImpl();
  }
  public KustomizationFluent.ImageTagsNested<A> addNewImageTagLike(Image item) {
    return new KustomizationFluentImpl.ImageTagsNestedImpl(-1, item);
  }
  public KustomizationFluent.ImageTagsNested<A> setNewImageTagLike(Integer index,Image item) {
    return new KustomizationFluentImpl.ImageTagsNestedImpl(index, item);
  }
  public KustomizationFluent.ImageTagsNested<A> editImageTag(Integer index) {
    if (imageTags.size() <= index) throw new RuntimeException("Can't edit imageTags. Index exceeds size.");
    return setNewImageTagLike(index, buildImageTag(index));
  }
  public KustomizationFluent.ImageTagsNested<A> editFirstImageTag() {
    if (imageTags.size() == 0) throw new RuntimeException("Can't edit first imageTags. The list is empty.");
    return setNewImageTagLike(0, buildImageTag(0));
  }
  public KustomizationFluent.ImageTagsNested<A> editLastImageTag() {
    int index = imageTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageTags. The list is empty.");
    return setNewImageTagLike(index, buildImageTag(index));
  }
  public KustomizationFluent.ImageTagsNested<A> editMatchingImageTag(Predicate<ImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageTags.size();i++) { 
    if (predicate.test(imageTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageTags. No match found.");
    return setNewImageTagLike(index, buildImageTag(index));
  }
  public A addToImages(Integer index,Image item) {
    if (this.images == null) {this.images = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(Integer index,Image item) {
    if (this.images == null) {this.images = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items) {
    if (this.images == null) {this.images = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<Image> items) {
    if (this.images == null) {this.images = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(Collection<Image> items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<ImageBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Image> getImages() {
    return images != null ? build(images) : null;
  }
  public List<Image> buildImages() {
    return images != null ? build(images) : null;
  }
  public Image buildImage(Integer index) {
    return this.images.get(index).build();
  }
  public Image buildFirstImage() {
    return this.images.get(0).build();
  }
  public Image buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public Image buildMatchingImage(Predicate<ImageBuilder> predicate) {
    for (ImageBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImage(Predicate<ImageBuilder> predicate) {
    for (ImageBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(List<Image> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new ArrayList(); for (Image item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Image... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (Image item :images){ this.addToImages(item);}} return (A) this;
  }
  public Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public A addNewImage(String digest,String name,String newName,String newTag,String tagSuffix) {
    return (A)addToImages(new Image(digest, name, newName, newTag, tagSuffix));
  }
  public KustomizationFluent.ImagesNested<A> addNewImage() {
    return new KustomizationFluentImpl.ImagesNestedImpl();
  }
  public KustomizationFluent.ImagesNested<A> addNewImageLike(Image item) {
    return new KustomizationFluentImpl.ImagesNestedImpl(-1, item);
  }
  public KustomizationFluent.ImagesNested<A> setNewImageLike(Integer index,Image item) {
    return new KustomizationFluentImpl.ImagesNestedImpl(index, item);
  }
  public KustomizationFluent.ImagesNested<A> editImage(Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public KustomizationFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public KustomizationFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public KustomizationFluent.ImagesNested<A> editMatchingImage(Predicate<ImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public A addToLabels(Integer index,Label item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").add(index >= 0 ? index : _visitables.get("labels").size(), builder);this.labels.add(index >= 0 ? index : labels.size(), builder); return (A)this;
  }
  public A setToLabels(Integer index,Label item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);
    if (index < 0 || index >= _visitables.get("labels").size()) { _visitables.get("labels").add(builder); } else { _visitables.get("labels").set(index, builder);}
    if (index < 0 || index >= labels.size()) { labels.add(builder); } else { labels.set(index, builder);}
     return (A)this;
  }
  public A addToLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A addAllToLabels(Collection<Label> items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A removeFromLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... items) {
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeAllFromLabels(Collection<Label> items) {
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate) {
    if (labels == null) return (A) this;
    final Iterator<LabelBuilder> each = labels.iterator();
    final List visitables = _visitables.get("labels");
    while (each.hasNext()) {
      LabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Label> getLabels() {
    return labels != null ? build(labels) : null;
  }
  public List<Label> buildLabels() {
    return labels != null ? build(labels) : null;
  }
  public Label buildLabel(Integer index) {
    return this.labels.get(index).build();
  }
  public Label buildFirstLabel() {
    return this.labels.get(0).build();
  }
  public Label buildLastLabel() {
    return this.labels.get(labels.size() - 1).build();
  }
  public Label buildMatchingLabel(Predicate<LabelBuilder> predicate) {
    for (LabelBuilder item: labels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLabel(Predicate<LabelBuilder> predicate) {
    for (LabelBuilder item: labels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLabels(List<Label> labels) {
    if (this.labels != null) { _visitables.get("labels").removeAll(this.labels);}
    if (labels != null) {this.labels = new ArrayList(); for (Label item : labels){this.addToLabels(item);}} else { this.labels = null;} return (A) this;
  }
  public A withLabels(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Label... labels) {
    if (this.labels != null) {this.labels.clear();}
    if (labels != null) {for (Label item :labels){ this.addToLabels(item);}} return (A) this;
  }
  public Boolean hasLabels() {
    return labels != null && !labels.isEmpty();
  }
  public KustomizationFluent.LabelsNested<A> addNewLabel() {
    return new KustomizationFluentImpl.LabelsNestedImpl();
  }
  public KustomizationFluent.LabelsNested<A> addNewLabelLike(Label item) {
    return new KustomizationFluentImpl.LabelsNestedImpl(-1, item);
  }
  public KustomizationFluent.LabelsNested<A> setNewLabelLike(Integer index,Label item) {
    return new KustomizationFluentImpl.LabelsNestedImpl(index, item);
  }
  public KustomizationFluent.LabelsNested<A> editLabel(Integer index) {
    if (labels.size() <= index) throw new RuntimeException("Can't edit labels. Index exceeds size.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public KustomizationFluent.LabelsNested<A> editFirstLabel() {
    if (labels.size() == 0) throw new RuntimeException("Can't edit first labels. The list is empty.");
    return setNewLabelLike(0, buildLabel(0));
  }
  public KustomizationFluent.LabelsNested<A> editLastLabel() {
    int index = labels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last labels. The list is empty.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public KustomizationFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<labels.size();i++) { 
    if (predicate.test(labels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching labels. No match found.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public KustomizationFluent.MetadataNested<A> withNewMetadata() {
    return new KustomizationFluentImpl.MetadataNestedImpl();
  }
  public KustomizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new KustomizationFluentImpl.MetadataNestedImpl(item);
  }
  public KustomizationFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public KustomizationFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public KustomizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getNamePrefix() {
    return this.namePrefix;
  }
  public A withNamePrefix(String namePrefix) {
    this.namePrefix=namePrefix; return (A) this;
  }
  public Boolean hasNamePrefix() {
    return this.namePrefix != null;
  }
  public String getNameSuffix() {
    return this.nameSuffix;
  }
  public A withNameSuffix(String nameSuffix) {
    this.nameSuffix=nameSuffix; return (A) this;
  }
  public Boolean hasNameSuffix() {
    return this.nameSuffix != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public A addToOpenapi(String key,String value) {
    if(this.openapi == null && key != null && value != null) { this.openapi = new LinkedHashMap(); }
    if(key != null && value != null) {this.openapi.put(key, value);} return (A)this;
  }
  public A addToOpenapi(Map<String,String> map) {
    if(this.openapi == null && map != null) { this.openapi = new LinkedHashMap(); }
    if(map != null) { this.openapi.putAll(map);} return (A)this;
  }
  public A removeFromOpenapi(String key) {
    if(this.openapi == null) { return (A) this; }
    if(key != null && this.openapi != null) {this.openapi.remove(key);} return (A)this;
  }
  public A removeFromOpenapi(Map<String,String> map) {
    if(this.openapi == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.openapi != null){this.openapi.remove(key);}}} return (A)this;
  }
  public Map<String,String> getOpenapi() {
    return this.openapi;
  }
  public <K,V>A withOpenapi(Map<String,String> openapi) {
    if (openapi == null) { this.openapi =  null;} else {this.openapi = new LinkedHashMap(openapi);} return (A) this;
  }
  public Boolean hasOpenapi() {
    return this.openapi != null;
  }
  public A addToPatches(Integer index,Patch item) {
    if (this.patches == null) {this.patches = new ArrayList<PatchBuilder>();}
    PatchBuilder builder = new PatchBuilder(item);_visitables.get("patches").add(index >= 0 ? index : _visitables.get("patches").size(), builder);this.patches.add(index >= 0 ? index : patches.size(), builder); return (A)this;
  }
  public A setToPatches(Integer index,Patch item) {
    if (this.patches == null) {this.patches = new ArrayList<PatchBuilder>();}
    PatchBuilder builder = new PatchBuilder(item);
    if (index < 0 || index >= _visitables.get("patches").size()) { _visitables.get("patches").add(builder); } else { _visitables.get("patches").set(index, builder);}
    if (index < 0 || index >= patches.size()) { patches.add(builder); } else { patches.set(index, builder);}
     return (A)this;
  }
  public A addToPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items) {
    if (this.patches == null) {this.patches = new ArrayList<PatchBuilder>();}
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  public A addAllToPatches(Collection<Patch> items) {
    if (this.patches == null) {this.patches = new ArrayList<PatchBuilder>();}
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  public A removeFromPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items) {
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patches").remove(builder);if (this.patches != null) {this.patches.remove(builder);}} return (A)this;
  }
  public A removeAllFromPatches(Collection<Patch> items) {
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patches").remove(builder);if (this.patches != null) {this.patches.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPatches(Predicate<PatchBuilder> predicate) {
    if (patches == null) return (A) this;
    final Iterator<PatchBuilder> each = patches.iterator();
    final List visitables = _visitables.get("patches");
    while (each.hasNext()) {
      PatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPatches instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Patch> getPatches() {
    return patches != null ? build(patches) : null;
  }
  public List<Patch> buildPatches() {
    return patches != null ? build(patches) : null;
  }
  public Patch buildPatch(Integer index) {
    return this.patches.get(index).build();
  }
  public Patch buildFirstPatch() {
    return this.patches.get(0).build();
  }
  public Patch buildLastPatch() {
    return this.patches.get(patches.size() - 1).build();
  }
  public Patch buildMatchingPatch(Predicate<PatchBuilder> predicate) {
    for (PatchBuilder item: patches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPatch(Predicate<PatchBuilder> predicate) {
    for (PatchBuilder item: patches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatches(List<Patch> patches) {
    if (this.patches != null) { _visitables.get("patches").removeAll(this.patches);}
    if (patches != null) {this.patches = new ArrayList(); for (Patch item : patches){this.addToPatches(item);}} else { this.patches = null;} return (A) this;
  }
  public A withPatches(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... patches) {
    if (this.patches != null) {this.patches.clear();}
    if (patches != null) {for (Patch item :patches){ this.addToPatches(item);}} return (A) this;
  }
  public Boolean hasPatches() {
    return patches != null && !patches.isEmpty();
  }
  public KustomizationFluent.PatchesNested<A> addNewPatch() {
    return new KustomizationFluentImpl.PatchesNestedImpl();
  }
  public KustomizationFluent.PatchesNested<A> addNewPatchLike(Patch item) {
    return new KustomizationFluentImpl.PatchesNestedImpl(-1, item);
  }
  public KustomizationFluent.PatchesNested<A> setNewPatchLike(Integer index,Patch item) {
    return new KustomizationFluentImpl.PatchesNestedImpl(index, item);
  }
  public KustomizationFluent.PatchesNested<A> editPatch(Integer index) {
    if (patches.size() <= index) throw new RuntimeException("Can't edit patches. Index exceeds size.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public KustomizationFluent.PatchesNested<A> editFirstPatch() {
    if (patches.size() == 0) throw new RuntimeException("Can't edit first patches. The list is empty.");
    return setNewPatchLike(0, buildPatch(0));
  }
  public KustomizationFluent.PatchesNested<A> editLastPatch() {
    int index = patches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last patches. The list is empty.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public KustomizationFluent.PatchesNested<A> editMatchingPatch(Predicate<PatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<patches.size();i++) { 
    if (predicate.test(patches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching patches. No match found.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public A addToPatchesJson6902(Integer index,Patch item) {
    if (this.patchesJson6902 == null) {this.patchesJson6902 = new ArrayList<PatchBuilder>();}
    PatchBuilder builder = new PatchBuilder(item);_visitables.get("patchesJson6902").add(index >= 0 ? index : _visitables.get("patchesJson6902").size(), builder);this.patchesJson6902.add(index >= 0 ? index : patchesJson6902.size(), builder); return (A)this;
  }
  public A setToPatchesJson6902(Integer index,Patch item) {
    if (this.patchesJson6902 == null) {this.patchesJson6902 = new ArrayList<PatchBuilder>();}
    PatchBuilder builder = new PatchBuilder(item);
    if (index < 0 || index >= _visitables.get("patchesJson6902").size()) { _visitables.get("patchesJson6902").add(builder); } else { _visitables.get("patchesJson6902").set(index, builder);}
    if (index < 0 || index >= patchesJson6902.size()) { patchesJson6902.add(builder); } else { patchesJson6902.set(index, builder);}
     return (A)this;
  }
  public A addToPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items) {
    if (this.patchesJson6902 == null) {this.patchesJson6902 = new ArrayList<PatchBuilder>();}
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patchesJson6902").add(builder);this.patchesJson6902.add(builder);} return (A)this;
  }
  public A addAllToPatchesJson6902(Collection<Patch> items) {
    if (this.patchesJson6902 == null) {this.patchesJson6902 = new ArrayList<PatchBuilder>();}
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patchesJson6902").add(builder);this.patchesJson6902.add(builder);} return (A)this;
  }
  public A removeFromPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... items) {
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patchesJson6902").remove(builder);if (this.patchesJson6902 != null) {this.patchesJson6902.remove(builder);}} return (A)this;
  }
  public A removeAllFromPatchesJson6902(Collection<Patch> items) {
    for (Patch item : items) {PatchBuilder builder = new PatchBuilder(item);_visitables.get("patchesJson6902").remove(builder);if (this.patchesJson6902 != null) {this.patchesJson6902.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPatchesJson6902(Predicate<PatchBuilder> predicate) {
    if (patchesJson6902 == null) return (A) this;
    final Iterator<PatchBuilder> each = patchesJson6902.iterator();
    final List visitables = _visitables.get("patchesJson6902");
    while (each.hasNext()) {
      PatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPatchesJson6902 instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Patch> getPatchesJson6902() {
    return patchesJson6902 != null ? build(patchesJson6902) : null;
  }
  public List<Patch> buildPatchesJson6902() {
    return patchesJson6902 != null ? build(patchesJson6902) : null;
  }
  public Patch buildPatchesJson6902(Integer index) {
    return this.patchesJson6902.get(index).build();
  }
  public Patch buildFirstPatchesJson6902() {
    return this.patchesJson6902.get(0).build();
  }
  public Patch buildLastPatchesJson6902() {
    return this.patchesJson6902.get(patchesJson6902.size() - 1).build();
  }
  public Patch buildMatchingPatchesJson6902(Predicate<PatchBuilder> predicate) {
    for (PatchBuilder item: patchesJson6902) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPatchesJson6902(Predicate<PatchBuilder> predicate) {
    for (PatchBuilder item: patchesJson6902) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatchesJson6902(List<Patch> patchesJson6902) {
    if (this.patchesJson6902 != null) { _visitables.get("patchesJson6902").removeAll(this.patchesJson6902);}
    if (patchesJson6902 != null) {this.patchesJson6902 = new ArrayList(); for (Patch item : patchesJson6902){this.addToPatchesJson6902(item);}} else { this.patchesJson6902 = null;} return (A) this;
  }
  public A withPatchesJson6902(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch... patchesJson6902) {
    if (this.patchesJson6902 != null) {this.patchesJson6902.clear();}
    if (patchesJson6902 != null) {for (Patch item :patchesJson6902){ this.addToPatchesJson6902(item);}} return (A) this;
  }
  public Boolean hasPatchesJson6902() {
    return patchesJson6902 != null && !patchesJson6902.isEmpty();
  }
  public KustomizationFluent.PatchesJson6902Nested<A> addNewPatchesJson6902() {
    return new KustomizationFluentImpl.PatchesJson6902NestedImpl();
  }
  public KustomizationFluent.PatchesJson6902Nested<A> addNewPatchesJson6902Like(Patch item) {
    return new KustomizationFluentImpl.PatchesJson6902NestedImpl(-1, item);
  }
  public KustomizationFluent.PatchesJson6902Nested<A> setNewPatchesJson6902Like(Integer index,Patch item) {
    return new KustomizationFluentImpl.PatchesJson6902NestedImpl(index, item);
  }
  public KustomizationFluent.PatchesJson6902Nested<A> editPatchesJson6902(Integer index) {
    if (patchesJson6902.size() <= index) throw new RuntimeException("Can't edit patchesJson6902. Index exceeds size.");
    return setNewPatchesJson6902Like(index, buildPatchesJson6902(index));
  }
  public KustomizationFluent.PatchesJson6902Nested<A> editFirstPatchesJson6902() {
    if (patchesJson6902.size() == 0) throw new RuntimeException("Can't edit first patchesJson6902. The list is empty.");
    return setNewPatchesJson6902Like(0, buildPatchesJson6902(0));
  }
  public KustomizationFluent.PatchesJson6902Nested<A> editLastPatchesJson6902() {
    int index = patchesJson6902.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last patchesJson6902. The list is empty.");
    return setNewPatchesJson6902Like(index, buildPatchesJson6902(index));
  }
  public KustomizationFluent.PatchesJson6902Nested<A> editMatchingPatchesJson6902(Predicate<PatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<patchesJson6902.size();i++) { 
    if (predicate.test(patchesJson6902.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching patchesJson6902. No match found.");
    return setNewPatchesJson6902Like(index, buildPatchesJson6902(index));
  }
  public A addToPatchesStrategicMerge(Integer index,String item) {
    if (this.patchesStrategicMerge == null) {this.patchesStrategicMerge = new ArrayList<String>();}
    this.patchesStrategicMerge.add(index, item);
    return (A)this;
  }
  public A setToPatchesStrategicMerge(Integer index,String item) {
    if (this.patchesStrategicMerge == null) {this.patchesStrategicMerge = new ArrayList<String>();}
    this.patchesStrategicMerge.set(index, item); return (A)this;
  }
  public A addToPatchesStrategicMerge(java.lang.String... items) {
    if (this.patchesStrategicMerge == null) {this.patchesStrategicMerge = new ArrayList<String>();}
    for (String item : items) {this.patchesStrategicMerge.add(item);} return (A)this;
  }
  public A addAllToPatchesStrategicMerge(Collection<String> items) {
    if (this.patchesStrategicMerge == null) {this.patchesStrategicMerge = new ArrayList<String>();}
    for (String item : items) {this.patchesStrategicMerge.add(item);} return (A)this;
  }
  public A removeFromPatchesStrategicMerge(java.lang.String... items) {
    for (String item : items) {if (this.patchesStrategicMerge!= null){ this.patchesStrategicMerge.remove(item);}} return (A)this;
  }
  public A removeAllFromPatchesStrategicMerge(Collection<String> items) {
    for (String item : items) {if (this.patchesStrategicMerge!= null){ this.patchesStrategicMerge.remove(item);}} return (A)this;
  }
  public List<String> getPatchesStrategicMerge() {
    return this.patchesStrategicMerge;
  }
  public String getPatchesStrategicMerge(Integer index) {
    return this.patchesStrategicMerge.get(index);
  }
  public String getFirstPatchesStrategicMerge() {
    return this.patchesStrategicMerge.get(0);
  }
  public String getLastPatchesStrategicMerge() {
    return this.patchesStrategicMerge.get(patchesStrategicMerge.size() - 1);
  }
  public String getMatchingPatchesStrategicMerge(Predicate<String> predicate) {
    for (String item: patchesStrategicMerge) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPatchesStrategicMerge(Predicate<String> predicate) {
    for (String item: patchesStrategicMerge) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatchesStrategicMerge(List<String> patchesStrategicMerge) {
    if (patchesStrategicMerge != null) {this.patchesStrategicMerge = new ArrayList(); for (String item : patchesStrategicMerge){this.addToPatchesStrategicMerge(item);}} else { this.patchesStrategicMerge = null;} return (A) this;
  }
  public A withPatchesStrategicMerge(java.lang.String... patchesStrategicMerge) {
    if (this.patchesStrategicMerge != null) {this.patchesStrategicMerge.clear();}
    if (patchesStrategicMerge != null) {for (String item :patchesStrategicMerge){ this.addToPatchesStrategicMerge(item);}} return (A) this;
  }
  public Boolean hasPatchesStrategicMerge() {
    return patchesStrategicMerge != null && !patchesStrategicMerge.isEmpty();
  }
  public A addToReplacements(Integer index,ReplacementField item) {
    if (this.replacements == null) {this.replacements = new ArrayList<ReplacementFieldBuilder>();}
    ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);_visitables.get("replacements").add(index >= 0 ? index : _visitables.get("replacements").size(), builder);this.replacements.add(index >= 0 ? index : replacements.size(), builder); return (A)this;
  }
  public A setToReplacements(Integer index,ReplacementField item) {
    if (this.replacements == null) {this.replacements = new ArrayList<ReplacementFieldBuilder>();}
    ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);
    if (index < 0 || index >= _visitables.get("replacements").size()) { _visitables.get("replacements").add(builder); } else { _visitables.get("replacements").set(index, builder);}
    if (index < 0 || index >= replacements.size()) { replacements.add(builder); } else { replacements.set(index, builder);}
     return (A)this;
  }
  public A addToReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... items) {
    if (this.replacements == null) {this.replacements = new ArrayList<ReplacementFieldBuilder>();}
    for (ReplacementField item : items) {ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);_visitables.get("replacements").add(builder);this.replacements.add(builder);} return (A)this;
  }
  public A addAllToReplacements(Collection<ReplacementField> items) {
    if (this.replacements == null) {this.replacements = new ArrayList<ReplacementFieldBuilder>();}
    for (ReplacementField item : items) {ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);_visitables.get("replacements").add(builder);this.replacements.add(builder);} return (A)this;
  }
  public A removeFromReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... items) {
    for (ReplacementField item : items) {ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);_visitables.get("replacements").remove(builder);if (this.replacements != null) {this.replacements.remove(builder);}} return (A)this;
  }
  public A removeAllFromReplacements(Collection<ReplacementField> items) {
    for (ReplacementField item : items) {ReplacementFieldBuilder builder = new ReplacementFieldBuilder(item);_visitables.get("replacements").remove(builder);if (this.replacements != null) {this.replacements.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReplacements(Predicate<ReplacementFieldBuilder> predicate) {
    if (replacements == null) return (A) this;
    final Iterator<ReplacementFieldBuilder> each = replacements.iterator();
    final List visitables = _visitables.get("replacements");
    while (each.hasNext()) {
      ReplacementFieldBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildReplacements instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ReplacementField> getReplacements() {
    return replacements != null ? build(replacements) : null;
  }
  public List<ReplacementField> buildReplacements() {
    return replacements != null ? build(replacements) : null;
  }
  public ReplacementField buildReplacement(Integer index) {
    return this.replacements.get(index).build();
  }
  public ReplacementField buildFirstReplacement() {
    return this.replacements.get(0).build();
  }
  public ReplacementField buildLastReplacement() {
    return this.replacements.get(replacements.size() - 1).build();
  }
  public ReplacementField buildMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate) {
    for (ReplacementFieldBuilder item: replacements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate) {
    for (ReplacementFieldBuilder item: replacements) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReplacements(List<ReplacementField> replacements) {
    if (this.replacements != null) { _visitables.get("replacements").removeAll(this.replacements);}
    if (replacements != null) {this.replacements = new ArrayList(); for (ReplacementField item : replacements){this.addToReplacements(item);}} else { this.replacements = null;} return (A) this;
  }
  public A withReplacements(io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField... replacements) {
    if (this.replacements != null) {this.replacements.clear();}
    if (replacements != null) {for (ReplacementField item :replacements){ this.addToReplacements(item);}} return (A) this;
  }
  public Boolean hasReplacements() {
    return replacements != null && !replacements.isEmpty();
  }
  public KustomizationFluent.ReplacementsNested<A> addNewReplacement() {
    return new KustomizationFluentImpl.ReplacementsNestedImpl();
  }
  public KustomizationFluent.ReplacementsNested<A> addNewReplacementLike(ReplacementField item) {
    return new KustomizationFluentImpl.ReplacementsNestedImpl(-1, item);
  }
  public KustomizationFluent.ReplacementsNested<A> setNewReplacementLike(Integer index,ReplacementField item) {
    return new KustomizationFluentImpl.ReplacementsNestedImpl(index, item);
  }
  public KustomizationFluent.ReplacementsNested<A> editReplacement(Integer index) {
    if (replacements.size() <= index) throw new RuntimeException("Can't edit replacements. Index exceeds size.");
    return setNewReplacementLike(index, buildReplacement(index));
  }
  public KustomizationFluent.ReplacementsNested<A> editFirstReplacement() {
    if (replacements.size() == 0) throw new RuntimeException("Can't edit first replacements. The list is empty.");
    return setNewReplacementLike(0, buildReplacement(0));
  }
  public KustomizationFluent.ReplacementsNested<A> editLastReplacement() {
    int index = replacements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last replacements. The list is empty.");
    return setNewReplacementLike(index, buildReplacement(index));
  }
  public KustomizationFluent.ReplacementsNested<A> editMatchingReplacement(Predicate<ReplacementFieldBuilder> predicate) {
    int index = -1;
    for (int i=0;i<replacements.size();i++) { 
    if (predicate.test(replacements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching replacements. No match found.");
    return setNewReplacementLike(index, buildReplacement(index));
  }
  public A addToReplicas(Integer index,Replica item) {
    if (this.replicas == null) {this.replicas = new ArrayList<ReplicaBuilder>();}
    ReplicaBuilder builder = new ReplicaBuilder(item);_visitables.get("replicas").add(index >= 0 ? index : _visitables.get("replicas").size(), builder);this.replicas.add(index >= 0 ? index : replicas.size(), builder); return (A)this;
  }
  public A setToReplicas(Integer index,Replica item) {
    if (this.replicas == null) {this.replicas = new ArrayList<ReplicaBuilder>();}
    ReplicaBuilder builder = new ReplicaBuilder(item);
    if (index < 0 || index >= _visitables.get("replicas").size()) { _visitables.get("replicas").add(builder); } else { _visitables.get("replicas").set(index, builder);}
    if (index < 0 || index >= replicas.size()) { replicas.add(builder); } else { replicas.set(index, builder);}
     return (A)this;
  }
  public A addToReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... items) {
    if (this.replicas == null) {this.replicas = new ArrayList<ReplicaBuilder>();}
    for (Replica item : items) {ReplicaBuilder builder = new ReplicaBuilder(item);_visitables.get("replicas").add(builder);this.replicas.add(builder);} return (A)this;
  }
  public A addAllToReplicas(Collection<Replica> items) {
    if (this.replicas == null) {this.replicas = new ArrayList<ReplicaBuilder>();}
    for (Replica item : items) {ReplicaBuilder builder = new ReplicaBuilder(item);_visitables.get("replicas").add(builder);this.replicas.add(builder);} return (A)this;
  }
  public A removeFromReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... items) {
    for (Replica item : items) {ReplicaBuilder builder = new ReplicaBuilder(item);_visitables.get("replicas").remove(builder);if (this.replicas != null) {this.replicas.remove(builder);}} return (A)this;
  }
  public A removeAllFromReplicas(Collection<Replica> items) {
    for (Replica item : items) {ReplicaBuilder builder = new ReplicaBuilder(item);_visitables.get("replicas").remove(builder);if (this.replicas != null) {this.replicas.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReplicas(Predicate<ReplicaBuilder> predicate) {
    if (replicas == null) return (A) this;
    final Iterator<ReplicaBuilder> each = replicas.iterator();
    final List visitables = _visitables.get("replicas");
    while (each.hasNext()) {
      ReplicaBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildReplicas instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Replica> getReplicas() {
    return replicas != null ? build(replicas) : null;
  }
  public List<Replica> buildReplicas() {
    return replicas != null ? build(replicas) : null;
  }
  public Replica buildReplica(Integer index) {
    return this.replicas.get(index).build();
  }
  public Replica buildFirstReplica() {
    return this.replicas.get(0).build();
  }
  public Replica buildLastReplica() {
    return this.replicas.get(replicas.size() - 1).build();
  }
  public Replica buildMatchingReplica(Predicate<ReplicaBuilder> predicate) {
    for (ReplicaBuilder item: replicas) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingReplica(Predicate<ReplicaBuilder> predicate) {
    for (ReplicaBuilder item: replicas) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReplicas(List<Replica> replicas) {
    if (this.replicas != null) { _visitables.get("replicas").removeAll(this.replicas);}
    if (replicas != null) {this.replicas = new ArrayList(); for (Replica item : replicas){this.addToReplicas(item);}} else { this.replicas = null;} return (A) this;
  }
  public A withReplicas(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Replica... replicas) {
    if (this.replicas != null) {this.replicas.clear();}
    if (replicas != null) {for (Replica item :replicas){ this.addToReplicas(item);}} return (A) this;
  }
  public Boolean hasReplicas() {
    return replicas != null && !replicas.isEmpty();
  }
  public A addNewReplica(Long count,String name) {
    return (A)addToReplicas(new Replica(count, name));
  }
  public KustomizationFluent.ReplicasNested<A> addNewReplica() {
    return new KustomizationFluentImpl.ReplicasNestedImpl();
  }
  public KustomizationFluent.ReplicasNested<A> addNewReplicaLike(Replica item) {
    return new KustomizationFluentImpl.ReplicasNestedImpl(-1, item);
  }
  public KustomizationFluent.ReplicasNested<A> setNewReplicaLike(Integer index,Replica item) {
    return new KustomizationFluentImpl.ReplicasNestedImpl(index, item);
  }
  public KustomizationFluent.ReplicasNested<A> editReplica(Integer index) {
    if (replicas.size() <= index) throw new RuntimeException("Can't edit replicas. Index exceeds size.");
    return setNewReplicaLike(index, buildReplica(index));
  }
  public KustomizationFluent.ReplicasNested<A> editFirstReplica() {
    if (replicas.size() == 0) throw new RuntimeException("Can't edit first replicas. The list is empty.");
    return setNewReplicaLike(0, buildReplica(0));
  }
  public KustomizationFluent.ReplicasNested<A> editLastReplica() {
    int index = replicas.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last replicas. The list is empty.");
    return setNewReplicaLike(index, buildReplica(index));
  }
  public KustomizationFluent.ReplicasNested<A> editMatchingReplica(Predicate<ReplicaBuilder> predicate) {
    int index = -1;
    for (int i=0;i<replicas.size();i++) { 
    if (predicate.test(replicas.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching replicas. No match found.");
    return setNewReplicaLike(index, buildReplica(index));
  }
  public A addToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(Integer index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToSecretGenerator(Integer index,SecretArgs item) {
    if (this.secretGenerator == null) {this.secretGenerator = new ArrayList<SecretArgsBuilder>();}
    SecretArgsBuilder builder = new SecretArgsBuilder(item);_visitables.get("secretGenerator").add(index >= 0 ? index : _visitables.get("secretGenerator").size(), builder);this.secretGenerator.add(index >= 0 ? index : secretGenerator.size(), builder); return (A)this;
  }
  public A setToSecretGenerator(Integer index,SecretArgs item) {
    if (this.secretGenerator == null) {this.secretGenerator = new ArrayList<SecretArgsBuilder>();}
    SecretArgsBuilder builder = new SecretArgsBuilder(item);
    if (index < 0 || index >= _visitables.get("secretGenerator").size()) { _visitables.get("secretGenerator").add(builder); } else { _visitables.get("secretGenerator").set(index, builder);}
    if (index < 0 || index >= secretGenerator.size()) { secretGenerator.add(builder); } else { secretGenerator.set(index, builder);}
     return (A)this;
  }
  public A addToSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... items) {
    if (this.secretGenerator == null) {this.secretGenerator = new ArrayList<SecretArgsBuilder>();}
    for (SecretArgs item : items) {SecretArgsBuilder builder = new SecretArgsBuilder(item);_visitables.get("secretGenerator").add(builder);this.secretGenerator.add(builder);} return (A)this;
  }
  public A addAllToSecretGenerator(Collection<SecretArgs> items) {
    if (this.secretGenerator == null) {this.secretGenerator = new ArrayList<SecretArgsBuilder>();}
    for (SecretArgs item : items) {SecretArgsBuilder builder = new SecretArgsBuilder(item);_visitables.get("secretGenerator").add(builder);this.secretGenerator.add(builder);} return (A)this;
  }
  public A removeFromSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... items) {
    for (SecretArgs item : items) {SecretArgsBuilder builder = new SecretArgsBuilder(item);_visitables.get("secretGenerator").remove(builder);if (this.secretGenerator != null) {this.secretGenerator.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecretGenerator(Collection<SecretArgs> items) {
    for (SecretArgs item : items) {SecretArgsBuilder builder = new SecretArgsBuilder(item);_visitables.get("secretGenerator").remove(builder);if (this.secretGenerator != null) {this.secretGenerator.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecretGenerator(Predicate<SecretArgsBuilder> predicate) {
    if (secretGenerator == null) return (A) this;
    final Iterator<SecretArgsBuilder> each = secretGenerator.iterator();
    final List visitables = _visitables.get("secretGenerator");
    while (each.hasNext()) {
      SecretArgsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretGenerator instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SecretArgs> getSecretGenerator() {
    return secretGenerator != null ? build(secretGenerator) : null;
  }
  public List<SecretArgs> buildSecretGenerator() {
    return secretGenerator != null ? build(secretGenerator) : null;
  }
  public SecretArgs buildSecretGenerator(Integer index) {
    return this.secretGenerator.get(index).build();
  }
  public SecretArgs buildFirstSecretGenerator() {
    return this.secretGenerator.get(0).build();
  }
  public SecretArgs buildLastSecretGenerator() {
    return this.secretGenerator.get(secretGenerator.size() - 1).build();
  }
  public SecretArgs buildMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate) {
    for (SecretArgsBuilder item: secretGenerator) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate) {
    for (SecretArgsBuilder item: secretGenerator) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecretGenerator(List<SecretArgs> secretGenerator) {
    if (this.secretGenerator != null) { _visitables.get("secretGenerator").removeAll(this.secretGenerator);}
    if (secretGenerator != null) {this.secretGenerator = new ArrayList(); for (SecretArgs item : secretGenerator){this.addToSecretGenerator(item);}} else { this.secretGenerator = null;} return (A) this;
  }
  public A withSecretGenerator(io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs... secretGenerator) {
    if (this.secretGenerator != null) {this.secretGenerator.clear();}
    if (secretGenerator != null) {for (SecretArgs item :secretGenerator){ this.addToSecretGenerator(item);}} return (A) this;
  }
  public Boolean hasSecretGenerator() {
    return secretGenerator != null && !secretGenerator.isEmpty();
  }
  public KustomizationFluent.SecretGeneratorNested<A> addNewSecretGenerator() {
    return new KustomizationFluentImpl.SecretGeneratorNestedImpl();
  }
  public KustomizationFluent.SecretGeneratorNested<A> addNewSecretGeneratorLike(SecretArgs item) {
    return new KustomizationFluentImpl.SecretGeneratorNestedImpl(-1, item);
  }
  public KustomizationFluent.SecretGeneratorNested<A> setNewSecretGeneratorLike(Integer index,SecretArgs item) {
    return new KustomizationFluentImpl.SecretGeneratorNestedImpl(index, item);
  }
  public KustomizationFluent.SecretGeneratorNested<A> editSecretGenerator(Integer index) {
    if (secretGenerator.size() <= index) throw new RuntimeException("Can't edit secretGenerator. Index exceeds size.");
    return setNewSecretGeneratorLike(index, buildSecretGenerator(index));
  }
  public KustomizationFluent.SecretGeneratorNested<A> editFirstSecretGenerator() {
    if (secretGenerator.size() == 0) throw new RuntimeException("Can't edit first secretGenerator. The list is empty.");
    return setNewSecretGeneratorLike(0, buildSecretGenerator(0));
  }
  public KustomizationFluent.SecretGeneratorNested<A> editLastSecretGenerator() {
    int index = secretGenerator.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretGenerator. The list is empty.");
    return setNewSecretGeneratorLike(index, buildSecretGenerator(index));
  }
  public KustomizationFluent.SecretGeneratorNested<A> editMatchingSecretGenerator(Predicate<SecretArgsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretGenerator.size();i++) { 
    if (predicate.test(secretGenerator.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretGenerator. No match found.");
    return setNewSecretGeneratorLike(index, buildSecretGenerator(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSortOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SortOptions getSortOptions() {
    return this.sortOptions!=null ?this.sortOptions.build():null;
  }
  public SortOptions buildSortOptions() {
    return this.sortOptions!=null ?this.sortOptions.build():null;
  }
  public A withSortOptions(SortOptions sortOptions) {
    _visitables.get("sortOptions").remove(this.sortOptions);
    if (sortOptions!=null){ this.sortOptions= new SortOptionsBuilder(sortOptions); _visitables.get("sortOptions").add(this.sortOptions);} else { this.sortOptions = null; _visitables.get("sortOptions").remove(this.sortOptions); } return (A) this;
  }
  public Boolean hasSortOptions() {
    return this.sortOptions != null;
  }
  public KustomizationFluent.SortOptionsNested<A> withNewSortOptions() {
    return new KustomizationFluentImpl.SortOptionsNestedImpl();
  }
  public KustomizationFluent.SortOptionsNested<A> withNewSortOptionsLike(SortOptions item) {
    return new KustomizationFluentImpl.SortOptionsNestedImpl(item);
  }
  public KustomizationFluent.SortOptionsNested<A> editSortOptions() {
    return withNewSortOptionsLike(getSortOptions());
  }
  public KustomizationFluent.SortOptionsNested<A> editOrNewSortOptions() {
    return withNewSortOptionsLike(getSortOptions() != null ? getSortOptions(): new SortOptionsBuilder().build());
  }
  public KustomizationFluent.SortOptionsNested<A> editOrNewSortOptionsLike(SortOptions item) {
    return withNewSortOptionsLike(getSortOptions() != null ? getSortOptions(): item);
  }
  public A addToTransformers(Integer index,String item) {
    if (this.transformers == null) {this.transformers = new ArrayList<String>();}
    this.transformers.add(index, item);
    return (A)this;
  }
  public A setToTransformers(Integer index,String item) {
    if (this.transformers == null) {this.transformers = new ArrayList<String>();}
    this.transformers.set(index, item); return (A)this;
  }
  public A addToTransformers(java.lang.String... items) {
    if (this.transformers == null) {this.transformers = new ArrayList<String>();}
    for (String item : items) {this.transformers.add(item);} return (A)this;
  }
  public A addAllToTransformers(Collection<String> items) {
    if (this.transformers == null) {this.transformers = new ArrayList<String>();}
    for (String item : items) {this.transformers.add(item);} return (A)this;
  }
  public A removeFromTransformers(java.lang.String... items) {
    for (String item : items) {if (this.transformers!= null){ this.transformers.remove(item);}} return (A)this;
  }
  public A removeAllFromTransformers(Collection<String> items) {
    for (String item : items) {if (this.transformers!= null){ this.transformers.remove(item);}} return (A)this;
  }
  public List<String> getTransformers() {
    return this.transformers;
  }
  public String getTransformer(Integer index) {
    return this.transformers.get(index);
  }
  public String getFirstTransformer() {
    return this.transformers.get(0);
  }
  public String getLastTransformer() {
    return this.transformers.get(transformers.size() - 1);
  }
  public String getMatchingTransformer(Predicate<String> predicate) {
    for (String item: transformers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTransformer(Predicate<String> predicate) {
    for (String item: transformers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTransformers(List<String> transformers) {
    if (transformers != null) {this.transformers = new ArrayList(); for (String item : transformers){this.addToTransformers(item);}} else { this.transformers = null;} return (A) this;
  }
  public A withTransformers(java.lang.String... transformers) {
    if (this.transformers != null) {this.transformers.clear();}
    if (transformers != null) {for (String item :transformers){ this.addToTransformers(item);}} return (A) this;
  }
  public Boolean hasTransformers() {
    return transformers != null && !transformers.isEmpty();
  }
  public A addToValidators(Integer index,String item) {
    if (this.validators == null) {this.validators = new ArrayList<String>();}
    this.validators.add(index, item);
    return (A)this;
  }
  public A setToValidators(Integer index,String item) {
    if (this.validators == null) {this.validators = new ArrayList<String>();}
    this.validators.set(index, item); return (A)this;
  }
  public A addToValidators(java.lang.String... items) {
    if (this.validators == null) {this.validators = new ArrayList<String>();}
    for (String item : items) {this.validators.add(item);} return (A)this;
  }
  public A addAllToValidators(Collection<String> items) {
    if (this.validators == null) {this.validators = new ArrayList<String>();}
    for (String item : items) {this.validators.add(item);} return (A)this;
  }
  public A removeFromValidators(java.lang.String... items) {
    for (String item : items) {if (this.validators!= null){ this.validators.remove(item);}} return (A)this;
  }
  public A removeAllFromValidators(Collection<String> items) {
    for (String item : items) {if (this.validators!= null){ this.validators.remove(item);}} return (A)this;
  }
  public List<String> getValidators() {
    return this.validators;
  }
  public String getValidator(Integer index) {
    return this.validators.get(index);
  }
  public String getFirstValidator() {
    return this.validators.get(0);
  }
  public String getLastValidator() {
    return this.validators.get(validators.size() - 1);
  }
  public String getMatchingValidator(Predicate<String> predicate) {
    for (String item: validators) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingValidator(Predicate<String> predicate) {
    for (String item: validators) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValidators(List<String> validators) {
    if (validators != null) {this.validators = new ArrayList(); for (String item : validators){this.addToValidators(item);}} else { this.validators = null;} return (A) this;
  }
  public A withValidators(java.lang.String... validators) {
    if (this.validators != null) {this.validators.clear();}
    if (validators != null) {for (String item :validators){ this.addToValidators(item);}} return (A) this;
  }
  public Boolean hasValidators() {
    return validators != null && !validators.isEmpty();
  }
  public A addToVars(Integer index,Var item) {
    if (this.vars == null) {this.vars = new ArrayList<VarBuilder>();}
    VarBuilder builder = new VarBuilder(item);_visitables.get("vars").add(index >= 0 ? index : _visitables.get("vars").size(), builder);this.vars.add(index >= 0 ? index : vars.size(), builder); return (A)this;
  }
  public A setToVars(Integer index,Var item) {
    if (this.vars == null) {this.vars = new ArrayList<VarBuilder>();}
    VarBuilder builder = new VarBuilder(item);
    if (index < 0 || index >= _visitables.get("vars").size()) { _visitables.get("vars").add(builder); } else { _visitables.get("vars").set(index, builder);}
    if (index < 0 || index >= vars.size()) { vars.add(builder); } else { vars.set(index, builder);}
     return (A)this;
  }
  public A addToVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... items) {
    if (this.vars == null) {this.vars = new ArrayList<VarBuilder>();}
    for (Var item : items) {VarBuilder builder = new VarBuilder(item);_visitables.get("vars").add(builder);this.vars.add(builder);} return (A)this;
  }
  public A addAllToVars(Collection<Var> items) {
    if (this.vars == null) {this.vars = new ArrayList<VarBuilder>();}
    for (Var item : items) {VarBuilder builder = new VarBuilder(item);_visitables.get("vars").add(builder);this.vars.add(builder);} return (A)this;
  }
  public A removeFromVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... items) {
    for (Var item : items) {VarBuilder builder = new VarBuilder(item);_visitables.get("vars").remove(builder);if (this.vars != null) {this.vars.remove(builder);}} return (A)this;
  }
  public A removeAllFromVars(Collection<Var> items) {
    for (Var item : items) {VarBuilder builder = new VarBuilder(item);_visitables.get("vars").remove(builder);if (this.vars != null) {this.vars.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVars(Predicate<VarBuilder> predicate) {
    if (vars == null) return (A) this;
    final Iterator<VarBuilder> each = vars.iterator();
    final List visitables = _visitables.get("vars");
    while (each.hasNext()) {
      VarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVars instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Var> getVars() {
    return vars != null ? build(vars) : null;
  }
  public List<Var> buildVars() {
    return vars != null ? build(vars) : null;
  }
  public Var buildVar(Integer index) {
    return this.vars.get(index).build();
  }
  public Var buildFirstVar() {
    return this.vars.get(0).build();
  }
  public Var buildLastVar() {
    return this.vars.get(vars.size() - 1).build();
  }
  public Var buildMatchingVar(Predicate<VarBuilder> predicate) {
    for (VarBuilder item: vars) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVar(Predicate<VarBuilder> predicate) {
    for (VarBuilder item: vars) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVars(List<Var> vars) {
    if (this.vars != null) { _visitables.get("vars").removeAll(this.vars);}
    if (vars != null) {this.vars = new ArrayList(); for (Var item : vars){this.addToVars(item);}} else { this.vars = null;} return (A) this;
  }
  public A withVars(io.fabric8.kubernetes.api.model.kustomize.v1beta1.Var... vars) {
    if (this.vars != null) {this.vars.clear();}
    if (vars != null) {for (Var item :vars){ this.addToVars(item);}} return (A) this;
  }
  public Boolean hasVars() {
    return vars != null && !vars.isEmpty();
  }
  public KustomizationFluent.VarsNested<A> addNewVar() {
    return new KustomizationFluentImpl.VarsNestedImpl();
  }
  public KustomizationFluent.VarsNested<A> addNewVarLike(Var item) {
    return new KustomizationFluentImpl.VarsNestedImpl(-1, item);
  }
  public KustomizationFluent.VarsNested<A> setNewVarLike(Integer index,Var item) {
    return new KustomizationFluentImpl.VarsNestedImpl(index, item);
  }
  public KustomizationFluent.VarsNested<A> editVar(Integer index) {
    if (vars.size() <= index) throw new RuntimeException("Can't edit vars. Index exceeds size.");
    return setNewVarLike(index, buildVar(index));
  }
  public KustomizationFluent.VarsNested<A> editFirstVar() {
    if (vars.size() == 0) throw new RuntimeException("Can't edit first vars. The list is empty.");
    return setNewVarLike(0, buildVar(0));
  }
  public KustomizationFluent.VarsNested<A> editLastVar() {
    int index = vars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last vars. The list is empty.");
    return setNewVarLike(index, buildVar(index));
  }
  public KustomizationFluent.VarsNested<A> editMatchingVar(Predicate<VarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<vars.size();i++) { 
    if (predicate.test(vars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching vars. No match found.");
    return setNewVarLike(index, buildVar(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KustomizationFluentImpl that = (KustomizationFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (bases != null ? !bases.equals(that.bases) :that.bases != null) return false;
    if (buildMetadata != null ? !buildMetadata.equals(that.buildMetadata) :that.buildMetadata != null) return false;
    if (commonAnnotations != null ? !commonAnnotations.equals(that.commonAnnotations) :that.commonAnnotations != null) return false;
    if (commonLabels != null ? !commonLabels.equals(that.commonLabels) :that.commonLabels != null) return false;
    if (components != null ? !components.equals(that.components) :that.components != null) return false;
    if (configMapGenerator != null ? !configMapGenerator.equals(that.configMapGenerator) :that.configMapGenerator != null) return false;
    if (configurations != null ? !configurations.equals(that.configurations) :that.configurations != null) return false;
    if (crds != null ? !crds.equals(that.crds) :that.crds != null) return false;
    if (generatorOptions != null ? !generatorOptions.equals(that.generatorOptions) :that.generatorOptions != null) return false;
    if (generators != null ? !generators.equals(that.generators) :that.generators != null) return false;
    if (helmChartInflationGenerator != null ? !helmChartInflationGenerator.equals(that.helmChartInflationGenerator) :that.helmChartInflationGenerator != null) return false;
    if (helmCharts != null ? !helmCharts.equals(that.helmCharts) :that.helmCharts != null) return false;
    if (helmGlobals != null ? !helmGlobals.equals(that.helmGlobals) :that.helmGlobals != null) return false;
    if (imageTags != null ? !imageTags.equals(that.imageTags) :that.imageTags != null) return false;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (namePrefix != null ? !namePrefix.equals(that.namePrefix) :that.namePrefix != null) return false;
    if (nameSuffix != null ? !nameSuffix.equals(that.nameSuffix) :that.nameSuffix != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (openapi != null ? !openapi.equals(that.openapi) :that.openapi != null) return false;
    if (patches != null ? !patches.equals(that.patches) :that.patches != null) return false;
    if (patchesJson6902 != null ? !patchesJson6902.equals(that.patchesJson6902) :that.patchesJson6902 != null) return false;
    if (patchesStrategicMerge != null ? !patchesStrategicMerge.equals(that.patchesStrategicMerge) :that.patchesStrategicMerge != null) return false;
    if (replacements != null ? !replacements.equals(that.replacements) :that.replacements != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (secretGenerator != null ? !secretGenerator.equals(that.secretGenerator) :that.secretGenerator != null) return false;
    if (sortOptions != null ? !sortOptions.equals(that.sortOptions) :that.sortOptions != null) return false;
    if (transformers != null ? !transformers.equals(that.transformers) :that.transformers != null) return false;
    if (validators != null ? !validators.equals(that.validators) :that.validators != null) return false;
    if (vars != null ? !vars.equals(that.vars) :that.vars != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  bases,  buildMetadata,  commonAnnotations,  commonLabels,  components,  configMapGenerator,  configurations,  crds,  generatorOptions,  generators,  helmChartInflationGenerator,  helmCharts,  helmGlobals,  imageTags,  images,  kind,  labels,  metadata,  namePrefix,  nameSuffix,  namespace,  openapi,  patches,  patchesJson6902,  patchesStrategicMerge,  replacements,  replicas,  resources,  secretGenerator,  sortOptions,  transformers,  validators,  vars,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (bases != null && !bases.isEmpty()) { sb.append("bases:"); sb.append(bases + ","); }
    if (buildMetadata != null && !buildMetadata.isEmpty()) { sb.append("buildMetadata:"); sb.append(buildMetadata + ","); }
    if (commonAnnotations != null && !commonAnnotations.isEmpty()) { sb.append("commonAnnotations:"); sb.append(commonAnnotations + ","); }
    if (commonLabels != null && !commonLabels.isEmpty()) { sb.append("commonLabels:"); sb.append(commonLabels + ","); }
    if (components != null && !components.isEmpty()) { sb.append("components:"); sb.append(components + ","); }
    if (configMapGenerator != null && !configMapGenerator.isEmpty()) { sb.append("configMapGenerator:"); sb.append(configMapGenerator + ","); }
    if (configurations != null && !configurations.isEmpty()) { sb.append("configurations:"); sb.append(configurations + ","); }
    if (crds != null && !crds.isEmpty()) { sb.append("crds:"); sb.append(crds + ","); }
    if (generatorOptions != null) { sb.append("generatorOptions:"); sb.append(generatorOptions + ","); }
    if (generators != null && !generators.isEmpty()) { sb.append("generators:"); sb.append(generators + ","); }
    if (helmChartInflationGenerator != null && !helmChartInflationGenerator.isEmpty()) { sb.append("helmChartInflationGenerator:"); sb.append(helmChartInflationGenerator + ","); }
    if (helmCharts != null && !helmCharts.isEmpty()) { sb.append("helmCharts:"); sb.append(helmCharts + ","); }
    if (helmGlobals != null) { sb.append("helmGlobals:"); sb.append(helmGlobals + ","); }
    if (imageTags != null && !imageTags.isEmpty()) { sb.append("imageTags:"); sb.append(imageTags + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (namePrefix != null) { sb.append("namePrefix:"); sb.append(namePrefix + ","); }
    if (nameSuffix != null) { sb.append("nameSuffix:"); sb.append(nameSuffix + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (openapi != null && !openapi.isEmpty()) { sb.append("openapi:"); sb.append(openapi + ","); }
    if (patches != null && !patches.isEmpty()) { sb.append("patches:"); sb.append(patches + ","); }
    if (patchesJson6902 != null && !patchesJson6902.isEmpty()) { sb.append("patchesJson6902:"); sb.append(patchesJson6902 + ","); }
    if (patchesStrategicMerge != null && !patchesStrategicMerge.isEmpty()) { sb.append("patchesStrategicMerge:"); sb.append(patchesStrategicMerge + ","); }
    if (replacements != null && !replacements.isEmpty()) { sb.append("replacements:"); sb.append(replacements + ","); }
    if (replicas != null && !replicas.isEmpty()) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (secretGenerator != null && !secretGenerator.isEmpty()) { sb.append("secretGenerator:"); sb.append(secretGenerator + ","); }
    if (sortOptions != null) { sb.append("sortOptions:"); sb.append(sortOptions + ","); }
    if (transformers != null && !transformers.isEmpty()) { sb.append("transformers:"); sb.append(transformers + ","); }
    if (validators != null && !validators.isEmpty()) { sb.append("validators:"); sb.append(validators + ","); }
    if (vars != null && !vars.isEmpty()) { sb.append("vars:"); sb.append(vars + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapGeneratorNestedImpl<N> extends ConfigMapArgsFluentImpl<KustomizationFluent.ConfigMapGeneratorNested<N>> implements KustomizationFluent.ConfigMapGeneratorNested<N>,Nested<N>{
    ConfigMapGeneratorNestedImpl(Integer index,ConfigMapArgs item) {
      this.index = index;
      this.builder = new ConfigMapArgsBuilder(this, item);
    }
    ConfigMapGeneratorNestedImpl() {
      this.index = -1;
      this.builder = new ConfigMapArgsBuilder(this);
    }
    ConfigMapArgsBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToConfigMapGenerator(index,builder.build());
    }
    public N endConfigMapGenerator() {
      return and();
    }
    
  }
  class GeneratorOptionsNestedImpl<N> extends GeneratorOptionsFluentImpl<KustomizationFluent.GeneratorOptionsNested<N>> implements KustomizationFluent.GeneratorOptionsNested<N>,Nested<N>{
    GeneratorOptionsNestedImpl(GeneratorOptions item) {
      this.builder = new GeneratorOptionsBuilder(this, item);
    }
    GeneratorOptionsNestedImpl() {
      this.builder = new GeneratorOptionsBuilder(this);
    }
    GeneratorOptionsBuilder builder;
    public N and() {
      return (N) KustomizationFluentImpl.this.withGeneratorOptions(builder.build());
    }
    public N endGeneratorOptions() {
      return and();
    }
    
  }
  class HelmChartInflationGeneratorNestedImpl<N> extends HelmChartArgsFluentImpl<KustomizationFluent.HelmChartInflationGeneratorNested<N>> implements KustomizationFluent.HelmChartInflationGeneratorNested<N>,Nested<N>{
    HelmChartInflationGeneratorNestedImpl(Integer index,HelmChartArgs item) {
      this.index = index;
      this.builder = new HelmChartArgsBuilder(this, item);
    }
    HelmChartInflationGeneratorNestedImpl() {
      this.index = -1;
      this.builder = new HelmChartArgsBuilder(this);
    }
    HelmChartArgsBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToHelmChartInflationGenerator(index,builder.build());
    }
    public N endHelmChartInflationGenerator() {
      return and();
    }
    
  }
  class HelmChartsNestedImpl<N> extends HelmChartFluentImpl<KustomizationFluent.HelmChartsNested<N>> implements KustomizationFluent.HelmChartsNested<N>,Nested<N>{
    HelmChartsNestedImpl(Integer index,HelmChart item) {
      this.index = index;
      this.builder = new HelmChartBuilder(this, item);
    }
    HelmChartsNestedImpl() {
      this.index = -1;
      this.builder = new HelmChartBuilder(this);
    }
    HelmChartBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToHelmCharts(index,builder.build());
    }
    public N endHelmChart() {
      return and();
    }
    
  }
  class HelmGlobalsNestedImpl<N> extends HelmGlobalsFluentImpl<KustomizationFluent.HelmGlobalsNested<N>> implements KustomizationFluent.HelmGlobalsNested<N>,Nested<N>{
    HelmGlobalsNestedImpl(HelmGlobals item) {
      this.builder = new HelmGlobalsBuilder(this, item);
    }
    HelmGlobalsNestedImpl() {
      this.builder = new HelmGlobalsBuilder(this);
    }
    HelmGlobalsBuilder builder;
    public N and() {
      return (N) KustomizationFluentImpl.this.withHelmGlobals(builder.build());
    }
    public N endHelmGlobals() {
      return and();
    }
    
  }
  class ImageTagsNestedImpl<N> extends ImageFluentImpl<KustomizationFluent.ImageTagsNested<N>> implements KustomizationFluent.ImageTagsNested<N>,Nested<N>{
    ImageTagsNestedImpl(Integer index,Image item) {
      this.index = index;
      this.builder = new ImageBuilder(this, item);
    }
    ImageTagsNestedImpl() {
      this.index = -1;
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToImageTags(index,builder.build());
    }
    public N endImageTag() {
      return and();
    }
    
  }
  class ImagesNestedImpl<N> extends ImageFluentImpl<KustomizationFluent.ImagesNested<N>> implements KustomizationFluent.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(Integer index,Image item) {
      this.index = index;
      this.builder = new ImageBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class LabelsNestedImpl<N> extends LabelFluentImpl<KustomizationFluent.LabelsNested<N>> implements KustomizationFluent.LabelsNested<N>,Nested<N>{
    LabelsNestedImpl(Integer index,Label item) {
      this.index = index;
      this.builder = new LabelBuilder(this, item);
    }
    LabelsNestedImpl() {
      this.index = -1;
      this.builder = new LabelBuilder(this);
    }
    LabelBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToLabels(index,builder.build());
    }
    public N endLabel() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KustomizationFluent.MetadataNested<N>> implements KustomizationFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) KustomizationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class PatchesNestedImpl<N> extends PatchFluentImpl<KustomizationFluent.PatchesNested<N>> implements KustomizationFluent.PatchesNested<N>,Nested<N>{
    PatchesNestedImpl(Integer index,Patch item) {
      this.index = index;
      this.builder = new PatchBuilder(this, item);
    }
    PatchesNestedImpl() {
      this.index = -1;
      this.builder = new PatchBuilder(this);
    }
    PatchBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToPatches(index,builder.build());
    }
    public N endPatch() {
      return and();
    }
    
  }
  class PatchesJson6902NestedImpl<N> extends PatchFluentImpl<KustomizationFluent.PatchesJson6902Nested<N>> implements KustomizationFluent.PatchesJson6902Nested<N>,Nested<N>{
    PatchesJson6902NestedImpl(Integer index,Patch item) {
      this.index = index;
      this.builder = new PatchBuilder(this, item);
    }
    PatchesJson6902NestedImpl() {
      this.index = -1;
      this.builder = new PatchBuilder(this);
    }
    PatchBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToPatchesJson6902(index,builder.build());
    }
    public N endPatchesJson6902() {
      return and();
    }
    
  }
  class ReplacementsNestedImpl<N> extends ReplacementFieldFluentImpl<KustomizationFluent.ReplacementsNested<N>> implements KustomizationFluent.ReplacementsNested<N>,Nested<N>{
    ReplacementsNestedImpl(Integer index,ReplacementField item) {
      this.index = index;
      this.builder = new ReplacementFieldBuilder(this, item);
    }
    ReplacementsNestedImpl() {
      this.index = -1;
      this.builder = new ReplacementFieldBuilder(this);
    }
    ReplacementFieldBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToReplacements(index,builder.build());
    }
    public N endReplacement() {
      return and();
    }
    
  }
  class ReplicasNestedImpl<N> extends ReplicaFluentImpl<KustomizationFluent.ReplicasNested<N>> implements KustomizationFluent.ReplicasNested<N>,Nested<N>{
    ReplicasNestedImpl(Integer index,Replica item) {
      this.index = index;
      this.builder = new ReplicaBuilder(this, item);
    }
    ReplicasNestedImpl() {
      this.index = -1;
      this.builder = new ReplicaBuilder(this);
    }
    ReplicaBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToReplicas(index,builder.build());
    }
    public N endReplica() {
      return and();
    }
    
  }
  class SecretGeneratorNestedImpl<N> extends SecretArgsFluentImpl<KustomizationFluent.SecretGeneratorNested<N>> implements KustomizationFluent.SecretGeneratorNested<N>,Nested<N>{
    SecretGeneratorNestedImpl(Integer index,SecretArgs item) {
      this.index = index;
      this.builder = new SecretArgsBuilder(this, item);
    }
    SecretGeneratorNestedImpl() {
      this.index = -1;
      this.builder = new SecretArgsBuilder(this);
    }
    SecretArgsBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToSecretGenerator(index,builder.build());
    }
    public N endSecretGenerator() {
      return and();
    }
    
  }
  class SortOptionsNestedImpl<N> extends SortOptionsFluentImpl<KustomizationFluent.SortOptionsNested<N>> implements KustomizationFluent.SortOptionsNested<N>,Nested<N>{
    SortOptionsNestedImpl(SortOptions item) {
      this.builder = new SortOptionsBuilder(this, item);
    }
    SortOptionsNestedImpl() {
      this.builder = new SortOptionsBuilder(this);
    }
    SortOptionsBuilder builder;
    public N and() {
      return (N) KustomizationFluentImpl.this.withSortOptions(builder.build());
    }
    public N endSortOptions() {
      return and();
    }
    
  }
  class VarsNestedImpl<N> extends VarFluentImpl<KustomizationFluent.VarsNested<N>> implements KustomizationFluent.VarsNested<N>,Nested<N>{
    VarsNestedImpl(Integer index,Var item) {
      this.index = index;
      this.builder = new VarBuilder(this, item);
    }
    VarsNestedImpl() {
      this.index = -1;
      this.builder = new VarBuilder(this);
    }
    VarBuilder builder;
    Integer index;
    public N and() {
      return (N) KustomizationFluentImpl.this.setToVars(index,builder.build());
    }
    public N endVar() {
      return and();
    }
    
  }
  
}