package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KustomizationBuilder extends KustomizationFluentImpl<KustomizationBuilder> implements VisitableBuilder<Kustomization,KustomizationBuilder>{
  public KustomizationBuilder() {
    this(false);
  }
  public KustomizationBuilder(Boolean validationEnabled) {
    this(new Kustomization(), validationEnabled);
  }
  public KustomizationBuilder(KustomizationFluent<?> fluent) {
    this(fluent, false);
  }
  public KustomizationBuilder(KustomizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Kustomization(), validationEnabled);
  }
  public KustomizationBuilder(KustomizationFluent<?> fluent,Kustomization instance) {
    this(fluent, instance, false);
  }
  public KustomizationBuilder(KustomizationFluent<?> fluent,Kustomization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withBases(instance.getBases()); 
    fluent.withBuildMetadata(instance.getBuildMetadata()); 
    fluent.withCommonAnnotations(instance.getCommonAnnotations()); 
    fluent.withCommonLabels(instance.getCommonLabels()); 
    fluent.withComponents(instance.getComponents()); 
    fluent.withConfigMapGenerator(instance.getConfigMapGenerator()); 
    fluent.withConfigurations(instance.getConfigurations()); 
    fluent.withCrds(instance.getCrds()); 
    fluent.withGeneratorOptions(instance.getGeneratorOptions()); 
    fluent.withGenerators(instance.getGenerators()); 
    fluent.withHelmChartInflationGenerator(instance.getHelmChartInflationGenerator()); 
    fluent.withHelmCharts(instance.getHelmCharts()); 
    fluent.withHelmGlobals(instance.getHelmGlobals()); 
    fluent.withImageTags(instance.getImageTags()); 
    fluent.withImages(instance.getImages()); 
    fluent.withKind(instance.getKind()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withNamePrefix(instance.getNamePrefix()); 
    fluent.withNameSuffix(instance.getNameSuffix()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withOpenapi(instance.getOpenapi()); 
    fluent.withPatches(instance.getPatches()); 
    fluent.withPatchesJson6902(instance.getPatchesJson6902()); 
    fluent.withPatchesStrategicMerge(instance.getPatchesStrategicMerge()); 
    fluent.withReplacements(instance.getReplacements()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withResources(instance.getResources()); 
    fluent.withSecretGenerator(instance.getSecretGenerator()); 
    fluent.withSortOptions(instance.getSortOptions()); 
    fluent.withTransformers(instance.getTransformers()); 
    fluent.withValidators(instance.getValidators()); 
    fluent.withVars(instance.getVars()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KustomizationBuilder(Kustomization instance) {
    this(instance,false);
  }
  public KustomizationBuilder(Kustomization instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withBases(instance.getBases()); 
    this.withBuildMetadata(instance.getBuildMetadata()); 
    this.withCommonAnnotations(instance.getCommonAnnotations()); 
    this.withCommonLabels(instance.getCommonLabels()); 
    this.withComponents(instance.getComponents()); 
    this.withConfigMapGenerator(instance.getConfigMapGenerator()); 
    this.withConfigurations(instance.getConfigurations()); 
    this.withCrds(instance.getCrds()); 
    this.withGeneratorOptions(instance.getGeneratorOptions()); 
    this.withGenerators(instance.getGenerators()); 
    this.withHelmChartInflationGenerator(instance.getHelmChartInflationGenerator()); 
    this.withHelmCharts(instance.getHelmCharts()); 
    this.withHelmGlobals(instance.getHelmGlobals()); 
    this.withImageTags(instance.getImageTags()); 
    this.withImages(instance.getImages()); 
    this.withKind(instance.getKind()); 
    this.withLabels(instance.getLabels()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNamePrefix(instance.getNamePrefix()); 
    this.withNameSuffix(instance.getNameSuffix()); 
    this.withNamespace(instance.getNamespace()); 
    this.withOpenapi(instance.getOpenapi()); 
    this.withPatches(instance.getPatches()); 
    this.withPatchesJson6902(instance.getPatchesJson6902()); 
    this.withPatchesStrategicMerge(instance.getPatchesStrategicMerge()); 
    this.withReplacements(instance.getReplacements()); 
    this.withReplicas(instance.getReplicas()); 
    this.withResources(instance.getResources()); 
    this.withSecretGenerator(instance.getSecretGenerator()); 
    this.withSortOptions(instance.getSortOptions()); 
    this.withTransformers(instance.getTransformers()); 
    this.withValidators(instance.getValidators()); 
    this.withVars(instance.getVars()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KustomizationFluent<?> fluent;
  Boolean validationEnabled;
  public Kustomization build() {
    Kustomization buildable = new Kustomization(fluent.getApiVersion(),fluent.getBases(),fluent.getBuildMetadata(),fluent.getCommonAnnotations(),fluent.getCommonLabels(),fluent.getComponents(),fluent.getConfigMapGenerator(),fluent.getConfigurations(),fluent.getCrds(),fluent.getGeneratorOptions(),fluent.getGenerators(),fluent.getHelmChartInflationGenerator(),fluent.getHelmCharts(),fluent.getHelmGlobals(),fluent.getImageTags(),fluent.getImages(),fluent.getKind(),fluent.getLabels(),fluent.getMetadata(),fluent.getNamePrefix(),fluent.getNameSuffix(),fluent.getNamespace(),fluent.getOpenapi(),fluent.getPatches(),fluent.getPatchesJson6902(),fluent.getPatchesStrategicMerge(),fluent.getReplacements(),fluent.getReplicas(),fluent.getResources(),fluent.getSecretGenerator(),fluent.getSortOptions(),fluent.getTransformers(),fluent.getValidators(),fluent.getVars());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}