package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplacementFieldBuilder extends ReplacementFieldFluentImpl<ReplacementFieldBuilder> implements VisitableBuilder<ReplacementField,ReplacementFieldBuilder>{
  public ReplacementFieldBuilder() {
    this(false);
  }
  public ReplacementFieldBuilder(Boolean validationEnabled) {
    this(new ReplacementField(), validationEnabled);
  }
  public ReplacementFieldBuilder(ReplacementFieldFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplacementFieldBuilder(ReplacementFieldFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplacementField(), validationEnabled);
  }
  public ReplacementFieldBuilder(ReplacementFieldFluent<?> fluent,ReplacementField instance) {
    this(fluent, instance, false);
  }
  public ReplacementFieldBuilder(ReplacementFieldFluent<?> fluent,ReplacementField instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withSource(instance.getSource()); 
    fluent.withTargets(instance.getTargets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplacementFieldBuilder(ReplacementField instance) {
    this(instance,false);
  }
  public ReplacementFieldBuilder(ReplacementField instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withSource(instance.getSource()); 
    this.withTargets(instance.getTargets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplacementFieldFluent<?> fluent;
  Boolean validationEnabled;
  public ReplacementField build() {
    ReplacementField buildable = new ReplacementField(fluent.getPath(),fluent.getSource(),fluent.getTargets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}