package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FieldOptionsBuilder extends FieldOptionsFluentImpl<FieldOptionsBuilder> implements VisitableBuilder<FieldOptions,FieldOptionsBuilder>{
  public FieldOptionsBuilder() {
    this(false);
  }
  public FieldOptionsBuilder(Boolean validationEnabled) {
    this(new FieldOptions(), validationEnabled);
  }
  public FieldOptionsBuilder(FieldOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public FieldOptionsBuilder(FieldOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FieldOptions(), validationEnabled);
  }
  public FieldOptionsBuilder(FieldOptionsFluent<?> fluent,FieldOptions instance) {
    this(fluent, instance, false);
  }
  public FieldOptionsBuilder(FieldOptionsFluent<?> fluent,FieldOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCreate(instance.getCreate()); 
    fluent.withDelimiter(instance.getDelimiter()); 
    fluent.withEncoding(instance.getEncoding()); 
    fluent.withIndex(instance.getIndex()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FieldOptionsBuilder(FieldOptions instance) {
    this(instance,false);
  }
  public FieldOptionsBuilder(FieldOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCreate(instance.getCreate()); 
    this.withDelimiter(instance.getDelimiter()); 
    this.withEncoding(instance.getEncoding()); 
    this.withIndex(instance.getIndex()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FieldOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public FieldOptions build() {
    FieldOptions buildable = new FieldOptions(fluent.getCreate(),fluent.getDelimiter(),fluent.getEncoding(),fluent.getIndex());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}