/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptions;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptionsBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorFluentImpl;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TargetSelectorFluentImpl<A extends TargetSelectorFluent<A>>
extends BaseFluent<A>
implements TargetSelectorFluent<A> {
    private List<String> fieldPaths = new ArrayList<String>();
    private FieldOptionsBuilder options;
    private ArrayList<SelectorBuilder> reject = new ArrayList();
    private SelectorBuilder select;
    private Map<String, Object> additionalProperties;

    public TargetSelectorFluentImpl() {
    }

    public TargetSelectorFluentImpl(TargetSelector instance) {
        this.withFieldPaths(instance.getFieldPaths());
        this.withOptions(instance.getOptions());
        this.withReject(instance.getReject());
        this.withSelect(instance.getSelect());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToFieldPaths(Integer index, String item) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        this.fieldPaths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFieldPaths(Integer index, String item) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        this.fieldPaths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFieldPaths(String ... items) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.fieldPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFieldPaths(Collection<String> items) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.fieldPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFieldPaths(String ... items) {
        for (String item : items) {
            if (this.fieldPaths == null) continue;
            this.fieldPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFieldPaths(Collection<String> items) {
        for (String item : items) {
            if (this.fieldPaths == null) continue;
            this.fieldPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFieldPaths() {
        return this.fieldPaths;
    }

    @Override
    public String getFieldPath(Integer index) {
        return this.fieldPaths.get(index);
    }

    @Override
    public String getFirstFieldPath() {
        return this.fieldPaths.get(0);
    }

    @Override
    public String getLastFieldPath() {
        return this.fieldPaths.get(this.fieldPaths.size() - 1);
    }

    @Override
    public String getMatchingFieldPath(Predicate<String> predicate) {
        for (String item : this.fieldPaths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFieldPath(Predicate<String> predicate) {
        for (String item : this.fieldPaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFieldPaths(List<String> fieldPaths) {
        if (fieldPaths != null) {
            this.fieldPaths = new ArrayList<String>();
            for (String item : fieldPaths) {
                this.addToFieldPaths(item);
            }
        } else {
            this.fieldPaths = null;
        }
        return (A)this;
    }

    @Override
    public A withFieldPaths(String ... fieldPaths) {
        if (this.fieldPaths != null) {
            this.fieldPaths.clear();
        }
        if (fieldPaths != null) {
            for (String item : fieldPaths) {
                this.addToFieldPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFieldPaths() {
        return this.fieldPaths != null && !this.fieldPaths.isEmpty();
    }

    @Override
    @Deprecated
    public FieldOptions getOptions() {
        return this.options != null ? this.options.build() : null;
    }

    @Override
    public FieldOptions buildOptions() {
        return this.options != null ? this.options.build() : null;
    }

    @Override
    public A withOptions(FieldOptions options) {
        this._visitables.get((Object)"options").remove(this.options);
        if (options != null) {
            this.options = new FieldOptionsBuilder(options);
            this._visitables.get((Object)"options").add(this.options);
        } else {
            this.options = null;
            this._visitables.get((Object)"options").remove(this.options);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public A withNewOptions(Boolean create, String delimiter, String encoding, Integer index) {
        return this.withOptions(new FieldOptions(create, delimiter, encoding, index));
    }

    @Override
    public TargetSelectorFluent.OptionsNested<A> withNewOptions() {
        return new OptionsNestedImpl();
    }

    @Override
    public TargetSelectorFluent.OptionsNested<A> withNewOptionsLike(FieldOptions item) {
        return new OptionsNestedImpl(item);
    }

    @Override
    public TargetSelectorFluent.OptionsNested<A> editOptions() {
        return this.withNewOptionsLike(this.getOptions());
    }

    @Override
    public TargetSelectorFluent.OptionsNested<A> editOrNewOptions() {
        return this.withNewOptionsLike(this.getOptions() != null ? this.getOptions() : new FieldOptionsBuilder().build());
    }

    @Override
    public TargetSelectorFluent.OptionsNested<A> editOrNewOptionsLike(FieldOptions item) {
        return this.withNewOptionsLike(this.getOptions() != null ? this.getOptions() : item);
    }

    @Override
    public A addToReject(Integer index, Selector item) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        SelectorBuilder builder = new SelectorBuilder(item);
        this._visitables.get((Object)"reject").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"reject").size(), builder);
        this.reject.add(index >= 0 ? index.intValue() : this.reject.size(), builder);
        return (A)this;
    }

    @Override
    public A setToReject(Integer index, Selector item) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        SelectorBuilder builder = new SelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"reject").size()) {
            this._visitables.get((Object)"reject").add(builder);
        } else {
            this._visitables.get((Object)"reject").set(index, builder);
        }
        if (index < 0 || index >= this.reject.size()) {
            this.reject.add(builder);
        } else {
            this.reject.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReject(Selector ... items) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReject(Collection<Selector> items) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReject(Selector ... items) {
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").remove(builder);
            if (this.reject == null) continue;
            this.reject.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReject(Collection<Selector> items) {
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").remove(builder);
            if (this.reject == null) continue;
            this.reject.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromReject(Predicate<SelectorBuilder> predicate) {
        if (this.reject == null) {
            return (A)this;
        }
        Iterator<SelectorBuilder> each = this.reject.iterator();
        List visitables = this._visitables.get((Object)"reject");
        while (each.hasNext()) {
            SelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Selector> getReject() {
        return this.reject != null ? TargetSelectorFluentImpl.build(this.reject) : null;
    }

    @Override
    public List<Selector> buildReject() {
        return this.reject != null ? TargetSelectorFluentImpl.build(this.reject) : null;
    }

    @Override
    public Selector buildReject(Integer index) {
        return this.reject.get(index).build();
    }

    @Override
    public Selector buildFirstReject() {
        return this.reject.get(0).build();
    }

    @Override
    public Selector buildLastReject() {
        return this.reject.get(this.reject.size() - 1).build();
    }

    @Override
    public Selector buildMatchingReject(Predicate<SelectorBuilder> predicate) {
        for (SelectorBuilder item : this.reject) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReject(Predicate<SelectorBuilder> predicate) {
        for (SelectorBuilder item : this.reject) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReject(List<Selector> reject) {
        if (this.reject != null) {
            this._visitables.get((Object)"reject").removeAll(this.reject);
        }
        if (reject != null) {
            this.reject = new ArrayList();
            for (Selector item : reject) {
                this.addToReject(item);
            }
        } else {
            this.reject = null;
        }
        return (A)this;
    }

    @Override
    public A withReject(Selector ... reject) {
        if (this.reject != null) {
            this.reject.clear();
        }
        if (reject != null) {
            for (Selector item : reject) {
                this.addToReject(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReject() {
        return this.reject != null && !this.reject.isEmpty();
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> addNewReject() {
        return new RejectNestedImpl();
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> addNewRejectLike(Selector item) {
        return new RejectNestedImpl(-1, item);
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> setNewRejectLike(Integer index, Selector item) {
        return new RejectNestedImpl(index, item);
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> editReject(Integer index) {
        if (this.reject.size() <= index) {
            throw new RuntimeException("Can't edit reject. Index exceeds size.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> editFirstReject() {
        if (this.reject.size() == 0) {
            throw new RuntimeException("Can't edit first reject. The list is empty.");
        }
        return this.setNewRejectLike(0, this.buildReject(0));
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> editLastReject() {
        int index = this.reject.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reject. The list is empty.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    @Override
    public TargetSelectorFluent.RejectNested<A> editMatchingReject(Predicate<SelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reject.size(); ++i) {
            if (!predicate.test(this.reject.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reject. No match found.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    @Override
    @Deprecated
    public Selector getSelect() {
        return this.select != null ? this.select.build() : null;
    }

    @Override
    public Selector buildSelect() {
        return this.select != null ? this.select.build() : null;
    }

    @Override
    public A withSelect(Selector select) {
        this._visitables.get((Object)"select").remove(this.select);
        if (select != null) {
            this.select = new SelectorBuilder(select);
            this._visitables.get((Object)"select").add(this.select);
        } else {
            this.select = null;
            this._visitables.get((Object)"select").remove(this.select);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelect() {
        return this.select != null;
    }

    @Override
    public TargetSelectorFluent.SelectNested<A> withNewSelect() {
        return new SelectNestedImpl();
    }

    @Override
    public TargetSelectorFluent.SelectNested<A> withNewSelectLike(Selector item) {
        return new SelectNestedImpl(item);
    }

    @Override
    public TargetSelectorFluent.SelectNested<A> editSelect() {
        return this.withNewSelectLike(this.getSelect());
    }

    @Override
    public TargetSelectorFluent.SelectNested<A> editOrNewSelect() {
        return this.withNewSelectLike(this.getSelect() != null ? this.getSelect() : new SelectorBuilder().build());
    }

    @Override
    public TargetSelectorFluent.SelectNested<A> editOrNewSelectLike(Selector item) {
        return this.withNewSelectLike(this.getSelect() != null ? this.getSelect() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetSelectorFluentImpl that = (TargetSelectorFluentImpl)o;
        if (this.fieldPaths != null ? !this.fieldPaths.equals(that.fieldPaths) : that.fieldPaths != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.reject != null ? !this.reject.equals(that.reject) : that.reject != null) {
            return false;
        }
        if (this.select != null ? !this.select.equals(that.select) : that.select != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.fieldPaths, this.options, this.reject, this.select, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fieldPaths != null && !this.fieldPaths.isEmpty()) {
            sb.append("fieldPaths:");
            sb.append(this.fieldPaths + ",");
        }
        if (this.options != null) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.reject != null && !this.reject.isEmpty()) {
            sb.append("reject:");
            sb.append(this.reject + ",");
        }
        if (this.select != null) {
            sb.append("select:");
            sb.append(this.select + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SelectNestedImpl<N>
    extends SelectorFluentImpl<TargetSelectorFluent.SelectNested<N>>
    implements TargetSelectorFluent.SelectNested<N>,
    Nested<N> {
        SelectorBuilder builder;

        SelectNestedImpl(Selector item) {
            this.builder = new SelectorBuilder(this, item);
        }

        SelectNestedImpl() {
            this.builder = new SelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TargetSelectorFluentImpl.this.withSelect(this.builder.build());
        }

        @Override
        public N endSelect() {
            return this.and();
        }
    }

    class RejectNestedImpl<N>
    extends SelectorFluentImpl<TargetSelectorFluent.RejectNested<N>>
    implements TargetSelectorFluent.RejectNested<N>,
    Nested<N> {
        SelectorBuilder builder;
        Integer index;

        RejectNestedImpl(Integer index, Selector item) {
            this.index = index;
            this.builder = new SelectorBuilder(this, item);
        }

        RejectNestedImpl() {
            this.index = -1;
            this.builder = new SelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TargetSelectorFluentImpl.this.setToReject(this.index, this.builder.build());
        }

        @Override
        public N endReject() {
            return this.and();
        }
    }

    class OptionsNestedImpl<N>
    extends FieldOptionsFluentImpl<TargetSelectorFluent.OptionsNested<N>>
    implements TargetSelectorFluent.OptionsNested<N>,
    Nested<N> {
        FieldOptionsBuilder builder;

        OptionsNestedImpl(FieldOptions item) {
            this.builder = new FieldOptionsBuilder(this, item);
        }

        OptionsNestedImpl() {
            this.builder = new FieldOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TargetSelectorFluentImpl.this.withOptions(this.builder.build());
        }

        @Override
        public N endOptions() {
            return this.and();
        }
    }
}

