package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TargetSelectorBuilder extends TargetSelectorFluentImpl<TargetSelectorBuilder> implements VisitableBuilder<TargetSelector,TargetSelectorBuilder>{
  public TargetSelectorBuilder() {
    this(false);
  }
  public TargetSelectorBuilder(Boolean validationEnabled) {
    this(new TargetSelector(), validationEnabled);
  }
  public TargetSelectorBuilder(TargetSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TargetSelector(), validationEnabled);
  }
  public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,TargetSelector instance) {
    this(fluent, instance, false);
  }
  public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,TargetSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFieldPaths(instance.getFieldPaths()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withReject(instance.getReject()); 
    fluent.withSelect(instance.getSelect()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TargetSelectorBuilder(TargetSelector instance) {
    this(instance,false);
  }
  public TargetSelectorBuilder(TargetSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFieldPaths(instance.getFieldPaths()); 
    this.withOptions(instance.getOptions()); 
    this.withReject(instance.getReject()); 
    this.withSelect(instance.getSelect()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TargetSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public TargetSelector build() {
    TargetSelector buildable = new TargetSelector(fluent.getFieldPaths(),fluent.getOptions(),fluent.getReject(),fluent.getSelect());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}