package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmChartArgsFluentImpl<A extends HelmChartArgsFluent<A>> extends BaseFluent<A> implements HelmChartArgsFluent<A>{
  public HelmChartArgsFluentImpl() {
  }
  public HelmChartArgsFluentImpl(HelmChartArgs instance) {
    this.withChartHome(instance.getChartHome()); 
    this.withChartName(instance.getChartName()); 
    this.withChartRepoName(instance.getChartRepoName()); 
    this.withChartRepoUrl(instance.getChartRepoUrl()); 
    this.withChartVersion(instance.getChartVersion()); 
    this.withExtraArgs(instance.getExtraArgs()); 
    this.withHelmBin(instance.getHelmBin()); 
    this.withHelmHome(instance.getHelmHome()); 
    this.withReleaseName(instance.getReleaseName()); 
    this.withReleaseNamespace(instance.getReleaseNamespace()); 
    this.withValues(instance.getValues()); 
    this.withValuesLocal(instance.getValuesLocal()); 
    this.withValuesMerge(instance.getValuesMerge()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String chartHome;
  private String chartName;
  private String chartRepoName;
  private String chartRepoUrl;
  private String chartVersion;
  private List<String> extraArgs = new ArrayList<String>();
  private String helmBin;
  private String helmHome;
  private String releaseName;
  private String releaseNamespace;
  private String values;
  private Map<String,Object> valuesLocal;
  private String valuesMerge;
  private Map<String,Object> additionalProperties;
  public String getChartHome() {
    return this.chartHome;
  }
  public A withChartHome(String chartHome) {
    this.chartHome=chartHome; return (A) this;
  }
  public Boolean hasChartHome() {
    return this.chartHome != null;
  }
  public String getChartName() {
    return this.chartName;
  }
  public A withChartName(String chartName) {
    this.chartName=chartName; return (A) this;
  }
  public Boolean hasChartName() {
    return this.chartName != null;
  }
  public String getChartRepoName() {
    return this.chartRepoName;
  }
  public A withChartRepoName(String chartRepoName) {
    this.chartRepoName=chartRepoName; return (A) this;
  }
  public Boolean hasChartRepoName() {
    return this.chartRepoName != null;
  }
  public String getChartRepoUrl() {
    return this.chartRepoUrl;
  }
  public A withChartRepoUrl(String chartRepoUrl) {
    this.chartRepoUrl=chartRepoUrl; return (A) this;
  }
  public Boolean hasChartRepoUrl() {
    return this.chartRepoUrl != null;
  }
  public String getChartVersion() {
    return this.chartVersion;
  }
  public A withChartVersion(String chartVersion) {
    this.chartVersion=chartVersion; return (A) this;
  }
  public Boolean hasChartVersion() {
    return this.chartVersion != null;
  }
  public A addToExtraArgs(Integer index,String item) {
    if (this.extraArgs == null) {this.extraArgs = new ArrayList<String>();}
    this.extraArgs.add(index, item);
    return (A)this;
  }
  public A setToExtraArgs(Integer index,String item) {
    if (this.extraArgs == null) {this.extraArgs = new ArrayList<String>();}
    this.extraArgs.set(index, item); return (A)this;
  }
  public A addToExtraArgs(java.lang.String... items) {
    if (this.extraArgs == null) {this.extraArgs = new ArrayList<String>();}
    for (String item : items) {this.extraArgs.add(item);} return (A)this;
  }
  public A addAllToExtraArgs(Collection<String> items) {
    if (this.extraArgs == null) {this.extraArgs = new ArrayList<String>();}
    for (String item : items) {this.extraArgs.add(item);} return (A)this;
  }
  public A removeFromExtraArgs(java.lang.String... items) {
    for (String item : items) {if (this.extraArgs!= null){ this.extraArgs.remove(item);}} return (A)this;
  }
  public A removeAllFromExtraArgs(Collection<String> items) {
    for (String item : items) {if (this.extraArgs!= null){ this.extraArgs.remove(item);}} return (A)this;
  }
  public List<String> getExtraArgs() {
    return this.extraArgs;
  }
  public String getExtraArg(Integer index) {
    return this.extraArgs.get(index);
  }
  public String getFirstExtraArg() {
    return this.extraArgs.get(0);
  }
  public String getLastExtraArg() {
    return this.extraArgs.get(extraArgs.size() - 1);
  }
  public String getMatchingExtraArg(Predicate<String> predicate) {
    for (String item: extraArgs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExtraArg(Predicate<String> predicate) {
    for (String item: extraArgs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtraArgs(List<String> extraArgs) {
    if (extraArgs != null) {this.extraArgs = new ArrayList(); for (String item : extraArgs){this.addToExtraArgs(item);}} else { this.extraArgs = null;} return (A) this;
  }
  public A withExtraArgs(java.lang.String... extraArgs) {
    if (this.extraArgs != null) {this.extraArgs.clear();}
    if (extraArgs != null) {for (String item :extraArgs){ this.addToExtraArgs(item);}} return (A) this;
  }
  public Boolean hasExtraArgs() {
    return extraArgs != null && !extraArgs.isEmpty();
  }
  public String getHelmBin() {
    return this.helmBin;
  }
  public A withHelmBin(String helmBin) {
    this.helmBin=helmBin; return (A) this;
  }
  public Boolean hasHelmBin() {
    return this.helmBin != null;
  }
  public String getHelmHome() {
    return this.helmHome;
  }
  public A withHelmHome(String helmHome) {
    this.helmHome=helmHome; return (A) this;
  }
  public Boolean hasHelmHome() {
    return this.helmHome != null;
  }
  public String getReleaseName() {
    return this.releaseName;
  }
  public A withReleaseName(String releaseName) {
    this.releaseName=releaseName; return (A) this;
  }
  public Boolean hasReleaseName() {
    return this.releaseName != null;
  }
  public String getReleaseNamespace() {
    return this.releaseNamespace;
  }
  public A withReleaseNamespace(String releaseNamespace) {
    this.releaseNamespace=releaseNamespace; return (A) this;
  }
  public Boolean hasReleaseNamespace() {
    return this.releaseNamespace != null;
  }
  public String getValues() {
    return this.values;
  }
  public A withValues(String values) {
    this.values=values; return (A) this;
  }
  public Boolean hasValues() {
    return this.values != null;
  }
  public A addToValuesLocal(String key,Object value) {
    if(this.valuesLocal == null && key != null && value != null) { this.valuesLocal = new LinkedHashMap(); }
    if(key != null && value != null) {this.valuesLocal.put(key, value);} return (A)this;
  }
  public A addToValuesLocal(Map<String,Object> map) {
    if(this.valuesLocal == null && map != null) { this.valuesLocal = new LinkedHashMap(); }
    if(map != null) { this.valuesLocal.putAll(map);} return (A)this;
  }
  public A removeFromValuesLocal(String key) {
    if(this.valuesLocal == null) { return (A) this; }
    if(key != null && this.valuesLocal != null) {this.valuesLocal.remove(key);} return (A)this;
  }
  public A removeFromValuesLocal(Map<String,Object> map) {
    if(this.valuesLocal == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.valuesLocal != null){this.valuesLocal.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getValuesLocal() {
    return this.valuesLocal;
  }
  public <K,V>A withValuesLocal(Map<String,Object> valuesLocal) {
    if (valuesLocal == null) { this.valuesLocal =  null;} else {this.valuesLocal = new LinkedHashMap(valuesLocal);} return (A) this;
  }
  public Boolean hasValuesLocal() {
    return this.valuesLocal != null;
  }
  public String getValuesMerge() {
    return this.valuesMerge;
  }
  public A withValuesMerge(String valuesMerge) {
    this.valuesMerge=valuesMerge; return (A) this;
  }
  public Boolean hasValuesMerge() {
    return this.valuesMerge != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HelmChartArgsFluentImpl that = (HelmChartArgsFluentImpl) o;
    if (chartHome != null ? !chartHome.equals(that.chartHome) :that.chartHome != null) return false;
    if (chartName != null ? !chartName.equals(that.chartName) :that.chartName != null) return false;
    if (chartRepoName != null ? !chartRepoName.equals(that.chartRepoName) :that.chartRepoName != null) return false;
    if (chartRepoUrl != null ? !chartRepoUrl.equals(that.chartRepoUrl) :that.chartRepoUrl != null) return false;
    if (chartVersion != null ? !chartVersion.equals(that.chartVersion) :that.chartVersion != null) return false;
    if (extraArgs != null ? !extraArgs.equals(that.extraArgs) :that.extraArgs != null) return false;
    if (helmBin != null ? !helmBin.equals(that.helmBin) :that.helmBin != null) return false;
    if (helmHome != null ? !helmHome.equals(that.helmHome) :that.helmHome != null) return false;
    if (releaseName != null ? !releaseName.equals(that.releaseName) :that.releaseName != null) return false;
    if (releaseNamespace != null ? !releaseNamespace.equals(that.releaseNamespace) :that.releaseNamespace != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (valuesLocal != null ? !valuesLocal.equals(that.valuesLocal) :that.valuesLocal != null) return false;
    if (valuesMerge != null ? !valuesMerge.equals(that.valuesMerge) :that.valuesMerge != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(chartHome,  chartName,  chartRepoName,  chartRepoUrl,  chartVersion,  extraArgs,  helmBin,  helmHome,  releaseName,  releaseNamespace,  values,  valuesLocal,  valuesMerge,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (chartHome != null) { sb.append("chartHome:"); sb.append(chartHome + ","); }
    if (chartName != null) { sb.append("chartName:"); sb.append(chartName + ","); }
    if (chartRepoName != null) { sb.append("chartRepoName:"); sb.append(chartRepoName + ","); }
    if (chartRepoUrl != null) { sb.append("chartRepoUrl:"); sb.append(chartRepoUrl + ","); }
    if (chartVersion != null) { sb.append("chartVersion:"); sb.append(chartVersion + ","); }
    if (extraArgs != null && !extraArgs.isEmpty()) { sb.append("extraArgs:"); sb.append(extraArgs + ","); }
    if (helmBin != null) { sb.append("helmBin:"); sb.append(helmBin + ","); }
    if (helmHome != null) { sb.append("helmHome:"); sb.append(helmHome + ","); }
    if (releaseName != null) { sb.append("releaseName:"); sb.append(releaseName + ","); }
    if (releaseNamespace != null) { sb.append("releaseNamespace:"); sb.append(releaseNamespace + ","); }
    if (values != null) { sb.append("values:"); sb.append(values + ","); }
    if (valuesLocal != null && !valuesLocal.isEmpty()) { sb.append("valuesLocal:"); sb.append(valuesLocal + ","); }
    if (valuesMerge != null) { sb.append("valuesMerge:"); sb.append(valuesMerge + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}