package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartArgsBuilder extends HelmChartArgsFluentImpl<HelmChartArgsBuilder> implements VisitableBuilder<HelmChartArgs,HelmChartArgsBuilder>{
  public HelmChartArgsBuilder() {
    this(false);
  }
  public HelmChartArgsBuilder(Boolean validationEnabled) {
    this(new HelmChartArgs(), validationEnabled);
  }
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmChartArgs(), validationEnabled);
  }
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent,HelmChartArgs instance) {
    this(fluent, instance, false);
  }
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent,HelmChartArgs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChartHome(instance.getChartHome()); 
    fluent.withChartName(instance.getChartName()); 
    fluent.withChartRepoName(instance.getChartRepoName()); 
    fluent.withChartRepoUrl(instance.getChartRepoUrl()); 
    fluent.withChartVersion(instance.getChartVersion()); 
    fluent.withExtraArgs(instance.getExtraArgs()); 
    fluent.withHelmBin(instance.getHelmBin()); 
    fluent.withHelmHome(instance.getHelmHome()); 
    fluent.withReleaseName(instance.getReleaseName()); 
    fluent.withReleaseNamespace(instance.getReleaseNamespace()); 
    fluent.withValues(instance.getValues()); 
    fluent.withValuesLocal(instance.getValuesLocal()); 
    fluent.withValuesMerge(instance.getValuesMerge()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartArgsBuilder(HelmChartArgs instance) {
    this(instance,false);
  }
  public HelmChartArgsBuilder(HelmChartArgs instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withChartHome(instance.getChartHome()); 
    this.withChartName(instance.getChartName()); 
    this.withChartRepoName(instance.getChartRepoName()); 
    this.withChartRepoUrl(instance.getChartRepoUrl()); 
    this.withChartVersion(instance.getChartVersion()); 
    this.withExtraArgs(instance.getExtraArgs()); 
    this.withHelmBin(instance.getHelmBin()); 
    this.withHelmHome(instance.getHelmHome()); 
    this.withReleaseName(instance.getReleaseName()); 
    this.withReleaseNamespace(instance.getReleaseNamespace()); 
    this.withValues(instance.getValues()); 
    this.withValuesLocal(instance.getValuesLocal()); 
    this.withValuesMerge(instance.getValuesMerge()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HelmChartArgsFluent<?> fluent;
  Boolean validationEnabled;
  public HelmChartArgs build() {
    HelmChartArgs buildable = new HelmChartArgs(fluent.getChartHome(),fluent.getChartName(),fluent.getChartRepoName(),fluent.getChartRepoUrl(),fluent.getChartVersion(),fluent.getExtraArgs(),fluent.getHelmBin(),fluent.getHelmHome(),fluent.getReleaseName(),fluent.getReleaseNamespace(),fluent.getValues(),fluent.getValuesLocal(),fluent.getValuesMerge());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}