package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ObjectMetaBuilder extends ObjectMetaFluent<ObjectMetaBuilder> implements VisitableBuilder<ObjectMeta,ObjectMetaBuilder>{
  public ObjectMetaBuilder() {
    this(new ObjectMeta());
  }
  
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
    this(fluent, new ObjectMeta());
  }
  
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ObjectMetaBuilder(ObjectMeta instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ObjectMetaFluent<?> fluent;
  
  public ObjectMeta build() {
    ObjectMeta buildable = new ObjectMeta(fluent.getAnnotations(),fluent.getLabels(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}