package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HelmChartBuilder extends HelmChartFluent<HelmChartBuilder> implements VisitableBuilder<HelmChart,HelmChartBuilder>{
  public HelmChartBuilder() {
    this(new HelmChart());
  }
  
  public HelmChartBuilder(HelmChartFluent<?> fluent) {
    this(fluent, new HelmChart());
  }
  
  public HelmChartBuilder(HelmChartFluent<?> fluent,HelmChart instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HelmChartBuilder(HelmChart instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HelmChartFluent<?> fluent;
  
  public HelmChart build() {
    HelmChart buildable = new HelmChart(fluent.getAdditionalValuesFiles(),fluent.getApiVersions(),fluent.getIncludeCRDs(),fluent.getName(),fluent.getNameTemplate(),fluent.getNamespace(),fluent.getReleaseName(),fluent.getRepo(),fluent.getSkipHooks(),fluent.getSkipTests(),fluent.getValuesFile(),fluent.getValuesInline(),fluent.getValuesMerge(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}