/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import org.jsonschema2pojo.model.EnumDefinition;
import org.jsonschema2pojo.rules.EnumRule;
import org.jsonschema2pojo.rules.RuleFactory;

public class Fabric8EnumRule
extends EnumRule {
    private static final String TO_LOWERCASE_METHOD = "toLowerCase";
    private final RuleFactory ruleFactory;

    protected Fabric8EnumRule(RuleFactory ruleFactory) {
        super(ruleFactory);
        this.ruleFactory = ruleFactory;
    }

    protected void addFieldAccessors(JDefinedClass _enum, JFieldVar valueField) {
    }

    protected void addFactoryMethod(EnumDefinition enumDefinition, JDefinedClass _enum) {
        JClass stringType = _enum.owner().ref(String.class);
        JMethod fromValue = _enum.method(17, (JType)_enum, "fromValue");
        JVar valueParam = fromValue.param((JType)_enum.owner().ref(Object.class), "value");
        JBlock body = fromValue.body();
        JFieldVar backingTypeLookupMap = this.addValueLookupMap(enumDefinition, _enum);
        JFieldVar addNameLookupMap = this.addNameLookupMap(_enum);
        JConditional _ifString = body._if(valueParam._instanceof((JType)stringType));
        this.getEnumFromNameConstants(_ifString._then().block(), valueParam, addNameLookupMap, enumDefinition, _enum);
        this.getEnumFromValueConstants(body, valueParam, backingTypeLookupMap, enumDefinition, _enum);
        this.ruleFactory.getAnnotator().enumCreatorMethod(_enum, fromValue);
    }

    protected void getEnumFromValueConstants(JBlock body, JVar valueParam, JFieldVar quickLookupMap, EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JVar constant = body.decl((JType)_enum, "constant").init((JExpression)quickLookupMap.invoke("get").arg((JExpression)valueParam));
        JConditional _if = body._if(constant.eq(JExpr._null()));
        _if._then()._throw((JExpression)this.illegalArgumentException(valueParam, _enum, backingType));
        _if._else()._return((JExpression)constant);
    }

    protected void getEnumFromNameConstants(JBlock body, JVar valueParam, JFieldVar quickLookupMap, EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JClass stringType = _enum.owner().ref(String.class);
        JVar constant = body.decl((JType)_enum, "constant").init((JExpression)quickLookupMap.invoke("get").arg((JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)stringType, (JExpression)valueParam), (String)TO_LOWERCASE_METHOD)));
        JConditional _if = body._if(constant.eq(JExpr._null()));
        _if._then()._throw((JExpression)this.illegalArgumentException(valueParam, _enum, backingType));
        _if._else()._return((JExpression)constant);
    }

    private JInvocation illegalArgumentException(JVar valueParam, JDefinedClass _enum, JType backingType) {
        JInvocation illegalArgumentException = JExpr._new((JClass)_enum.owner().ref(IllegalArgumentException.class));
        JVar expr = valueParam;
        if (!this.isString(backingType)) {
            expr = expr.plus(JExpr.lit((String)""));
        }
        illegalArgumentException.arg((JExpression)expr);
        return illegalArgumentException;
    }

    protected JFieldVar addValueLookupMap(EnumDefinition enumDefinition, JDefinedClass _enum) {
        JType backingType = enumDefinition.getBackingType();
        JClass lookupType = _enum.owner().ref(Map.class).narrow(new JClass[]{backingType.boxify(), _enum});
        JFieldVar backingTypeLookupMap = _enum.field(28, (JType)lookupType, "CONSTANTS");
        JClass lookupImplType = _enum.owner().ref(HashMap.class).narrow(new JClass[]{backingType.boxify(), _enum});
        backingTypeLookupMap.init((JExpression)JExpr._new((JClass)lookupImplType));
        JForEach forEach = _enum.init().forEach((JType)_enum, "c", (JExpression)JExpr.invoke((String)"values"));
        JInvocation put = forEach.body().invoke((JExpression)backingTypeLookupMap, "put");
        if (this.isString(backingType)) {
            put.arg((JExpression)forEach.var().ref("value").invoke(TO_LOWERCASE_METHOD));
        } else {
            put.arg((JExpression)forEach.var().ref("value"));
        }
        put.arg((JExpression)forEach.var());
        return backingTypeLookupMap;
    }

    protected JFieldVar addNameLookupMap(JDefinedClass _enum) {
        JClass stringType = _enum.owner().ref(String.class);
        JClass nameLookupType = _enum.owner().ref(Map.class).narrow(new JClass[]{stringType, _enum});
        JFieldVar nameLookupMap = _enum.field(28, (JType)nameLookupType, "NAME_CONSTANTS");
        JClass lookupImplType = _enum.owner().ref(HashMap.class).narrow(new JClass[]{stringType, _enum});
        nameLookupMap.init((JExpression)JExpr._new((JClass)lookupImplType));
        JForEach forEach = _enum.init().forEach((JType)_enum, "c", (JExpression)JExpr.invoke((String)"values"));
        JInvocation namePut = forEach.body().invoke((JExpression)nameLookupMap, "put");
        namePut.arg((JExpression)forEach.var().invoke("name").invoke(TO_LOWERCASE_METHOD));
        namePut.arg((JExpression)forEach.var());
        return nameLookupMap;
    }
}

