/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.transform.annotations.TemplateTransformation;
import io.sundr.transform.annotations.TemplateTransformations;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesCoreTypeAnnotator
extends Jackson2Annotator {
    protected static final String ANNOTATION_VALUE = "value";
    protected static final String API_VERSION = "apiVersion";
    protected static final String METADATA = "metadata";
    protected static final String KIND = "kind";
    protected static final String DEFAULT = "default";
    public static final String CORE_PACKAGE = "core";
    public static final String OPENSHIFT_PACKAGE = "openshift";
    protected final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    protected final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();
    protected String moduleName = null;

    public KubernetesCoreTypeAnnotator(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray(ANNOTATION_VALUE);
        annotationValue.param(API_VERSION);
        annotationValue.param(KIND);
        annotationValue.param(METADATA);
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            String next = (String)properties.next();
            if (next.equals(API_VERSION) || next.equals(KIND) || next.equals(METADATA)) continue;
            annotationValue.param(next);
        }
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        this.processBuildable(clazz);
        Map fields = clazz.fields();
        if (fields.containsKey(KIND) && propertiesNode.has(API_VERSION) && propertiesNode.get(API_VERSION).has(DEFAULT)) {
            String resourceName;
            String apiVersion = propertiesNode.get(API_VERSION).get(DEFAULT).toString().replace('\"', ' ').trim();
            String apiGroup = "";
            int lastSlash = apiVersion.lastIndexOf(47);
            if (lastSlash > 0) {
                apiGroup = apiVersion.substring(0, lastSlash);
                apiVersion = apiVersion.substring(apiGroup.length() + 1);
            }
            if ((resourceName = clazz.fullName()).endsWith("List")) {
                JDefinedClass resourceClass = this.pendingResources.remove(resourceName = resourceName.substring(0, resourceName.length() - 4));
                if (resourceClass != null) {
                    this.annotate(clazz, apiVersion, apiGroup);
                    this.addClassesToPropertyFiles(resourceClass);
                } else {
                    this.pendingLists.put(resourceName, clazz);
                }
            } else {
                JDefinedClass resourceListClass = this.pendingLists.remove(resourceName);
                if (resourceListClass != null) {
                    this.annotate(resourceListClass, apiVersion, apiGroup);
                    this.addClassesToPropertyFiles(clazz);
                } else {
                    this.annotate(clazz, apiVersion, apiGroup);
                    this.pendingResources.put(resourceName, clazz);
                }
            }
        }
    }

    private void annotate(JDefinedClass clazz, String apiVersion, String apiGroup) {
        clazz.annotate(Version.class).param(ANNOTATION_VALUE, apiVersion);
        clazz.annotate(Group.class).param(ANNOTATION_VALUE, apiGroup);
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
        if (this.moduleName == null) {
            this.moduleName = schema.get("$module").textValue();
        }
        if (schema.has("serializer")) {
            this.annotateSerde(clazz, JsonSerialize.class, schema.get("serializer").asText());
        }
        if (schema.has("deserializer")) {
            this.annotateSerde(clazz, JsonDeserialize.class, schema.get("deserializer").asText());
        } else {
            clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        }
        super.propertyInclusion(clazz, schema);
    }

    private void annotateSerde(JDefinedClass clazz, Class<? extends Annotation> annotation, String usingClassName) {
        if (!usingClassName.endsWith(".class")) {
            usingClassName = usingClassName + ".class";
        }
        clazz.annotate(annotation).param("using", (JExpression)this.literalExpression(usingClassName));
    }

    private JExpressionImpl literalExpression(final String literal) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p(literal);
            }
        };
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param(ANNOTATION_VALUE, (Enum)JsonInclude.Include.NON_EMPTY);
        }
    }

    protected void processBuildable(JDefinedClass clazz) {
        clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", false).param("generateBuilderPackage", true).param("lazyCollectionInitEnabled", false).param("builderPackage", "io.fabric8.kubernetes.api.builder");
    }

    protected void addClassesToPropertyFiles(JDefinedClass clazz) {
        String packageCategory = this.getPackageCategory(clazz.getPackage().name());
        if (this.moduleName.equals(packageCategory)) {
            JAnnotationArrayMember arrayMember = clazz.annotate(TemplateTransformations.class).paramArray(ANNOTATION_VALUE);
            arrayMember.annotate(TemplateTransformation.class).param(ANNOTATION_VALUE, "/manifest.vm").param("outputPath", this.moduleName + ".properties").param("gather", true);
        }
    }

    private String getPackageCategory(String packageName) {
        if (packageName.isEmpty()) {
            return null;
        }
        if (packageName.equals("io.fabric8.kubernetes.api.model")) {
            return CORE_PACKAGE;
        }
        if (packageName.equals("io.fabric8.openshift.api.model")) {
            return OPENSHIFT_PACKAGE;
        }
        String[] parts = packageName.split("\\.");
        if (parts.length < 6) {
            throw new IllegalArgumentException("Invalid package name encountered: " + packageName);
        }
        return parts[5];
    }
}

