package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPURLRewriteFilterFluent<A extends HTTPURLRewriteFilterFluent<A>> extends BaseFluent<A>{
  public HTTPURLRewriteFilterFluent() {
  }
  
  public HTTPURLRewriteFilterFluent(HTTPURLRewriteFilter instance) {
    this.copyInstance(instance);
  }
  private String hostname;
  private HTTPPathModifierBuilder path;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPURLRewriteFilter instance) {
    instance = (instance != null ? instance : new HTTPURLRewriteFilter());
    if (instance != null) {
          this.withHostname(instance.getHostname());
          this.withPath(instance.getPath());
          this.withHostname(instance.getHostname());
          this.withPath(instance.getPath());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getHostname() {
    return this.hostname;
  }
  
  public A withHostname(String hostname) {
    this.hostname = hostname;
    return (A) this;
  }
  
  public boolean hasHostname() {
    return this.hostname != null;
  }
  
  public HTTPPathModifier buildPath() {
    return this.path != null ? this.path.build() : null;
  }
  
  public A withPath(HTTPPathModifier path) {
    this._visitables.remove(this.path);
    if (path != null) {
        this.path = new HTTPPathModifierBuilder(path);
        this._visitables.get("path").add(this.path);
    } else {
        this.path = null;
        this._visitables.get("path").remove(this.path);
    }
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public A withNewPath(String replaceFullPath,String replacePrefixMatch,String type) {
    return (A)withPath(new HTTPPathModifier(replaceFullPath, replacePrefixMatch, type));
  }
  
  public PathNested<A> withNewPath() {
    return new PathNested(null);
  }
  
  public PathNested<A> withNewPathLike(HTTPPathModifier item) {
    return new PathNested(item);
  }
  
  public PathNested<A> editPath() {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(null));
  }
  
  public PathNested<A> editOrNewPath() {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(new HTTPPathModifierBuilder().build()));
  }
  
  public PathNested<A> editOrNewPathLike(HTTPPathModifier item) {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPURLRewriteFilterFluent that = (HTTPURLRewriteFilterFluent) o;
    if (!java.util.Objects.equals(hostname, that.hostname)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostname,  path,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PathNested<N> extends HTTPPathModifierFluent<PathNested<N>> implements Nested<N>{
    PathNested(HTTPPathModifier item) {
      this.builder = new HTTPPathModifierBuilder(this, item);
    }
    HTTPPathModifierBuilder builder;
    
    public N and() {
      return (N) HTTPURLRewriteFilterFluent.this.withPath(builder.build());
    }
    
    public N endPath() {
      return and();
    }
    
  
  }

}