package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRouteFilterFluent<A extends HTTPRouteFilterFluent<A>> extends BaseFluent<A>{
  public HTTPRouteFilterFluent() {
  }
  
  public HTTPRouteFilterFluent(HTTPRouteFilter instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder extensionRef;
  private HTTPHeaderFilterBuilder requestHeaderModifier;
  private HTTPRequestMirrorFilterBuilder requestMirror;
  private HTTPRequestRedirectFilterBuilder requestRedirect;
  private HTTPHeaderFilterBuilder responseHeaderModifier;
  private String type;
  private HTTPURLRewriteFilterBuilder urlRewrite;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRouteFilter instance) {
    instance = (instance != null ? instance : new HTTPRouteFilter());
    if (instance != null) {
          this.withExtensionRef(instance.getExtensionRef());
          this.withRequestHeaderModifier(instance.getRequestHeaderModifier());
          this.withRequestMirror(instance.getRequestMirror());
          this.withRequestRedirect(instance.getRequestRedirect());
          this.withResponseHeaderModifier(instance.getResponseHeaderModifier());
          this.withType(instance.getType());
          this.withUrlRewrite(instance.getUrlRewrite());
          this.withExtensionRef(instance.getExtensionRef());
          this.withRequestHeaderModifier(instance.getRequestHeaderModifier());
          this.withRequestMirror(instance.getRequestMirror());
          this.withRequestRedirect(instance.getRequestRedirect());
          this.withResponseHeaderModifier(instance.getResponseHeaderModifier());
          this.withType(instance.getType());
          this.withUrlRewrite(instance.getUrlRewrite());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LocalObjectReference buildExtensionRef() {
    return this.extensionRef != null ? this.extensionRef.build() : null;
  }
  
  public A withExtensionRef(LocalObjectReference extensionRef) {
    this._visitables.remove(this.extensionRef);
    if (extensionRef != null) {
        this.extensionRef = new LocalObjectReferenceBuilder(extensionRef);
        this._visitables.get("extensionRef").add(this.extensionRef);
    } else {
        this.extensionRef = null;
        this._visitables.get("extensionRef").remove(this.extensionRef);
    }
    return (A) this;
  }
  
  public boolean hasExtensionRef() {
    return this.extensionRef != null;
  }
  
  public A withNewExtensionRef(String group,String kind,String name) {
    return (A)withExtensionRef(new LocalObjectReference(group, kind, name));
  }
  
  public ExtensionRefNested<A> withNewExtensionRef() {
    return new ExtensionRefNested(null);
  }
  
  public ExtensionRefNested<A> withNewExtensionRefLike(LocalObjectReference item) {
    return new ExtensionRefNested(item);
  }
  
  public ExtensionRefNested<A> editExtensionRef() {
    return withNewExtensionRefLike(java.util.Optional.ofNullable(buildExtensionRef()).orElse(null));
  }
  
  public ExtensionRefNested<A> editOrNewExtensionRef() {
    return withNewExtensionRefLike(java.util.Optional.ofNullable(buildExtensionRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ExtensionRefNested<A> editOrNewExtensionRefLike(LocalObjectReference item) {
    return withNewExtensionRefLike(java.util.Optional.ofNullable(buildExtensionRef()).orElse(item));
  }
  
  public HTTPHeaderFilter buildRequestHeaderModifier() {
    return this.requestHeaderModifier != null ? this.requestHeaderModifier.build() : null;
  }
  
  public A withRequestHeaderModifier(HTTPHeaderFilter requestHeaderModifier) {
    this._visitables.remove(this.requestHeaderModifier);
    if (requestHeaderModifier != null) {
        this.requestHeaderModifier = new HTTPHeaderFilterBuilder(requestHeaderModifier);
        this._visitables.get("requestHeaderModifier").add(this.requestHeaderModifier);
    } else {
        this.requestHeaderModifier = null;
        this._visitables.get("requestHeaderModifier").remove(this.requestHeaderModifier);
    }
    return (A) this;
  }
  
  public boolean hasRequestHeaderModifier() {
    return this.requestHeaderModifier != null;
  }
  
  public RequestHeaderModifierNested<A> withNewRequestHeaderModifier() {
    return new RequestHeaderModifierNested(null);
  }
  
  public RequestHeaderModifierNested<A> withNewRequestHeaderModifierLike(HTTPHeaderFilter item) {
    return new RequestHeaderModifierNested(item);
  }
  
  public RequestHeaderModifierNested<A> editRequestHeaderModifier() {
    return withNewRequestHeaderModifierLike(java.util.Optional.ofNullable(buildRequestHeaderModifier()).orElse(null));
  }
  
  public RequestHeaderModifierNested<A> editOrNewRequestHeaderModifier() {
    return withNewRequestHeaderModifierLike(java.util.Optional.ofNullable(buildRequestHeaderModifier()).orElse(new HTTPHeaderFilterBuilder().build()));
  }
  
  public RequestHeaderModifierNested<A> editOrNewRequestHeaderModifierLike(HTTPHeaderFilter item) {
    return withNewRequestHeaderModifierLike(java.util.Optional.ofNullable(buildRequestHeaderModifier()).orElse(item));
  }
  
  public HTTPRequestMirrorFilter buildRequestMirror() {
    return this.requestMirror != null ? this.requestMirror.build() : null;
  }
  
  public A withRequestMirror(HTTPRequestMirrorFilter requestMirror) {
    this._visitables.remove(this.requestMirror);
    if (requestMirror != null) {
        this.requestMirror = new HTTPRequestMirrorFilterBuilder(requestMirror);
        this._visitables.get("requestMirror").add(this.requestMirror);
    } else {
        this.requestMirror = null;
        this._visitables.get("requestMirror").remove(this.requestMirror);
    }
    return (A) this;
  }
  
  public boolean hasRequestMirror() {
    return this.requestMirror != null;
  }
  
  public RequestMirrorNested<A> withNewRequestMirror() {
    return new RequestMirrorNested(null);
  }
  
  public RequestMirrorNested<A> withNewRequestMirrorLike(HTTPRequestMirrorFilter item) {
    return new RequestMirrorNested(item);
  }
  
  public RequestMirrorNested<A> editRequestMirror() {
    return withNewRequestMirrorLike(java.util.Optional.ofNullable(buildRequestMirror()).orElse(null));
  }
  
  public RequestMirrorNested<A> editOrNewRequestMirror() {
    return withNewRequestMirrorLike(java.util.Optional.ofNullable(buildRequestMirror()).orElse(new HTTPRequestMirrorFilterBuilder().build()));
  }
  
  public RequestMirrorNested<A> editOrNewRequestMirrorLike(HTTPRequestMirrorFilter item) {
    return withNewRequestMirrorLike(java.util.Optional.ofNullable(buildRequestMirror()).orElse(item));
  }
  
  public HTTPRequestRedirectFilter buildRequestRedirect() {
    return this.requestRedirect != null ? this.requestRedirect.build() : null;
  }
  
  public A withRequestRedirect(HTTPRequestRedirectFilter requestRedirect) {
    this._visitables.remove(this.requestRedirect);
    if (requestRedirect != null) {
        this.requestRedirect = new HTTPRequestRedirectFilterBuilder(requestRedirect);
        this._visitables.get("requestRedirect").add(this.requestRedirect);
    } else {
        this.requestRedirect = null;
        this._visitables.get("requestRedirect").remove(this.requestRedirect);
    }
    return (A) this;
  }
  
  public boolean hasRequestRedirect() {
    return this.requestRedirect != null;
  }
  
  public RequestRedirectNested<A> withNewRequestRedirect() {
    return new RequestRedirectNested(null);
  }
  
  public RequestRedirectNested<A> withNewRequestRedirectLike(HTTPRequestRedirectFilter item) {
    return new RequestRedirectNested(item);
  }
  
  public RequestRedirectNested<A> editRequestRedirect() {
    return withNewRequestRedirectLike(java.util.Optional.ofNullable(buildRequestRedirect()).orElse(null));
  }
  
  public RequestRedirectNested<A> editOrNewRequestRedirect() {
    return withNewRequestRedirectLike(java.util.Optional.ofNullable(buildRequestRedirect()).orElse(new HTTPRequestRedirectFilterBuilder().build()));
  }
  
  public RequestRedirectNested<A> editOrNewRequestRedirectLike(HTTPRequestRedirectFilter item) {
    return withNewRequestRedirectLike(java.util.Optional.ofNullable(buildRequestRedirect()).orElse(item));
  }
  
  public HTTPHeaderFilter buildResponseHeaderModifier() {
    return this.responseHeaderModifier != null ? this.responseHeaderModifier.build() : null;
  }
  
  public A withResponseHeaderModifier(HTTPHeaderFilter responseHeaderModifier) {
    this._visitables.remove(this.responseHeaderModifier);
    if (responseHeaderModifier != null) {
        this.responseHeaderModifier = new HTTPHeaderFilterBuilder(responseHeaderModifier);
        this._visitables.get("responseHeaderModifier").add(this.responseHeaderModifier);
    } else {
        this.responseHeaderModifier = null;
        this._visitables.get("responseHeaderModifier").remove(this.responseHeaderModifier);
    }
    return (A) this;
  }
  
  public boolean hasResponseHeaderModifier() {
    return this.responseHeaderModifier != null;
  }
  
  public ResponseHeaderModifierNested<A> withNewResponseHeaderModifier() {
    return new ResponseHeaderModifierNested(null);
  }
  
  public ResponseHeaderModifierNested<A> withNewResponseHeaderModifierLike(HTTPHeaderFilter item) {
    return new ResponseHeaderModifierNested(item);
  }
  
  public ResponseHeaderModifierNested<A> editResponseHeaderModifier() {
    return withNewResponseHeaderModifierLike(java.util.Optional.ofNullable(buildResponseHeaderModifier()).orElse(null));
  }
  
  public ResponseHeaderModifierNested<A> editOrNewResponseHeaderModifier() {
    return withNewResponseHeaderModifierLike(java.util.Optional.ofNullable(buildResponseHeaderModifier()).orElse(new HTTPHeaderFilterBuilder().build()));
  }
  
  public ResponseHeaderModifierNested<A> editOrNewResponseHeaderModifierLike(HTTPHeaderFilter item) {
    return withNewResponseHeaderModifierLike(java.util.Optional.ofNullable(buildResponseHeaderModifier()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public HTTPURLRewriteFilter buildUrlRewrite() {
    return this.urlRewrite != null ? this.urlRewrite.build() : null;
  }
  
  public A withUrlRewrite(HTTPURLRewriteFilter urlRewrite) {
    this._visitables.remove(this.urlRewrite);
    if (urlRewrite != null) {
        this.urlRewrite = new HTTPURLRewriteFilterBuilder(urlRewrite);
        this._visitables.get("urlRewrite").add(this.urlRewrite);
    } else {
        this.urlRewrite = null;
        this._visitables.get("urlRewrite").remove(this.urlRewrite);
    }
    return (A) this;
  }
  
  public boolean hasUrlRewrite() {
    return this.urlRewrite != null;
  }
  
  public UrlRewriteNested<A> withNewUrlRewrite() {
    return new UrlRewriteNested(null);
  }
  
  public UrlRewriteNested<A> withNewUrlRewriteLike(HTTPURLRewriteFilter item) {
    return new UrlRewriteNested(item);
  }
  
  public UrlRewriteNested<A> editUrlRewrite() {
    return withNewUrlRewriteLike(java.util.Optional.ofNullable(buildUrlRewrite()).orElse(null));
  }
  
  public UrlRewriteNested<A> editOrNewUrlRewrite() {
    return withNewUrlRewriteLike(java.util.Optional.ofNullable(buildUrlRewrite()).orElse(new HTTPURLRewriteFilterBuilder().build()));
  }
  
  public UrlRewriteNested<A> editOrNewUrlRewriteLike(HTTPURLRewriteFilter item) {
    return withNewUrlRewriteLike(java.util.Optional.ofNullable(buildUrlRewrite()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteFilterFluent that = (HTTPRouteFilterFluent) o;
    if (!java.util.Objects.equals(extensionRef, that.extensionRef)) return false;
    if (!java.util.Objects.equals(requestHeaderModifier, that.requestHeaderModifier)) return false;
    if (!java.util.Objects.equals(requestMirror, that.requestMirror)) return false;
    if (!java.util.Objects.equals(requestRedirect, that.requestRedirect)) return false;
    if (!java.util.Objects.equals(responseHeaderModifier, that.responseHeaderModifier)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(urlRewrite, that.urlRewrite)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(extensionRef,  requestHeaderModifier,  requestMirror,  requestRedirect,  responseHeaderModifier,  type,  urlRewrite,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extensionRef != null) { sb.append("extensionRef:"); sb.append(extensionRef + ","); }
    if (requestHeaderModifier != null) { sb.append("requestHeaderModifier:"); sb.append(requestHeaderModifier + ","); }
    if (requestMirror != null) { sb.append("requestMirror:"); sb.append(requestMirror + ","); }
    if (requestRedirect != null) { sb.append("requestRedirect:"); sb.append(requestRedirect + ","); }
    if (responseHeaderModifier != null) { sb.append("responseHeaderModifier:"); sb.append(responseHeaderModifier + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (urlRewrite != null) { sb.append("urlRewrite:"); sb.append(urlRewrite + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExtensionRefNested<N> extends LocalObjectReferenceFluent<ExtensionRefNested<N>> implements Nested<N>{
    ExtensionRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withExtensionRef(builder.build());
    }
    
    public N endExtensionRef() {
      return and();
    }
    
  
  }
  public class RequestHeaderModifierNested<N> extends HTTPHeaderFilterFluent<RequestHeaderModifierNested<N>> implements Nested<N>{
    RequestHeaderModifierNested(HTTPHeaderFilter item) {
      this.builder = new HTTPHeaderFilterBuilder(this, item);
    }
    HTTPHeaderFilterBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withRequestHeaderModifier(builder.build());
    }
    
    public N endRequestHeaderModifier() {
      return and();
    }
    
  
  }
  public class RequestMirrorNested<N> extends HTTPRequestMirrorFilterFluent<RequestMirrorNested<N>> implements Nested<N>{
    RequestMirrorNested(HTTPRequestMirrorFilter item) {
      this.builder = new HTTPRequestMirrorFilterBuilder(this, item);
    }
    HTTPRequestMirrorFilterBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withRequestMirror(builder.build());
    }
    
    public N endRequestMirror() {
      return and();
    }
    
  
  }
  public class RequestRedirectNested<N> extends HTTPRequestRedirectFilterFluent<RequestRedirectNested<N>> implements Nested<N>{
    RequestRedirectNested(HTTPRequestRedirectFilter item) {
      this.builder = new HTTPRequestRedirectFilterBuilder(this, item);
    }
    HTTPRequestRedirectFilterBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withRequestRedirect(builder.build());
    }
    
    public N endRequestRedirect() {
      return and();
    }
    
  
  }
  public class ResponseHeaderModifierNested<N> extends HTTPHeaderFilterFluent<ResponseHeaderModifierNested<N>> implements Nested<N>{
    ResponseHeaderModifierNested(HTTPHeaderFilter item) {
      this.builder = new HTTPHeaderFilterBuilder(this, item);
    }
    HTTPHeaderFilterBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withResponseHeaderModifier(builder.build());
    }
    
    public N endResponseHeaderModifier() {
      return and();
    }
    
  
  }
  public class UrlRewriteNested<N> extends HTTPURLRewriteFilterFluent<UrlRewriteNested<N>> implements Nested<N>{
    UrlRewriteNested(HTTPURLRewriteFilter item) {
      this.builder = new HTTPURLRewriteFilterBuilder(this, item);
    }
    HTTPURLRewriteFilterBuilder builder;
    
    public N and() {
      return (N) HTTPRouteFilterFluent.this.withUrlRewrite(builder.build());
    }
    
    public N endUrlRewrite() {
      return and();
    }
    
  
  }

}