package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayClassSpecBuilder extends GatewayClassSpecFluent<GatewayClassSpecBuilder> implements VisitableBuilder<GatewayClassSpec,GatewayClassSpecBuilder>{
  public GatewayClassSpecBuilder() {
    this(false);
  }
  public GatewayClassSpecBuilder(Boolean validationEnabled) {
    this(new GatewayClassSpec(), validationEnabled);
  }
  public GatewayClassSpecBuilder(GatewayClassSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayClassSpecBuilder(GatewayClassSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayClassSpec(), validationEnabled);
  }
  public GatewayClassSpecBuilder(GatewayClassSpecFluent<?> fluent,GatewayClassSpec instance) {
    this(fluent, instance, false);
  }
  public GatewayClassSpecBuilder(GatewayClassSpecFluent<?> fluent,GatewayClassSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GatewayClassSpec());

    if (instance != null) {
      fluent.withControllerName(instance.getControllerName());
      fluent.withDescription(instance.getDescription());
      fluent.withParametersRef(instance.getParametersRef());
      fluent.withControllerName(instance.getControllerName());
      fluent.withDescription(instance.getDescription());
      fluent.withParametersRef(instance.getParametersRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GatewayClassSpecBuilder(GatewayClassSpec instance) {
    this(instance,false);
  }
  public GatewayClassSpecBuilder(GatewayClassSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GatewayClassSpec());

    if (instance != null) {
      this.withControllerName(instance.getControllerName());
      this.withDescription(instance.getDescription());
      this.withParametersRef(instance.getParametersRef());
      this.withControllerName(instance.getControllerName());
      this.withDescription(instance.getDescription());
      this.withParametersRef(instance.getParametersRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GatewayClassSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayClassSpec build() {
    GatewayClassSpec buildable = new GatewayClassSpec(fluent.getControllerName(),fluent.getDescription(),fluent.buildParametersRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}