package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AllowedRoutesBuilder extends AllowedRoutesFluent<AllowedRoutesBuilder> implements VisitableBuilder<AllowedRoutes,AllowedRoutesBuilder>{
  public AllowedRoutesBuilder() {
    this(false);
  }
  public AllowedRoutesBuilder(Boolean validationEnabled) {
    this(new AllowedRoutes(), validationEnabled);
  }
  public AllowedRoutesBuilder(AllowedRoutesFluent<?> fluent) {
    this(fluent, false);
  }
  public AllowedRoutesBuilder(AllowedRoutesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AllowedRoutes(), validationEnabled);
  }
  public AllowedRoutesBuilder(AllowedRoutesFluent<?> fluent,AllowedRoutes instance) {
    this(fluent, instance, false);
  }
  public AllowedRoutesBuilder(AllowedRoutesFluent<?> fluent,AllowedRoutes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AllowedRoutes());

    if (instance != null) {
      fluent.withKinds(instance.getKinds());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withKinds(instance.getKinds());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AllowedRoutesBuilder(AllowedRoutes instance) {
    this(instance,false);
  }
  public AllowedRoutesBuilder(AllowedRoutes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AllowedRoutes());

    if (instance != null) {
      this.withKinds(instance.getKinds());
      this.withNamespaces(instance.getNamespaces());
      this.withKinds(instance.getKinds());
      this.withNamespaces(instance.getNamespaces());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AllowedRoutesFluent<?> fluent;
  Boolean validationEnabled;
  public AllowedRoutes build() {
    AllowedRoutes buildable = new AllowedRoutes(fluent.buildKinds(),fluent.buildNamespaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}