package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GRPCRouteMatchFluent<A extends GRPCRouteMatchFluent<A>> extends BaseFluent<A>{
  public GRPCRouteMatchFluent() {
  }
  public GRPCRouteMatchFluent(GRPCRouteMatch instance) {
    instance = (instance != null ? instance : new GRPCRouteMatch());

    if (instance != null) {
      this.withHeaders(instance.getHeaders());
      this.withMethod(instance.getMethod());
      this.withHeaders(instance.getHeaders());
      this.withMethod(instance.getMethod());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<GRPCHeaderMatchBuilder> headers = new ArrayList<GRPCHeaderMatchBuilder>();
  private GRPCMethodMatchBuilder method;
  private Map<String,Object> additionalProperties;
  public A addToHeaders(int index,GRPCHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
    if (index < 0 || index >= headers.size()) { _visitables.get("headers").add(builder); headers.add(builder); } else { _visitables.get("headers").add(index, builder); headers.add(index, builder);}
    return (A)this;
  }
  public A setToHeaders(int index,GRPCHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
    if (index < 0 || index >= headers.size()) { _visitables.get("headers").add(builder); headers.add(builder); } else { _visitables.get("headers").set(index, builder); headers.set(index, builder);}
    return (A)this;
  }
  public A addToHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... items) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A addAllToHeaders(Collection<GRPCHeaderMatch> items) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A removeFromHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... items) {
    if (this.headers == null) return (A)this;
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").remove(builder); this.headers.remove(builder);} return (A)this;
  }
  public A removeAllFromHeaders(Collection<GRPCHeaderMatch> items) {
    if (this.headers == null) return (A)this;
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").remove(builder); this.headers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromHeaders(Predicate<GRPCHeaderMatchBuilder> predicate) {
    if (headers == null) return (A) this;
    final Iterator<GRPCHeaderMatchBuilder> each = headers.iterator();
    final List visitables = _visitables.get("headers");
    while (each.hasNext()) {
      GRPCHeaderMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GRPCHeaderMatch> buildHeaders() {
    return headers != null ? build(headers) : null;
  }
  public GRPCHeaderMatch buildHeader(int index) {
    return this.headers.get(index).build();
  }
  public GRPCHeaderMatch buildFirstHeader() {
    return this.headers.get(0).build();
  }
  public GRPCHeaderMatch buildLastHeader() {
    return this.headers.get(headers.size() - 1).build();
  }
  public GRPCHeaderMatch buildMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    for (GRPCHeaderMatchBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    for (GRPCHeaderMatchBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeaders(List<GRPCHeaderMatch> headers) {
    if (this.headers != null) { _visitables.get("headers").clear();}
    if (headers != null) {this.headers = new ArrayList(); for (GRPCHeaderMatch item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
  }
  public A withHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... headers) {
    if (this.headers != null) {this.headers.clear(); _visitables.remove("headers"); }
    if (headers != null) {for (GRPCHeaderMatch item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  public boolean hasHeaders() {
    return headers != null && !headers.isEmpty();
  }
  public A addNewHeader(String name,String type,String value) {
    return (A)addToHeaders(new GRPCHeaderMatch(name, type, value));
  }
  public HeadersNested<A> addNewHeader() {
    return new HeadersNested(-1, null);
  }
  public HeadersNested<A> addNewHeaderLike(GRPCHeaderMatch item) {
    return new HeadersNested(-1, item);
  }
  public HeadersNested<A> setNewHeaderLike(int index,GRPCHeaderMatch item) {
    return new HeadersNested(index, item);
  }
  public HeadersNested<A> editHeader(int index) {
    if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public HeadersNested<A> editFirstHeader() {
    if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  public HeadersNested<A> editLastHeader() {
    int index = headers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public HeadersNested<A> editMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<headers.size();i++) { 
    if (predicate.test(headers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public GRPCMethodMatch buildMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public A withMethod(GRPCMethodMatch method) {
    _visitables.get("method").remove(this.method);
    if (method!=null){ this.method= new GRPCMethodMatchBuilder(method); _visitables.get("method").add(this.method);} else { this.method = null; _visitables.get("method").remove(this.method); } return (A) this;
  }
  public boolean hasMethod() {
    return this.method != null;
  }
  public A withNewMethod(String method,String service,String type) {
    return (A)withMethod(new GRPCMethodMatch(method, service, type));
  }
  public MethodNested<A> withNewMethod() {
    return new MethodNested(null);
  }
  public MethodNested<A> withNewMethodLike(GRPCMethodMatch item) {
    return new MethodNested(item);
  }
  public MethodNested<A> editMethod() {
    return withNewMethodLike(java.util.Optional.ofNullable(buildMethod()).orElse(null));
  }
  public MethodNested<A> editOrNewMethod() {
    return withNewMethodLike(java.util.Optional.ofNullable(buildMethod()).orElse(new GRPCMethodMatchBuilder().build()));
  }
  public MethodNested<A> editOrNewMethodLike(GRPCMethodMatch item) {
    return withNewMethodLike(java.util.Optional.ofNullable(buildMethod()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GRPCRouteMatchFluent that = (GRPCRouteMatchFluent) o;
    if (!java.util.Objects.equals(headers, that.headers)) return false;

    if (!java.util.Objects.equals(method, that.method)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(headers,  method,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HeadersNested<N> extends GRPCHeaderMatchFluent<HeadersNested<N>> implements Nested<N>{
    HeadersNested(int index,GRPCHeaderMatch item) {
      this.index = index;
      this.builder = new GRPCHeaderMatchBuilder(this, item);
    }
    GRPCHeaderMatchBuilder builder;
    int index;
    public N and() {
      return (N) GRPCRouteMatchFluent.this.setToHeaders(index,builder.build());
    }
    public N endHeader() {
      return and();
    }
    
  }
  public class MethodNested<N> extends GRPCMethodMatchFluent<MethodNested<N>> implements Nested<N>{
    MethodNested(GRPCMethodMatch item) {
      this.builder = new GRPCMethodMatchBuilder(this, item);
    }
    GRPCMethodMatchBuilder builder;
    public N and() {
      return (N) GRPCRouteMatchFluent.this.withMethod(builder.build());
    }
    public N endMethod() {
      return and();
    }
    
  }
  
}