package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCBackendRefBuilder extends GRPCBackendRefFluent<GRPCBackendRefBuilder> implements VisitableBuilder<GRPCBackendRef,GRPCBackendRefBuilder>{
  public GRPCBackendRefBuilder() {
    this(false);
  }
  public GRPCBackendRefBuilder(Boolean validationEnabled) {
    this(new GRPCBackendRef(), validationEnabled);
  }
  public GRPCBackendRefBuilder(GRPCBackendRefFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCBackendRefBuilder(GRPCBackendRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCBackendRef(), validationEnabled);
  }
  public GRPCBackendRefBuilder(GRPCBackendRefFluent<?> fluent,GRPCBackendRef instance) {
    this(fluent, instance, false);
  }
  public GRPCBackendRefBuilder(GRPCBackendRefFluent<?> fluent,GRPCBackendRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GRPCBackendRef());

    if (instance != null) {
      fluent.withFilters(instance.getFilters());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withWeight(instance.getWeight());
      fluent.withFilters(instance.getFilters());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withWeight(instance.getWeight());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCBackendRefBuilder(GRPCBackendRef instance) {
    this(instance,false);
  }
  public GRPCBackendRefBuilder(GRPCBackendRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GRPCBackendRef());

    if (instance != null) {
      this.withFilters(instance.getFilters());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withWeight(instance.getWeight());
      this.withFilters(instance.getFilters());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withWeight(instance.getWeight());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCBackendRefFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCBackendRef build() {
    GRPCBackendRef buildable = new GRPCBackendRef(fluent.buildFilters(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPort(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}