package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteRuleBuilder extends HTTPRouteRuleFluentImpl<HTTPRouteRuleBuilder> implements VisitableBuilder<HTTPRouteRule,HTTPRouteRuleBuilder>{
  public HTTPRouteRuleBuilder() {
    this(false);
  }
  public HTTPRouteRuleBuilder(Boolean validationEnabled) {
    this(new HTTPRouteRule(), validationEnabled);
  }
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteRule(), validationEnabled);
  }
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent,HTTPRouteRule instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent,HTTPRouteRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBackendRefs(instance.getBackendRefs());
      fluent.withFilters(instance.getFilters());
      fluent.withMatches(instance.getMatches());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteRuleBuilder(HTTPRouteRule instance) {
    this(instance,false);
  }
  public HTTPRouteRuleBuilder(HTTPRouteRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBackendRefs(instance.getBackendRefs());
      this.withFilters(instance.getFilters());
      this.withMatches(instance.getMatches());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteRuleFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteRule build() {
    HTTPRouteRule buildable = new HTTPRouteRule(fluent.getBackendRefs(),fluent.getFilters(),fluent.getMatches());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}