package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPPathModifierBuilder extends HTTPPathModifierFluentImpl<HTTPPathModifierBuilder> implements VisitableBuilder<HTTPPathModifier,HTTPPathModifierBuilder>{
  public HTTPPathModifierBuilder() {
    this(false);
  }
  public HTTPPathModifierBuilder(Boolean validationEnabled) {
    this(new HTTPPathModifier(), validationEnabled);
  }
  public HTTPPathModifierBuilder(HTTPPathModifierFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPPathModifierBuilder(HTTPPathModifierFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPPathModifier(), validationEnabled);
  }
  public HTTPPathModifierBuilder(HTTPPathModifierFluent<?> fluent,HTTPPathModifier instance) {
    this(fluent, instance, false);
  }
  public HTTPPathModifierBuilder(HTTPPathModifierFluent<?> fluent,HTTPPathModifier instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withReplaceFullPath(instance.getReplaceFullPath());
      fluent.withReplacePrefixMatch(instance.getReplacePrefixMatch());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPPathModifierBuilder(HTTPPathModifier instance) {
    this(instance,false);
  }
  public HTTPPathModifierBuilder(HTTPPathModifier instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withReplaceFullPath(instance.getReplaceFullPath());
      this.withReplacePrefixMatch(instance.getReplacePrefixMatch());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPPathModifierFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPPathModifier build() {
    HTTPPathModifier buildable = new HTTPPathModifier(fluent.getReplaceFullPath(),fluent.getReplacePrefixMatch(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}