package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPHeaderBuilder extends HTTPHeaderFluentImpl<HTTPHeaderBuilder> implements VisitableBuilder<HTTPHeader,HTTPHeaderBuilder>{
  public HTTPHeaderBuilder() {
    this(false);
  }
  public HTTPHeaderBuilder(Boolean validationEnabled) {
    this(new HTTPHeader(), validationEnabled);
  }
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPHeader(), validationEnabled);
  }
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,HTTPHeader instance) {
    this(fluent, instance, false);
  }
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,HTTPHeader instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPHeaderBuilder(HTTPHeader instance) {
    this(instance,false);
  }
  public HTTPHeaderBuilder(HTTPHeader instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPHeaderFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPHeader build() {
    HTTPHeader buildable = new HTTPHeader(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}