package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteRuleBuilder extends TCPRouteRuleFluentImpl<TCPRouteRuleBuilder> implements VisitableBuilder<TCPRouteRule,TCPRouteRuleBuilder>{
  public TCPRouteRuleBuilder() {
    this(false);
  }
  public TCPRouteRuleBuilder(Boolean validationEnabled) {
    this(new TCPRouteRule(), validationEnabled);
  }
  public TCPRouteRuleBuilder(TCPRouteRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteRuleBuilder(TCPRouteRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRouteRule(), validationEnabled);
  }
  public TCPRouteRuleBuilder(TCPRouteRuleFluent<?> fluent,TCPRouteRule instance) {
    this(fluent, instance, false);
  }
  public TCPRouteRuleBuilder(TCPRouteRuleFluent<?> fluent,TCPRouteRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBackendRefs(instance.getBackendRefs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteRuleBuilder(TCPRouteRule instance) {
    this(instance,false);
  }
  public TCPRouteRuleBuilder(TCPRouteRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBackendRefs(instance.getBackendRefs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPRouteRuleFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRouteRule build() {
    TCPRouteRule buildable = new TCPRouteRule(fluent.getBackendRefs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}