package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteBuilder extends TCPRouteFluentImpl<TCPRouteBuilder> implements VisitableBuilder<TCPRoute,TCPRouteBuilder>{
  public TCPRouteBuilder() {
    this(false);
  }
  public TCPRouteBuilder(Boolean validationEnabled) {
    this(new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance) {
    this(fluent, instance, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteBuilder(TCPRoute instance) {
    this(instance,false);
  }
  public TCPRouteBuilder(TCPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRoute build() {
    TCPRoute buildable = new TCPRoute(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}